/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.wordnet;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.relationship.Relationship;
import net.didion.jwnl.data.relationship.RelationshipFinder;
import net.didion.jwnl.data.relationship.RelationshipList;
import net.didion.jwnl.dictionary.Dictionary;

public class DictInstance {
    String propsFile;

    public DictInstance(String s) {
        this.propsFile = s;
        try {
            JWNL.initialize((InputStream)new FileInputStream(this.propsFile));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public int getCommonSynonyms(String requirements, String candidate) throws JWNLException {
        int depth = 100;
        int requirementsIndex = 0;
        int candidateIndex = 0;
        IndexWord requirementsNoun = Dictionary.getInstance().lookupIndexWord(POS.NOUN, requirements);
        IndexWord requirementsVerb = Dictionary.getInstance().lookupIndexWord(POS.VERB, requirements);
        IndexWord candidateNoun = Dictionary.getInstance().lookupIndexWord(POS.NOUN, candidate);
        IndexWord candidateVerb = Dictionary.getInstance().lookupIndexWord(POS.VERB, candidate);
        if (requirementsNoun != null && candidateNoun != null) {
            int i = 1;
            while (i <= requirementsNoun.getSenseCount()) {
                int j = 1;
                while (j <= candidateNoun.getSenseCount()) {
                    Relationship shallowest;
                    RelationshipList list = RelationshipFinder.getInstance().findRelationships(requirementsNoun.getSense(i), candidateNoun.getSense(j), PointerType.SIMILAR_TO);
                    if (!list.isEmpty() && (shallowest = list.getShallowest()).getDepth() < depth) {
                        depth = shallowest.getDepth();
                        requirementsIndex = i;
                        candidateIndex = j;
                    }
                    ++j;
                }
                ++i;
            }
            return depth;
        }
        return depth;
    }

    public int getHypernymRelation(String requirements, String candidate) throws JWNLException {
        int depth = 100;
        int requirementsIndex = 0;
        int candidateIndex = 0;
        IndexWord requirementsNoun = Dictionary.getInstance().lookupIndexWord(POS.NOUN, requirements);
        IndexWord requirementsVerb = Dictionary.getInstance().lookupIndexWord(POS.VERB, requirements);
        IndexWord candidateNoun = Dictionary.getInstance().lookupIndexWord(POS.NOUN, candidate);
        IndexWord candidateVerb = Dictionary.getInstance().lookupIndexWord(POS.VERB, candidate);
        if (requirementsNoun != null && candidateNoun != null) {
            int i = 1;
            while (i <= requirementsNoun.getSenseCount()) {
                int j = 1;
                while (j <= candidateNoun.getSenseCount()) {
                    Relationship shallowest;
                    RelationshipList list = RelationshipFinder.getInstance().findRelationships(requirementsNoun.getSense(i), candidateNoun.getSense(j), PointerType.HYPERNYM);
                    if (!list.isEmpty() && (shallowest = list.getShallowest()).getDepth() < depth) {
                        depth = shallowest.getDepth();
                        requirementsIndex = i;
                        candidateIndex = j;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return depth;
    }

    public int getDerivedRelation(String requirements, String candidate) throws JWNLException {
        System.out.println("\n+++DerivedRelation+++\n");
        int depth = 100;
        int requirementsIndex = 0;
        int candidateIndex = 0;
        IndexWord requirementsNoun = Dictionary.getInstance().getIndexWord(POS.NOUN, requirements);
        IndexWord requirementsVerb = Dictionary.getInstance().getIndexWord(POS.VERB, requirements);
        IndexWord candidateNoun = Dictionary.getInstance().getIndexWord(POS.NOUN, candidate);
        IndexWord candidateVerb = Dictionary.getInstance().getIndexWord(POS.VERB, candidate);
        int i = 1;
        while (i <= requirementsNoun.getSenseCount()) {
            int j = 1;
            while (j <= candidateNoun.getSenseCount()) {
                Relationship shallowest;
                RelationshipList list = RelationshipFinder.getInstance().findRelationships(requirementsNoun.getSense(i), candidateNoun.getSense(j), PointerType.DERIVED);
                if (!list.isEmpty() && (shallowest = list.getShallowest()).getDepth() < depth) {
                    depth = shallowest.getDepth();
                    requirementsIndex = i;
                    candidateIndex = j;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("\n result: depth=" + depth + " requirementsindex=" + requirementsIndex + " candidateindex=" + candidateIndex);
        return depth;
    }

    public int getCategoryRelation(String requirements, String candidate) throws JWNLException {
        System.out.println("\n+++CategoryRelation+++\n");
        int depth = 100;
        int requirementsIndex = 0;
        int candidateIndex = 0;
        IndexWord requirementsNoun = Dictionary.getInstance().getIndexWord(POS.NOUN, requirements);
        IndexWord requirementsVerb = Dictionary.getInstance().getIndexWord(POS.VERB, requirements);
        IndexWord candidateNoun = Dictionary.getInstance().getIndexWord(POS.NOUN, candidate);
        IndexWord candidateVerb = Dictionary.getInstance().getIndexWord(POS.VERB, candidate);
        int i = 1;
        while (i <= requirementsNoun.getSenseCount()) {
            int j = 1;
            while (j <= candidateNoun.getSenseCount()) {
                RelationshipList list = RelationshipFinder.getInstance().findRelationships(requirementsNoun.getSense(i), candidateNoun.getSense(j), PointerType.CATEGORY);
                if (!list.isEmpty()) {
                    this.printRelationshipList(list);
                    Relationship shallowest = list.getShallowest();
                    System.out.println("\nshallowest: requirements " + shallowest.getSourcePointerTarget().toString());
                    System.out.println("\nshallowest: candidate " + shallowest.getTargetPointerTarget().toString());
                    System.out.println("depth: " + shallowest.getDepth());
                    if (shallowest.getDepth() < depth) {
                        depth = shallowest.getDepth();
                        requirementsIndex = i;
                        candidateIndex = j;
                    }
                }
                ++j;
            }
            ++i;
        }
        System.out.println("\n result: depth=" + depth + " requirementsindex=" + requirementsIndex + " candidateindex=" + candidateIndex);
        return depth;
    }

    private void printRelationshipList(RelationshipList l) {
        System.out.println("\n++ RelationshipList ++\n");
        Iterator relationIterator = l.iterator();
        while (relationIterator.hasNext()) {
            ((Relationship)relationIterator.next()).getNodeList().print();
        }
        System.out.println("\n");
    }
}

