/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import com.clarkparsia.pellet.owlapiv3.EntailmentQueryVisitor;
import com.clarkparsia.pellet.owlapiv3.Reasoner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.inference.OWLReasonerException;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntailmentChecker
implements OWLAxiomVisitor {
    public static Logger log = Logger.getLogger(EntailmentChecker.class.getName());
    private Reasoner reasoner;
    private boolean isDeferred = false;
    private boolean isEntailed = false;
    private EntailmentQueryVisitor queryVisitor;

    public EntailmentChecker(Reasoner reasoner) {
        this.reasoner = reasoner;
        this.queryVisitor = new EntailmentQueryVisitor(reasoner.getLoader());
    }

    private void deferAxiom(OWLIndividualAxiom axiom) {
        this.isDeferred = true;
        axiom.accept((OWLAxiomVisitor)this.queryVisitor);
    }

    private boolean isEntailed(OWLAxiom axiom) {
        this.isDeferred = false;
        this.isEntailed = false;
        axiom.accept((OWLAxiomVisitor)this);
        return this.isDeferred || this.isEntailed;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        if (!axioms.isEmpty()) {
            this.queryVisitor.reset();
            for (OWLAxiom oWLAxiom : axioms) {
                if (this.isEntailed(oWLAxiom)) continue;
                log.warning("Axiom not entailed: (" + oWLAxiom + ")");
                return false;
            }
            return this.queryVisitor.isEntailed();
        }
        log.warning("Empty ontologies are entailed by any premise document!");
        return true;
    }

    private OWLObjectProperty _getProperty(OWLObjectPropertyExpression pe) {
        while (pe.isAnonymous()) {
            pe = ((OWLObjectInverseOf)pe).getInverse();
        }
        return (OWLObjectProperty)pe;
    }

    private OWLPropertyExpression _normalize(OWLPropertyExpression pe) {
        OWLPropertyExpression inverse = null;
        boolean returnInv = false;
        while (pe.isAnonymous()) {
            inverse = pe;
            pe = ((OWLObjectInverseOf)pe).getInverse();
            returnInv = !returnInv;
        }
        return returnInv ? inverse : pe;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.isEntailed = this.reasoner.isSubClassOf(axiom.getSubClass(), axiom.getSuperClass());
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        OWLIndividual o = (OWLIndividual)axiom.getObject();
        if (s.isAnonymous() || o.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        OWLDataFactory factory = this.reasoner.getManager().getOWLDataFactory();
        OWLObjectHasValue hasValue = factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)o.asNamedIndividual());
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf((OWLClassExpression)hasValue);
        try {
            this.isEntailed = this.reasoner.hasType(s.asNamedIndividual(), (OWLClassExpression)doesNotHaveValue, false);
        }
        catch (OWLReasonerException e) {
            String msg = "Unexpected reasoner exception while checking entailment of negative object property assertion axiom: " + axiom;
            throw new OWLRuntimeException(msg, (Throwable)e);
        }
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isAntiSymmetric((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isReflexive((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getClassExpressions().size();
        OWLClassExpression[] classes = axiom.getClassExpressions().toArray(new OWLClassExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointWith(classes[i], classes[j])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.isEntailed = this.reasoner.hasDomain((OWLDataProperty)axiom.getProperty(), axiom.getDomain());
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.isEntailed = this.reasoner.hasDomain((OWLObjectProperty)axiom.getProperty(), axiom.getDomain());
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getProperties().iterator();
        if (i.hasNext()) {
            OWLObjectProperty head = (OWLObjectProperty)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLObjectProperty next = (OWLObjectProperty)i.next();
                this.isEntailed = this.reasoner.isEquivalentProperty(head, next);
            }
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        if (s.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        OWLDataFactory factory = this.reasoner.getManager().getOWLDataFactory();
        OWLDataHasValue hasValue = factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf((OWLClassExpression)hasValue);
        try {
            this.isEntailed = this.reasoner.hasType(s.asNamedIndividual(), (OWLClassExpression)doesNotHaveValue, false);
        }
        catch (OWLReasonerException e) {
            String msg = "Unexpected reasoner exception while checking entailment of negative data property assertion axiom: " + axiom;
            throw new OWLRuntimeException(msg, (Throwable)e);
        }
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.isEntailed = true;
        for (OWLIndividual ind : axiom.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        ArrayList list = new ArrayList(axiom.getIndividuals());
        for (int i = 0; i < list.size() - 1; ++i) {
            OWLIndividual head = (OWLIndividual)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                OWLIndividual next = (OWLIndividual)list.get(j);
                if (this.reasoner.isDifferentFrom(head, next)) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getProperties().size();
        OWLDataProperty[] properties = axiom.getProperties().toArray(new OWLDataProperty[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointWith(properties[i], properties[j])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getProperties().size();
        OWLObjectProperty[] properties = axiom.getProperties().toArray(new OWLObjectProperty[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointWith(properties[i], properties[j])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.isEntailed = this.reasoner.hasRange((OWLObjectProperty)axiom.getProperty(), (OWLClassExpression)axiom.getRange());
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        OWLIndividual o = (OWLIndividual)axiom.getObject();
        if (s.isAnonymous() || o.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        this.isEntailed = this.reasoner.hasObjectPropertyRelationship(s.asNamedIndividual(), (OWLObjectPropertyExpression)axiom.getProperty(), o.asNamedIndividual());
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isFunctional((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.isEntailed = this.reasoner.isSubPropertyOf((OWLObjectProperty)axiom.getSubProperty(), (OWLObjectProperty)axiom.getSuperProperty());
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        throw new UnsupportedOperationException();
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        throw new UnsupportedOperationException();
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring declaration " + axiom);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isSymmetric((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.isEntailed = this.reasoner.hasRange((OWLDataProperty)axiom.getProperty(), (OWLDataRange)axiom.getRange());
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isFunctional((OWLDataProperty)axiom.getProperty());
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getProperties().iterator();
        if (i.hasNext()) {
            OWLDataProperty first = (OWLDataProperty)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLDataProperty next = (OWLDataProperty)i.next();
                this.isEntailed = this.reasoner.isEquivalentProperty(first, next);
            }
        }
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        OWLIndividual ind = axiom.getIndividual();
        OWLClassExpression c = axiom.getClassExpression();
        if (ind.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        try {
            this.isEntailed = this.reasoner.hasType(ind.asNamedIndividual(), c, false);
        }
        catch (OWLReasonerException e) {
            String msg = "Unexpected reasoner exception while checking entailment of class assertion axiom: " + axiom;
            throw new OWLRuntimeException(msg, (Throwable)e);
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getClassExpressions().iterator();
        if (i.hasNext()) {
            OWLClassExpression first = (OWLClassExpression)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLClassExpression next = (OWLClassExpression)i.next();
                this.isEntailed = this.reasoner.isEquivalentClass(first, next);
            }
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        if (s.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        this.isEntailed = this.reasoner.hasDataPropertyRelationship(s.asNamedIndividual(), (OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isTransitive((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isIrreflexive((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.isEntailed = this.reasoner.isSubPropertyOf((OWLDataProperty)axiom.getSubProperty(), (OWLDataProperty)axiom.getSuperProperty());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isInverseFunctional((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLHasKeyAxiom axiom) {
        throw new UnsupportedOperationException();
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        for (OWLIndividual ind : axiom.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            this.deferAxiom((OWLIndividualAxiom)axiom);
            return;
        }
        this.isEntailed = true;
        Iterator i = axiom.getIndividuals().iterator();
        if (i.hasNext()) {
            OWLIndividual first = (OWLIndividual)i.next();
            while (i.hasNext()) {
                OWLIndividual next = (OWLIndividual)i.next();
                if (this.reasoner.isSameAs(first, next)) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.isEntailed = this.reasoner.isInverseOf((OWLObjectProperty)axiom.getFirstProperty(), (OWLObjectProperty)axiom.getSecondProperty());
    }

    public void visit(SWRLRule rule) {
        throw new UnsupportedOperationException("Unsupported entailment query: " + rule);
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation assertion axiom " + axiom);
        }
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation property domain " + axiom);
        }
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation property range " + axiom);
        }
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring sub annotation property axiom " + axiom);
        }
    }
}

