/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import com.clarkparsia.pellet.owlapiv3.LimitedMapIRIMapper;
import com.clarkparsia.pellet.owlapiv3.Reasoner;
import java.util.Set;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.NonMappingOntologyIRIMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAPILoader
extends KBLoader {
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private Reasoner pellet = new Reasoner(this.manager);
    private LimitedMapIRIMapper iriMapper = new LimitedMapIRIMapper();

    public KnowledgeBase getKB() {
        return this.pellet.getKB();
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public Set<OWLOntology> getOntologies() {
        return this.manager.getOntologies();
    }

    public Reasoner getReasoner() {
        return this.pellet;
    }

    public void load() {
        this.pellet.loadOntologies(this.manager.getOntologies());
    }

    protected void parseFile(String file) {
        try {
            IRI fileIRI = IRI.create((String)file);
            this.iriMapper.addAllowedIRI(fileIRI);
            this.manager.loadOntology(fileIRI);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (OWLOntologyCreationIOException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setIgnoreImports(boolean ignoreImports) {
        if (ignoreImports) {
            this.manager.clearIRIMappers();
            this.manager.addIRIMapper((OWLOntologyIRIMapper)this.iriMapper);
            this.manager.setSilentMissingImportsHandling(true);
        } else {
            this.manager.clearIRIMappers();
            this.manager.addIRIMapper((OWLOntologyIRIMapper)new NonMappingOntologyIRIMapper());
            this.manager.setSilentMissingImportsHandling(false);
        }
    }

    public void clear() {
        this.iriMapper.clear();
        this.pellet.clearOntologies();
        for (OWLOntology ont : this.manager.getOntologies()) {
            this.manager.removeOntology(ont);
        }
    }
}

