/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.AxiomConverter;
import com.clarkparsia.pellet.owlapiv3.EntailmentChecker;
import com.clarkparsia.pellet.owlapiv3.PelletLoader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.inference.OWLReasoner;
import org.semanticweb.owlapi.inference.OWLReasonerException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    public static Logger log = Logger.getLogger(Reasoner.class.getName());
    private static final long serialVersionUID = 8438190652175258123L;
    private AxiomConverter converter;
    protected KnowledgeBase kb;
    private PelletLoader loader;
    private OWLOntologyManager manager;
    private OWLDataFactory factory;
    private EntityMapper<OWLIndividual> IND_MAPPER = new IndividualMapper();
    private EntityMapper<OWLLiteral> LIT_MAPPER = new LiteralMapper();
    private EntityMapper<OWLObjectProperty> OP_MAPPER = new ObjectPropertyMapper();
    private EntityMapper<OWLDataProperty> DP_MAPPER = new DataPropertyMapper();
    private EntityMapper<OWLDatatype> DT_MAPPER = new DatatypeMapper();
    private EntityMapper<OWLClass> CLASS_MAPPER = new ClassMapper();
    private EntityMapper<OWLClassExpression> DESC_MAPPER = this.CLASS_MAPPER;
    private EntityMapper<OWLDataRange> DR_MAPPER = this.DT_MAPPER;

    private static URI uri(ATermAppl term) {
        if (term.getArity() != 0) {
            throw new OWLRuntimeException("Trying to convert an anonymous term " + term);
        }
        try {
            return new URI(term.getName());
        }
        catch (URISyntaxException x) {
            throw new OWLRuntimeException("Cannot create URI from term " + x);
        }
    }

    public Reasoner(OWLOntologyManager manager) {
        this(manager, new KnowledgeBase());
    }

    public Reasoner(OWLOntologyManager manager, KnowledgeBase kb) {
        this.kb = kb;
        this.loader = new PelletLoader(kb);
        this.manager = manager;
        this.factory = manager.getOWLDataFactory();
        this.converter = new AxiomConverter(kb, this.factory);
        this.loader.setManager(manager);
    }

    public void classify() {
        this.kb.classify();
    }

    public void clearOntologies() {
        this.loader.clear();
    }

    public OWLAxiom convertAxiom(ATermAppl term) {
        return this.converter.convert(term);
    }

    public Set<OWLAxiom> convertAxioms(Set<ATermAppl> terms) throws OWLRuntimeException {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (ATermAppl term : terms) {
            OWLAxiom axiom = this.converter.convert(term);
            if (axiom == null) {
                throw new OWLRuntimeException("Cannot convert: " + term);
            }
            result.add(axiom);
        }
        return result;
    }

    public void dispose() {
        this.kb = null;
    }

    public Set<Set<OWLClass>> getAncestorClasses(OWLClassExpression c) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getAncestorProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p)), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getAncestorProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p)), this.OP_MAPPER);
    }

    public Set<OWLClass> getClasses() {
        return this.toOWLEntitySet(this.kb.getClasses(), this.CLASS_MAPPER);
    }

    public Set<OWLClass> getComplementClasses(OWLClassExpression c) {
        return this.toOWLEntitySet(this.kb.getComplements(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<OWLDataProperty> getDataProperties() {
        return this.toOWLEntitySet(this.kb.getDataProperties(), this.DP_MAPPER);
    }

    public Map<OWLDataProperty, Set<OWLLiteral>> getDataPropertyRelationships(OWLNamedIndividual individual) {
        HashMap<OWLDataProperty, Set<OWLLiteral>> values = new HashMap<OWLDataProperty, Set<OWLLiteral>>();
        Set<OWLDataProperty> dataProps = this.getDataProperties();
        for (OWLDataProperty prop : dataProps) {
            Set<OWLLiteral> set = this.getRelatedValues(individual, (OWLDataPropertyExpression)prop);
            if (set.isEmpty()) continue;
            values.put(prop, set);
        }
        return values;
    }

    public Set<Set<OWLClass>> getDescendantClasses(OWLClassExpression c) {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getDescendantProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), false), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getDescendantProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), false), this.OP_MAPPER);
    }

    public Set<OWLIndividual> getDifferentFromIndividuals(OWLIndividual ind) {
        return this.toOWLEntitySet(this.kb.getDifferents(this.loader.term((OWLObject)ind)), this.IND_MAPPER);
    }

    public Set<Set<OWLClass>> getDisjointClasses(OWLClassExpression c) {
        return this.toOWLEntitySetOfSet(this.kb.getDisjoints(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<Set<OWLClassExpression>> getDomains(OWLDataProperty p) {
        ATermAppl some = ATermUtils.makeSomeValues((ATerm)this.loader.term((OWLObject)p), (ATerm)ATermUtils.TOP_LIT);
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(some), this.DESC_MAPPER);
    }

    public Set<Set<OWLClassExpression>> getDomains(OWLObjectProperty p) {
        ATermAppl some = ATermUtils.makeSomeValues((ATerm)this.loader.term((OWLObject)p), (ATerm)ATermUtils.TOP);
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(some), this.DESC_MAPPER);
    }

    public Set<OWLClass> getEquivalentClasses(OWLClassExpression c) {
        return this.toOWLEntitySet(this.kb.getEquivalentClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<OWLClass> getAllEquivalentClasses(OWLClassExpression c) {
        return this.toOWLEntitySet(this.kb.getAllEquivalentClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<OWLDataProperty> getEquivalentProperties(OWLDataProperty p) {
        return this.toOWLEntitySet(this.kb.getEquivalentProperties(this.loader.term((OWLObject)p)), this.DP_MAPPER);
    }

    public Set<OWLObjectProperty> getEquivalentProperties(OWLObjectProperty p) {
        return this.toOWLEntitySet(this.kb.getEquivalentProperties(this.loader.term((OWLObject)p)), this.OP_MAPPER);
    }

    public Set<OWLAxiom> getExplanation() throws OWLRuntimeException {
        Set explanation = this.kb.getExplanationSet();
        if (explanation == null || explanation.isEmpty()) {
            throw new OWLRuntimeException("No explanation computed");
        }
        return this.convertAxioms(explanation);
    }

    public Set<OWLClass> getInconsistentClasses() {
        return this.toOWLEntitySet(this.kb.getUnsatisfiableClasses(), this.CLASS_MAPPER);
    }

    public Set<OWLIndividual> getIndividuals() {
        return this.toOWLEntitySet(this.kb.getIndividuals(), this.IND_MAPPER);
    }

    public Set<OWLNamedIndividual> getIndividuals(OWLClassExpression clsC, boolean direct) {
        Set<OWLIndividual> all = this.toOWLEntitySet(this.kb.getInstances(this.loader.term((OWLObject)clsC), direct), this.IND_MAPPER);
        HashSet<OWLNamedIndividual> ret = new HashSet<OWLNamedIndividual>(all.size());
        for (OWLIndividual i : all) {
            if (i.isAnonymous()) continue;
            ret.add(i.asNamedIndividual());
        }
        return ret;
    }

    public Set<Set<OWLObjectProperty>> getInverseProperties(OWLObjectProperty prop) {
        return Collections.singleton(this.toOWLEntitySet(this.kb.getInverses((ATerm)this.loader.term((OWLObject)prop)), this.OP_MAPPER));
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Set<OWLOntology> getLoadedOntologies() {
        return this.loader.getOntologies();
    }

    public PelletLoader getLoader() {
        return this.loader;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public Set<OWLObjectProperty> getObjectProperties() {
        return this.toOWLEntitySet(this.kb.getObjectProperties(), this.OP_MAPPER);
    }

    public Map<OWLObjectProperty, Set<OWLNamedIndividual>> getObjectPropertyRelationships(OWLNamedIndividual individual) {
        HashMap<OWLObjectProperty, Set<OWLNamedIndividual>> values = new HashMap<OWLObjectProperty, Set<OWLNamedIndividual>>();
        Set<OWLObjectProperty> objProps = this.getObjectProperties();
        for (OWLObjectProperty prop : objProps) {
            Set<OWLNamedIndividual> set = this.getRelatedIndividuals(individual, (OWLObjectPropertyExpression)prop);
            if (set.isEmpty()) continue;
            values.put(prop, set);
        }
        return values;
    }

    public Set<OWLProperty<?, ?>> getProperties() {
        HashSet properties = new HashSet();
        properties.addAll(this.getObjectProperties());
        properties.addAll(this.getDataProperties());
        return properties;
    }

    public Map<OWLIndividual, Set<OWLLiteral>> getDataPropertyAssertions(OWLDataProperty prop) {
        HashMap<OWLIndividual, Set<OWLLiteral>> map = new HashMap<OWLIndividual, Set<OWLLiteral>>();
        ATermAppl p = this.loader.term((OWLObject)prop);
        for (ATermAppl candidate : this.kb.getIndividuals()) {
            List list = this.kb.getDataPropertyValues(p, candidate);
            if (list.isEmpty()) continue;
            OWLIndividual subj = this.IND_MAPPER.map(candidate);
            Set<OWLLiteral> objects = this.toOWLEntitySet(list, this.LIT_MAPPER);
            map.put(subj, objects);
        }
        return map;
    }

    public Map<OWLIndividual, Set<OWLIndividual>> getObjectPropertyAssertions(OWLObjectProperty prop) {
        HashMap<OWLIndividual, Set<OWLIndividual>> result = new HashMap<OWLIndividual, Set<OWLIndividual>>();
        ATermAppl p = this.loader.term((OWLObject)prop);
        Map values = this.kb.getPropertyValues(p);
        for (Map.Entry entry : values.entrySet()) {
            ATermAppl subjTerm = (ATermAppl)entry.getKey();
            List objTerms = (List)entry.getValue();
            OWLIndividual subj = this.IND_MAPPER.map(subjTerm);
            Set<OWLIndividual> objects = this.toOWLEntitySet(objTerms, this.IND_MAPPER);
            result.put(subj, objects);
        }
        return result;
    }

    public Set<OWLDataRange> getRanges(OWLDataProperty p) {
        return this.toOWLEntitySet(this.kb.getRanges((ATerm)this.loader.term((OWLObject)p)), this.DR_MAPPER);
    }

    public Set<OWLClassExpression> getRanges(OWLObjectProperty p) {
        return this.toOWLEntitySet(this.kb.getRanges((ATerm)this.loader.term((OWLObject)p)), this.DESC_MAPPER);
    }

    public Set<OWLNamedIndividual> getRelatedIndividuals(OWLNamedIndividual subject, OWLObjectPropertyExpression property) {
        Set<OWLIndividual> all = this.toOWLEntitySet(this.kb.getObjectPropertyValues(this.loader.term((OWLObject)property), this.loader.term((OWLObject)subject)), this.IND_MAPPER);
        if (all.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<OWLNamedIndividual> ret = new HashSet<OWLNamedIndividual>(all.size());
        for (OWLIndividual ind : all) {
            if (ind.isAnonymous()) continue;
            ret.add(ind.asNamedIndividual());
        }
        return ret;
    }

    public Set<OWLLiteral> getRelatedValues(OWLNamedIndividual subject, OWLDataPropertyExpression property) {
        return this.toOWLEntitySet(this.kb.getDataPropertyValues(this.loader.term((OWLObject)property), this.loader.term((OWLObject)subject)), this.LIT_MAPPER);
    }

    public Set<OWLIndividual> getSameAsIndividuals(OWLIndividual ind) {
        return this.toOWLEntitySet(this.kb.getSames(this.loader.term((OWLObject)ind)), this.IND_MAPPER);
    }

    public Set<Set<OWLClass>> getSubClasses(OWLClassExpression c) {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c), true), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getSubProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), true), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getSubProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), true), this.OP_MAPPER);
    }

    public Set<Set<OWLClass>> getSuperClasses(OWLClassExpression c) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c), true), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getSuperProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p), true), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getSuperProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p), true), this.OP_MAPPER);
    }

    public Set<Set<OWLClass>> getTypes(OWLNamedIndividual ind, boolean direct) {
        return this.toOWLEntitySetOfSet(this.kb.getTypes(this.loader.term((OWLObject)ind), direct), this.CLASS_MAPPER);
    }

    public Set<OWLClass> getUnsatisfiableClasses() throws OWLReasonerException {
        return this.toOWLEntitySet(this.kb.getUnsatisfiableClasses(), this.CLASS_MAPPER);
    }

    public boolean hasDataPropertyRelationship(OWLNamedIndividual subject, OWLDataPropertyExpression property, OWLLiteral object) {
        return this.kb.hasPropertyValue(this.loader.term((OWLObject)subject), this.loader.term((OWLObject)property), this.loader.term((OWLObject)object));
    }

    public boolean hasDomain(OWLDataProperty p, OWLClassExpression c) {
        return this.kb.hasDomain(this.loader.term((OWLObject)p), this.loader.term((OWLObject)c));
    }

    public boolean hasDomain(OWLObjectProperty p, OWLClassExpression c) {
        return this.kb.hasDomain(this.loader.term((OWLObject)p), this.loader.term((OWLObject)c));
    }

    public boolean hasObjectPropertyRelationship(OWLNamedIndividual subject, OWLObjectPropertyExpression property, OWLNamedIndividual object) {
        return this.kb.hasPropertyValue(this.loader.term((OWLObject)subject), this.loader.term((OWLObject)property), this.loader.term((OWLObject)object));
    }

    public boolean hasRange(OWLDataProperty p, OWLDataRange d) {
        return this.kb.hasRange(this.loader.term((OWLObject)p), this.loader.term((OWLObject)d));
    }

    public boolean hasRange(OWLObjectProperty p, OWLClassExpression c) {
        return this.kb.hasRange(this.loader.term((OWLObject)p), this.loader.term((OWLObject)c));
    }

    public boolean hasType(OWLNamedIndividual individual, OWLClassExpression type, boolean direct) throws OWLReasonerException {
        if (direct) {
            return this.getTypes(individual, direct).contains(type);
        }
        return this.kb.isType(this.loader.term((OWLObject)individual), this.loader.term((OWLObject)type));
    }

    public boolean isAntiSymmetric(OWLObjectProperty p) {
        return this.kb.isAsymmetricProperty(this.loader.term((OWLObject)p));
    }

    public boolean isAsymmetric(OWLObjectProperty p) {
        return this.kb.isAsymmetricProperty(this.loader.term((OWLObject)p));
    }

    public boolean isClassified() {
        return this.kb.isClassified();
    }

    public boolean isComplementOf(OWLClassExpression c1, OWLClassExpression c2) {
        return this.kb.isComplement(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isConsistent() {
        return this.kb.isConsistent();
    }

    public boolean isConsistent(OWLClassExpression d) {
        return this.isSatisfiable(d);
    }

    public boolean isConsistent(OWLOntology ontology) {
        this.setOntology(ontology);
        return this.isConsistent();
    }

    public boolean isDefined(OWLClass cls) {
        ATermAppl term = this.loader.term((OWLObject)cls);
        return this.kb.isClass((ATerm)term);
    }

    public boolean isDefined(OWLDataProperty prop) {
        ATermAppl term = this.loader.term((OWLObject)prop);
        return this.kb.isDatatypeProperty((ATerm)term);
    }

    public boolean isDefined(OWLIndividual ind) {
        ATermAppl term = this.loader.term((OWLObject)ind);
        return this.kb.isIndividual((ATerm)term);
    }

    public boolean isDefined(OWLObjectProperty prop) {
        ATermAppl term = this.loader.term((OWLObject)prop);
        return this.kb.isObjectProperty((ATerm)term);
    }

    public boolean isDifferentFrom(OWLIndividual ind1, OWLIndividual ind2) {
        return this.kb.isDifferentFrom(this.loader.term((OWLObject)ind1), this.loader.term((OWLObject)ind2));
    }

    public boolean isDisjointWith(OWLDataProperty p1, OWLDataProperty p2) {
        return this.kb.isDisjointProperty(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isDisjointWith(OWLClassExpression c1, OWLClassExpression c2) {
        return this.kb.isDisjointClass(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isDisjointWith(OWLObjectProperty p1, OWLObjectProperty p2) {
        return this.kb.isDisjointProperty(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isEntailed(OWLOntology ont) {
        return this.isEntailed(ont.getAxioms());
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        EntailmentChecker entailmentChecker = new EntailmentChecker(this);
        return entailmentChecker.isEntailed(axioms);
    }

    public boolean isEntailed(OWLAxiom axiom) {
        return this.isEntailed(Collections.singleton(axiom));
    }

    public boolean isEquivalentClass(OWLClassExpression c1, OWLClassExpression c2) {
        return this.kb.isEquivalentClass(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isEquivalentProperty(OWLDataProperty p1, OWLDataProperty p2) {
        return this.kb.isEquivalentProperty(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isEquivalentProperty(OWLObjectProperty p1, OWLObjectProperty p2) {
        return this.kb.isEquivalentProperty(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isFunctional(OWLDataProperty p) {
        return this.kb.isFunctionalProperty(this.loader.term((OWLObject)p));
    }

    public boolean isFunctional(OWLObjectProperty p) {
        return this.kb.isFunctionalProperty(this.loader.term((OWLObject)p));
    }

    public boolean isInverseFunctional(OWLObjectProperty p) {
        return this.kb.isInverseFunctionalProperty(this.loader.term((OWLObject)p));
    }

    public boolean isInverseOf(OWLObjectProperty p1, OWLObjectProperty p2) {
        return this.kb.isInverse(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isIrreflexive(OWLObjectProperty p) {
        return this.kb.isIrreflexiveProperty(this.loader.term((OWLObject)p));
    }

    public boolean isRealised() throws OWLReasonerException {
        return this.kb.isRealized();
    }

    public boolean isReflexive(OWLObjectProperty p) {
        return this.kb.isReflexiveProperty(this.loader.term((OWLObject)p));
    }

    public boolean isSameAs(OWLIndividual ind1, OWLIndividual ind2) {
        return this.kb.isSameAs(this.loader.term((OWLObject)ind1), this.loader.term((OWLObject)ind2));
    }

    public boolean isSatisfiable(OWLClassExpression d) {
        if (!this.kb.isConsistent()) {
            return false;
        }
        return this.kb.isSatisfiable(this.loader.term((OWLObject)d));
    }

    public boolean isSubClassOf(OWLClassExpression c1, OWLClassExpression c2) {
        return this.kb.isSubClassOf(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isSubPropertyOf(OWLDataProperty c1, OWLDataProperty c2) {
        return this.kb.isSubPropertyOf(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isSubPropertyOf(OWLObjectProperty c1, OWLObjectProperty c2) {
        return this.kb.isSubPropertyOf(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isSubTypeOf(OWLDatatype d1, OWLDatatype d2) {
        return this.kb.isSubClassOf(this.loader.term((OWLObject)d1), this.loader.term((OWLObject)d2));
    }

    public boolean isSymmetric(OWLObjectProperty p) {
        return this.kb.isSymmetricProperty(this.loader.term((OWLObject)p));
    }

    public boolean isTransitive(OWLObjectProperty p) {
        return this.kb.isTransitiveProperty(this.loader.term((OWLObject)p));
    }

    public void loadOntologies(Set<OWLOntology> ontologies) {
        if (this.manager == null) {
            log.warning("Cannot load an ontology without an ontology manager. Use setManager(OWLOntologyManager) first.");
            return;
        }
        this.loader.load(ontologies);
    }

    public void loadOntology(OWLOntology ontology) {
        this.loadOntologies(Collections.singleton(ontology));
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        boolean changesApplied = this.loader.applyChanges(changes);
        if (!changesApplied) {
            this.refresh();
        }
    }

    public void realise() throws OWLReasonerException {
        this.kb.realize();
    }

    public void refresh() {
        this.loader.reload();
    }

    public void setOntology(OWLOntology ontology) {
        this.clearOntologies();
        this.loadOntologies(Collections.singleton(ontology));
    }

    private <T extends OWLObject> Set<Set<T>> toOWLEntitySetOfSet(Set<Set<ATermAppl>> setOfTerms, EntityMapper<T> mapper) {
        HashSet<Set<T>> results = new HashSet<Set<T>>();
        for (Set<ATermAppl> terms : setOfTerms) {
            Set<T> entitySet = this.toOWLEntitySet(terms, mapper);
            if (entitySet.isEmpty()) continue;
            results.add(entitySet);
        }
        return results;
    }

    private <T extends OWLObject> Set<T> toOWLEntitySet(Collection<ATermAppl> terms, EntityMapper<T> mapper) {
        HashSet<T> results = new HashSet<T>();
        for (ATermAppl term : terms) {
            results.add(mapper.map(term));
        }
        return results;
    }

    public void unloadOntologies(Set<OWLOntology> ontologies) {
        this.loader.unload(ontologies);
        this.refresh();
    }

    public void unloadOntology(OWLOntology ontology) {
        this.unloadOntologies(Collections.singleton(ontology));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassMapper
    implements EntityMapper<OWLClass> {
        private ClassMapper() {
        }

        @Override
        public OWLClass map(ATermAppl term) {
            if (term.equals(ATermUtils.TOP)) {
                return Reasoner.this.factory.getOWLThing();
            }
            if (term.equals(ATermUtils.BOTTOM)) {
                return Reasoner.this.factory.getOWLNothing();
            }
            return Reasoner.this.factory.getOWLClass(Reasoner.uri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DatatypeMapper
    implements EntityMapper<OWLDatatype> {
        private DatatypeMapper() {
        }

        @Override
        public OWLDatatype map(ATermAppl term) {
            return Reasoner.this.factory.getOWLDatatype(Reasoner.uri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyMapper
    implements EntityMapper<OWLDataProperty> {
        private DataPropertyMapper() {
        }

        @Override
        public OWLDataProperty map(ATermAppl term) {
            if (ATermUtils.TOP_DATA_PROPERTY.equals(term)) {
                return Reasoner.this.factory.getOWLTopDataProperty();
            }
            if (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term)) {
                return Reasoner.this.factory.getOWLBottomDataProperty();
            }
            return Reasoner.this.factory.getOWLDataProperty(Reasoner.uri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyMapper
    implements EntityMapper<OWLObjectProperty> {
        private ObjectPropertyMapper() {
        }

        @Override
        public OWLObjectProperty map(ATermAppl term) {
            if (ATermUtils.TOP_OBJECT_PROPERTY.equals(term)) {
                return Reasoner.this.factory.getOWLTopObjectProperty();
            }
            if (ATermUtils.BOTTOM_OBJECT_PROPERTY.equals(term)) {
                return Reasoner.this.factory.getOWLBottomObjectProperty();
            }
            return Reasoner.this.factory.getOWLObjectProperty(Reasoner.uri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LiteralMapper
    implements EntityMapper<OWLLiteral> {
        private LiteralMapper() {
        }

        @Override
        public OWLLiteral map(ATermAppl term) {
            String value = ((ATermAppl)term.getArgument(0)).getName();
            String lang = ((ATermAppl)term.getArgument(1)).getName();
            ATermAppl datatypeURI = (ATermAppl)term.getArgument(2);
            if (!datatypeURI.equals(ATermUtils.EMPTY)) {
                OWLDatatype datatype = (OWLDatatype)Reasoner.this.DT_MAPPER.map(datatypeURI);
                return Reasoner.this.factory.getOWLTypedLiteral(value, datatype);
            }
            if (lang.equals("")) {
                return Reasoner.this.factory.getOWLStringLiteral(value);
            }
            return Reasoner.this.factory.getOWLStringLiteral(value, lang);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndividualMapper
    implements EntityMapper<OWLIndividual> {
        private IndividualMapper() {
        }

        @Override
        public OWLIndividual map(ATermAppl term) {
            if (ATermUtils.isBnode((ATermAppl)term)) {
                return Reasoner.this.factory.getOWLAnonymousIndividual(((ATermAppl)term.getArgument(0)).getName());
            }
            return Reasoner.this.factory.getOWLNamedIndividual(Reasoner.uri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EntityMapper<T extends OWLObject> {
        public T map(ATermAppl var1);
    }
}

