/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.syntax;

import edu.unika.aifb.rdf.api.model.Literal;
import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.api.syntax.RDFWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RDFSerializer
extends RDFWriter {
    public void serialize(Model model, OutputStream outputStream, String string) throws IOException, ModelException {
        this.serialize(model, new OutputStreamWriter(outputStream, string), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Model model, Writer writer, String string) throws IOException, ModelException {
        try {
            Object object;
            Object object2;
            this.prepareNamespaceCollection();
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            arrayList = new ArrayList(model.thisSize());
            Iterator iterator = model.thisIterator();
            while (iterator.hasNext()) {
                object2 = (Statement)iterator.next();
                arrayList.add((Statement)object2);
                if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(object2.predicate().getURI())) {
                    this.collectNamespace(((Resource)object2.object()).getURI());
                } else if ("http://www.w3.org/2000/01/rdf-schema#subClassOf".equals(object2.predicate()) || "http://www.w3.org/2000/01/rdf-schema#subPropertyOf".equals(object2.predicate())) {
                    this.collectNamespace(object2.subject().getURI());
                    this.collectNamespace(((Resource)object2.object()).getURI());
                }
                this.collectNamespace(object2.predicate().getURI());
            }
            Collections.sort(arrayList, StatementComparator.INSTANCE);
            super.startSerialization(writer, model.getPhysicalURI(), model.getLogicalURI(), string);
            object2 = model.getIncludedModels();
            if (!object2.isEmpty()) {
                this.m_out.println();
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (Model)iterator2.next();
                    this.writeInclusion(object.getLogicalURI(), object.getPhysicalURI());
                }
            }
            this.writeModelAttributes(model.getAttributes());
            this.startRDFContents();
            int n = 0;
            while (n < arrayList.size()) {
                object = (Statement)arrayList.get(n);
                Resource resource = object.subject();
                Resource resource2 = object.predicate();
                RDFNode rDFNode = object.object();
                if (rDFNode instanceof Resource) {
                    this.writeStatement(resource.getURI(), resource2.getURI(), ((Resource)rDFNode).getURI(), null, null, false);
                } else {
                    Literal literal = (Literal)rDFNode;
                    this.writeStatement(resource.getURI(), resource2.getURI(), literal.getLabel(), literal.getLanguage(), literal.getDatatype(), true);
                }
                ++n;
            }
            this.finishRDFContents();
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.cleanUp();
            throw throwable;
        }
        this.cleanUp();
    }

    protected static class StatementComparator
    implements Comparator {
        protected static final StatementComparator INSTANCE = new StatementComparator();

        protected StatementComparator() {
        }

        protected int compare(RDFNode rDFNode, RDFNode rDFNode2) throws ModelException {
            return rDFNode.getLabel().compareTo(rDFNode2.getLabel());
        }

        protected boolean isSystemNamespace(RDFNode rDFNode) throws ModelException {
            if (rDFNode instanceof Resource) {
                String string = rDFNode.getLabel();
                return string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || string.startsWith("http://www.w3.org/2000/01/rdf-schema#");
            }
            return false;
        }

        public int compare(Object object, Object object2) {
            try {
                Statement statement = (Statement)object;
                Statement statement2 = (Statement)object2;
                int n = this.compare(statement.subject(), statement2.subject());
                if (n != 0) {
                    return n;
                }
                n = this.compare(statement.predicate(), statement2.predicate());
                if (n != 0) {
                    return n;
                }
                RDFNode rDFNode = statement.object();
                RDFNode rDFNode2 = statement2.object();
                boolean bl = this.isSystemNamespace(rDFNode);
                boolean bl2 = this.isSystemNamespace(rDFNode2);
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
                return this.compare(rDFNode, rDFNode2);
            }
            catch (ModelException modelException) {
                return 0;
            }
        }
    }
}

