/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.util;

import edu.unika.aifb.rdf.api.model.Literal;
import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class ModelConsumer
implements RDFConsumer {
    protected Model m_model;
    protected List m_includedModels = new ArrayList();

    public ModelConsumer() {
        this(null);
    }

    public ModelConsumer(Model model) {
        this.initialize(model);
    }

    public void initialize(Model model) {
        this.m_model = model;
    }

    public void startModel(String string) throws SAXException {
        try {
            if (this.m_model.supportsTransactions()) {
                this.m_model.setAutocommit(true);
            }
            this.m_model.setPhysicalURI(string);
        }
        catch (ModelException modelException) {
            throw new SAXException("RDF exception", modelException);
        }
    }

    public void endModel() throws SAXException {
    }

    public void statementWithResourceValue(String string, String string2, String string3) throws SAXException {
        try {
            NodeFactory nodeFactory = this.m_model.getNodeFactory();
            Resource resource = nodeFactory.createResource(string);
            Resource resource2 = nodeFactory.createResource(string2);
            Resource resource3 = nodeFactory.createResource(string3);
            Statement statement = nodeFactory.createStatement(resource, resource2, resource3);
            this.m_model.add(statement);
        }
        catch (ModelException modelException) {
            throw new SAXException("RDF exception", modelException);
        }
    }

    public void statementWithLiteralValue(String string, String string2, String string3, String string4, String string5) throws SAXException {
        try {
            NodeFactory nodeFactory = this.m_model.getNodeFactory();
            Resource resource = nodeFactory.createResource(string);
            Resource resource2 = nodeFactory.createResource(string2);
            Literal literal = nodeFactory.createLiteral(string3, string5, string4);
            Statement statement = nodeFactory.createStatement(resource, resource2, literal);
            this.m_model.add(statement);
        }
        catch (ModelException modelException) {
            throw new SAXException("RDF exception", modelException);
        }
    }

    public void logicalURI(String string) throws SAXException {
        try {
            this.m_model.setLogicalURI(string);
        }
        catch (ModelException modelException) {
            throw new SAXException("RDF exception", modelException);
        }
    }

    public void includeModel(String string, String string2) throws SAXException {
        this.m_includedModels.add(new String[]{string, string2});
    }

    public void addModelAttribte(String string, String string2) throws SAXException {
        try {
            this.m_model.setAttribute(string, string2);
        }
        catch (ModelException modelException) {
            throw new SAXException("RDF exception", modelException);
        }
    }

    public List getIncludedModels() {
        return this.m_includedModels;
    }
}

