/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.util;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.syntax.RDFParser;
import edu.unika.aifb.rdf.api.syntax.RDFSerializer;
import edu.unika.aifb.rdf.api.util.NoRDFFactoryException;
import edu.unika.aifb.rdf.api.util.RDFFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RDFManager {
    protected static final List s_factories = new ArrayList();

    private RDFManager() {
    }

    public static void registerFactory(RDFFactory rDFFactory) {
        if (!s_factories.contains(rDFFactory)) {
            s_factories.add(0, rDFFactory);
        }
    }

    public static void registerFactory(String string) throws NoRDFFactoryException {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoRDFFactoryException("Cannot load RDF factory with class name '" + string + "'", classNotFoundException);
        }
    }

    public static RDFParser createParser() {
        return new RDFParser();
    }

    public static RDFSerializer createSerializer() {
        return new RDFSerializer();
    }

    public static Model createModel(String string, NodeFactory nodeFactory) throws ModelException, NoRDFFactoryException {
        string = RDFManager.fixURISpaces(string);
        Iterator iterator = s_factories.iterator();
        while (iterator.hasNext()) {
            RDFFactory rDFFactory = (RDFFactory)iterator.next();
            Model model = rDFFactory.createModel(string, nodeFactory);
            if (model == null) continue;
            return model;
        }
        throw new NoRDFFactoryException();
    }

    public static Model openModel(String string, NodeFactory nodeFactory) throws ModelException, NoRDFFactoryException {
        return RDFManager.openModelEx((String)string, (NodeFactory)nodeFactory).m_model;
    }

    public static ModelInfo openModelEx(String string, NodeFactory nodeFactory) throws ModelException, NoRDFFactoryException {
        string = RDFManager.fixURISpaces(string);
        Iterator iterator = s_factories.iterator();
        while (iterator.hasNext()) {
            RDFFactory rDFFactory = (RDFFactory)iterator.next();
            ModelInfo modelInfo = rDFFactory.openModelEx(string, nodeFactory);
            if (modelInfo == null) continue;
            return modelInfo;
        }
        throw new NoRDFFactoryException();
    }

    public static void deleteModel(String string) throws ModelException, NoRDFFactoryException {
        string = RDFManager.fixURISpaces(string);
        Iterator iterator = s_factories.iterator();
        while (iterator.hasNext()) {
            RDFFactory rDFFactory = (RDFFactory)iterator.next();
            if (!rDFFactory.deleteModel(string)) continue;
            return;
        }
        throw new NoRDFFactoryException();
    }

    protected static String fixURISpaces(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = stringBuffer.indexOf(" ", n);
        while (n2 != -1) {
            stringBuffer.delete(n2, n2 + 1);
            stringBuffer.insert(n2, "%20");
            n = n2;
            n2 = stringBuffer.indexOf(" ", n);
        }
        return stringBuffer.toString();
    }

    static {
        try {
            RDFManager.registerFactory("edu.unika.aifb.rdf.mainmemory.RDFFactoryImpl");
        }
        catch (NoRDFFactoryException noRDFFactoryException) {}
    }

    public static class ModelInfo {
        public Model m_model;
        public String[][] m_includedModels;
    }
}

