/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.util;

import edu.unika.aifb.rdf.api.model.Literal;
import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.api.util.RDFManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class RDFUtil {
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static int getOrd(Resource resource) throws ModelException {
        block5: {
            if (resource == null) {
                return -1;
            }
            String string = resource.toString();
            if (!RDFUtil.isRDF(string)) {
                return -1;
            }
            int n = RDFUtil.getNamespaceEnd(string);
            if (n <= 0 || n + 1 >= string.length()) break block5;
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                if (n2 >= 1) {
                    return n2;
                }
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public static boolean isQualified(String string) {
        int n = string.length() - 1;
        do {
            char c;
            if ((c = string.charAt(n)) != '#' && c != ':') continue;
            return true;
        } while (--n >= 0);
        return false;
    }

    public static String guessNamespace(String string) {
        int n = RDFUtil.getNamespaceEnd(string);
        return n > 1 ? string.substring(0, n) : "";
    }

    public static String guessName(String string) {
        return string.substring(RDFUtil.getNamespaceEnd(string));
    }

    public static String getNamespace(Resource resource) throws ModelException {
        return RDFUtil.guessNamespace(resource.getURI());
    }

    public static String getLocalName(Resource resource) throws ModelException {
        return RDFUtil.guessName(resource.getURI());
    }

    public static boolean isRDF(String string) {
        return string != null && string.startsWith("http://www.w3.org/2000/01/rdf-schema#");
    }

    public static boolean isRDF(Resource resource) throws ModelException {
        return RDFUtil.isRDF(resource.getURI());
    }

    static int getNamespaceEnd(String string) {
        char c;
        int n = string.length() - 1;
        while ((c = string.charAt(n)) != '#' && c != ':' && c != '/' && --n >= 0) {
        }
        return ++n;
    }

    public static Statement get1(Model model) throws ModelException {
        if (model == null || model.isEmpty()) {
            return null;
        }
        return (Statement)model.iterator().next();
    }

    public static void add(Model model, Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        model.add(model.getNodeFactory().createStatement(resource, resource2, rDFNode));
    }

    public static String getObjectLiteral(Model model, Resource resource, Resource resource2) throws ModelException {
        RDFNode rDFNode = RDFUtil.getObject(model, resource, resource2);
        if (rDFNode instanceof Literal) {
            return rDFNode.toString();
        }
        return null;
    }

    public static Resource getObjectResource(Model model, Resource resource, Resource resource2) throws ModelException {
        RDFNode rDFNode = RDFUtil.getObject(model, resource, resource2);
        if (rDFNode instanceof Resource) {
            return (Resource)rDFNode;
        }
        return null;
    }

    public static RDFNode getObject(Model model, Resource resource, Resource resource2) throws ModelException {
        Model model2 = model.find(resource, resource2, null);
        if (model2 == null || model2.size() == 0) {
            return null;
        }
        return ((Statement)model2.iterator().next()).object();
    }

    public static Resource getSubject(Model model, Resource resource, RDFNode rDFNode) throws ModelException {
        Model model2 = model.find(null, resource, rDFNode);
        if (model2 == null || model2.size() == 0) {
            return null;
        }
        return ((Statement)model2.iterator().next()).subject();
    }

    public static void printStatements(Model model, PrintStream printStream) throws ModelException {
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            printStream.println(statement);
        }
    }

    public static Vector getStatementVector(Model model) throws ModelException {
        Vector<Statement> vector = new Vector<Statement>(model.size());
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            vector.addElement(statement);
        }
        return vector;
    }

    public static Hashtable getResources(Model model) throws ModelException {
        Hashtable<RDFNode, RDFNode> hashtable = new Hashtable<RDFNode, RDFNode>();
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            hashtable.put(statement.subject(), statement.subject());
            if (!(statement.object() instanceof Resource)) continue;
            hashtable.put(statement.object(), statement.object());
        }
        return hashtable;
    }

    public static Hashtable getNodes(Model model) throws ModelException {
        Hashtable<RDFNode, RDFNode> hashtable = new Hashtable<RDFNode, RDFNode>();
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            hashtable.put(statement.subject(), statement.subject());
            hashtable.put(statement.object(), statement.object());
        }
        return hashtable;
    }

    public static void collectNamespaces(Resource resource, Collection collection) throws ModelException {
        String string = RDFUtil.getNamespace(resource);
        if (string != null) {
            collection.add(string);
        }
    }

    public static void collectNamespaces(Statement statement, Collection collection) throws ModelException {
        if (statement.subject() instanceof Statement) {
            RDFUtil.collectNamespaces((Statement)((Object)statement.subject()), collection);
        } else {
            RDFUtil.collectNamespaces(statement.subject(), collection);
        }
        RDFUtil.collectNamespaces(statement.predicate(), collection);
        if (statement.object() instanceof Statement) {
            RDFUtil.collectNamespaces((Statement)((Object)statement.object()), collection);
        } else if (statement.object() instanceof Resource) {
            RDFUtil.collectNamespaces((Resource)statement.object(), collection);
        }
    }

    public static void collectNamespaces(Model model, Collection collection) throws ModelException {
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            RDFUtil.collectNamespaces(statement, collection);
        }
    }

    public static void writeModel(Model model, Writer writer, String string) throws ModelException, IOException {
        RDFManager.createSerializer().serialize(model, writer, string);
    }

    public static void writeModel(Model model, OutputStream outputStream, String string) throws ModelException, IOException {
        RDFManager.createSerializer().serialize(model, outputStream, string);
    }

    public static String writeModel(Model model, String string) throws ModelException, IOException {
        StringWriter stringWriter = new StringWriter();
        RDFUtil.writeModel(model, stringWriter, string);
        return stringWriter.toString();
    }

    public static void writeModel(Model model, URL uRL, String string) throws IOException, ModelException, URISyntaxException {
        File file = new File(new URI(uRL.toString()));
        RDFUtil.writeModel(model, file, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModel(Model model, File file, String string) throws IOException, ModelException, URISyntaxException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            RDFUtil.writeModel(model, bufferedOutputStream, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)bufferedOutputStream).close();
            throw throwable;
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    public static Model immutableModel(Model model) {
        return new ImmutableModel(model);
    }

    protected static class ImmutableModel
    implements Model {
        protected Model m_model;

        public ImmutableModel(Model model) {
            this.m_model = model;
        }

        public String getLabel() throws ModelException {
            return this.m_model.getLabel();
        }

        public String getURI() throws ModelException {
            return this.m_model.getURI();
        }

        public boolean isPersistent() throws ModelException {
            return this.m_model.isPersistent();
        }

        public String getLogicalURI() throws ModelException {
            return this.m_model.getLogicalURI();
        }

        public void setLogicalURI(String string) throws ModelException {
            throw new ModelException("Cannot set the logical URI of an immutable model.");
        }

        public String getPhysicalURI() throws ModelException {
            return this.m_model.getPhysicalURI();
        }

        public void setPhysicalURI(String string) throws ModelException {
            throw new ModelException("Cannot set the physical URI of an immutable model.");
        }

        public int getInclusionIndex() {
            return this.m_model.getInclusionIndex();
        }

        public Collection getIncludedModels() throws ModelException {
            return this.m_model.getIncludedModels();
        }

        public Collection getAllIncludedModels() throws ModelException {
            return this.m_model.getAllIncludedModels();
        }

        public void addIncludedModel(Model model) throws ModelException {
            this.m_model.addIncludedModel(model);
        }

        public void removeIncludedModel(Model model) throws ModelException {
            this.m_model.removeIncludedModel(model);
        }

        public int size() throws ModelException {
            return this.m_model.size();
        }

        public int thisSize() throws ModelException {
            return this.m_model.thisSize();
        }

        public boolean isEmpty() throws ModelException {
            return this.m_model.isEmpty();
        }

        public boolean thisIsEmpty() throws ModelException {
            return this.m_model.thisIsEmpty();
        }

        public Iterator iterator() throws ModelException {
            return this.m_model.iterator();
        }

        public Iterator thisIterator() throws ModelException {
            return this.m_model.thisIterator();
        }

        public boolean contains(Statement statement) throws ModelException {
            return this.m_model.contains(statement);
        }

        public boolean contains(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
            return this.m_model.contains(resource, resource2, rDFNode);
        }

        public boolean thisContains(Statement statement) throws ModelException {
            return this.m_model.contains(statement);
        }

        public boolean thisContains(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
            return this.m_model.thisContains(resource, resource2, rDFNode);
        }

        public Model findModel(Statement statement) throws ModelException {
            return this.m_model.findModel(statement);
        }

        public void add(Statement statement) throws ModelException {
            throw new ModelException("Cannot change an immutable model.");
        }

        public void remove(Statement statement) throws ModelException {
            throw new ModelException("Cannot change an immutable model.");
        }

        public Model find(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
            return this.m_model.find(resource, resource2, rDFNode);
        }

        public Model thisFind(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
            return this.m_model.thisFind(resource, resource2, rDFNode);
        }

        public void find(Resource resource, Resource resource2, RDFNode rDFNode, Model model) throws ModelException {
            this.m_model.find(resource, resource2, rDFNode, model);
        }

        public void thisFind(Resource resource, Resource resource2, RDFNode rDFNode, Model model) throws ModelException {
            this.m_model.thisFind(resource, resource2, rDFNode, model);
        }

        public NodeFactory getNodeFactory() throws ModelException {
            return this.m_model.getNodeFactory();
        }

        public String getUniqueResourceURI(String string) throws ModelException {
            return this.m_model.getUniqueResourceURI(string);
        }

        public boolean supportsTransactions() throws ModelException {
            return false;
        }

        public void setAutocommit(boolean bl) throws ModelException {
            throw new ModelException("Cannot change autocommit mode on an immutable model.");
        }

        public boolean isAutocommit() throws ModelException {
            return false;
        }

        public void commit() throws ModelException {
            throw new ModelException("Cannot call commit on an immutable model.");
        }

        public void rollback() throws ModelException {
            throw new ModelException("Cannot call rollback on an immutable model.");
        }

        public String getAttribute(String string) throws ModelException {
            return this.m_model.getAttribute(string);
        }

        public void setAttribute(String string, String string2) throws ModelException {
            throw new ModelException("Cannot set attributes on an immutable model.");
        }

        public Map getAttributes() throws ModelException {
            return this.m_model.getAttributes();
        }
    }
}

