/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.mainmemory.SearchResultsModelImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractModel
implements Model {
    protected NodeFactory m_nodeFactory;
    protected List m_includedModels;
    protected Model[] m_allIncludedModels;
    protected int[] m_inclusionIndexes;
    protected int m_inclusionIndex;

    public AbstractModel(NodeFactory nodeFactory) {
        this.m_nodeFactory = nodeFactory;
        this.m_includedModels = new ArrayList();
        this.m_inclusionIndex = 0;
        this.m_allIncludedModels = new Model[0];
        this.m_inclusionIndexes = new int[0];
    }

    public NodeFactory getNodeFactory() {
        return this.m_nodeFactory;
    }

    public int getInclusionIndex() {
        return this.m_inclusionIndex;
    }

    public Collection getIncludedModels() throws ModelException {
        return new ArrayList(this.m_includedModels);
    }

    public void addIncludedModel(Model model) throws ModelException {
        if (!this.m_includedModels.contains(model)) {
            this.m_includedModels.add(model);
            this.updateAllIncludedModels();
            ++this.m_inclusionIndex;
        }
    }

    public void removeIncludedModel(Model model) throws ModelException {
        if (this.m_includedModels.contains(model)) {
            this.m_includedModels.remove(model);
            this.updateAllIncludedModels();
            ++this.m_inclusionIndex;
        }
    }

    protected void updateAllIncludedModels() throws ModelException {
        HashSet<AbstractModel> hashSet = new HashSet<AbstractModel>();
        hashSet.add(this);
        HashSet hashSet2 = new HashSet(hashSet);
        int n = -1;
        while (n != hashSet.size()) {
            n = hashSet.size();
            Iterator iterator = new HashSet(hashSet2).iterator();
            hashSet2.clear();
            while (iterator.hasNext()) {
                Model model = (Model)iterator.next();
                Collection collection = model.getIncludedModels();
                hashSet2.addAll(collection);
                hashSet.addAll(collection);
            }
        }
        hashSet.remove(this);
        this.m_allIncludedModels = new Model[hashSet.size()];
        hashSet.toArray(this.m_allIncludedModels);
        this.m_inclusionIndexes = new int[this.m_allIncludedModels.length];
        int n2 = 0;
        while (n2 < this.m_allIncludedModels.length) {
            this.m_inclusionIndexes[n2] = this.m_allIncludedModels[n2].getInclusionIndex();
            ++n2;
        }
    }

    protected void checkIncludedModelVersions() throws ModelException {
        int n = 0;
        while (n < this.m_allIncludedModels.length) {
            if (this.m_inclusionIndexes[n] != this.m_allIncludedModels[n].getInclusionIndex()) {
                this.updateAllIncludedModels();
                return;
            }
            ++n;
        }
    }

    public Collection getAllIncludedModels() throws ModelException {
        this.checkIncludedModelVersions();
        return Arrays.asList(this.m_allIncludedModels);
    }

    public int size() throws ModelException {
        this.checkIncludedModelVersions();
        int n = this.thisSize();
        int n2 = this.m_allIncludedModels.length - 1;
        while (n2 >= 0) {
            n += this.m_allIncludedModels[n2].thisSize();
            --n2;
        }
        return n;
    }

    public boolean isEmpty() throws ModelException {
        if (!this.thisIsEmpty()) {
            return false;
        }
        this.checkIncludedModelVersions();
        int n = this.m_allIncludedModels.length - 1;
        while (n >= 0) {
            if (!this.m_allIncludedModels[n].isEmpty()) {
                return false;
            }
            --n;
        }
        return true;
    }

    public Iterator iterator() throws ModelException {
        this.checkIncludedModelVersions();
        return new ModelIterator();
    }

    public boolean contains(Statement statement) throws ModelException {
        if (this.thisContains(statement)) {
            return true;
        }
        this.checkIncludedModelVersions();
        int n = this.m_allIncludedModels.length - 1;
        while (n >= 0) {
            if (this.m_allIncludedModels[n].thisContains(statement)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public boolean contains(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        if (this.thisContains(resource, resource2, rDFNode)) {
            return true;
        }
        this.checkIncludedModelVersions();
        int n = this.m_allIncludedModels.length - 1;
        while (n >= 0) {
            if (this.m_allIncludedModels[n].thisContains(resource, resource2, rDFNode)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public Model findModel(Statement statement) throws ModelException {
        if (this.thisContains(statement)) {
            return this;
        }
        this.checkIncludedModelVersions();
        int n = this.m_allIncludedModels.length - 1;
        while (n >= 0) {
            if (this.m_allIncludedModels[n].thisContains(statement)) {
                return this.m_allIncludedModels[n];
            }
            --n;
        }
        return null;
    }

    public Model find(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        SearchResultsModelImpl searchResultsModelImpl = new SearchResultsModelImpl(this.getNodeFactory());
        this.find(resource, resource2, rDFNode, searchResultsModelImpl);
        return searchResultsModelImpl;
    }

    public Model thisFind(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        SearchResultsModelImpl searchResultsModelImpl = new SearchResultsModelImpl(this.getNodeFactory());
        this.thisFind(resource, resource2, rDFNode, searchResultsModelImpl);
        return searchResultsModelImpl;
    }

    public void find(Resource resource, Resource resource2, RDFNode rDFNode, Model model) throws ModelException {
        this.checkIncludedModelVersions();
        this.thisFind(resource, resource2, rDFNode, model);
        int n = this.m_allIncludedModels.length - 1;
        while (n >= 0) {
            this.m_allIncludedModels[n].thisFind(resource, resource2, rDFNode, model);
            --n;
        }
    }

    protected class ModelIterator
    implements Iterator {
        protected Iterator[] m_iterators;
        protected int m_index;

        public ModelIterator() throws ModelException {
            this.m_iterators = new Iterator[1 + AbstractModel.this.m_allIncludedModels.length];
            this.m_iterators[0] = AbstractModel.this.thisIterator();
            int n = 0;
            while (n < AbstractModel.this.m_allIncludedModels.length) {
                this.m_iterators[n + 1] = AbstractModel.this.m_allIncludedModels[n].thisIterator();
                ++n;
            }
        }

        public boolean hasNext() {
            if (this.m_index >= this.m_iterators.length) {
                return false;
            }
            return this.m_iterators[this.m_index].hasNext();
        }

        public Object next() {
            if (this.m_index >= this.m_iterators.length) {
                throw new NoSuchElementException();
            }
            Object e = this.m_iterators[this.m_index].next();
            while (this.m_index < this.m_iterators.length && !this.m_iterators[this.m_index].hasNext()) {
                ++this.m_index;
            }
            return e;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

