/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.util.ModelConsumer;
import edu.unika.aifb.rdf.api.util.RDFFactory;
import edu.unika.aifb.rdf.api.util.RDFManager;
import edu.unika.aifb.rdf.mainmemory.NodeFactoryImpl;
import edu.unika.aifb.rdf.mainmemory.TransactionableModelImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RDFFactoryImpl
implements RDFFactory {
    public static final RDFFactoryImpl INSTANCE = new RDFFactoryImpl();

    protected RDFFactoryImpl() {
    }

    public Model createModel(String string, NodeFactory nodeFactory) throws ModelException {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (nodeFactory == null) {
            nodeFactory = new NodeFactoryImpl();
        }
        TransactionableModelImpl transactionableModelImpl = new TransactionableModelImpl(nodeFactory);
        transactionableModelImpl.setPhysicalURI(string);
        transactionableModelImpl.setLogicalURI(string);
        return transactionableModelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RDFManager.ModelInfo openModelEx(String string, NodeFactory nodeFactory) throws ModelException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            RDFManager.ModelInfo modelInfo;
            InputStream inputStream = uRL.openStream();
            try {
                modelInfo = this.openModelEx(string, nodeFactory, inputStream, null);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return modelInfo;
        }
        catch (IOException iOException) {
            throw new ModelException("I/O error reading RDF XML data.", iOException);
        }
    }

    public RDFManager.ModelInfo openModelEx(String string, NodeFactory nodeFactory, InputStream inputStream, ModelConsumer modelConsumer) throws ModelException {
        Object object;
        if (nodeFactory == null) {
            nodeFactory = new NodeFactoryImpl();
        }
        if (modelConsumer == null) {
            modelConsumer = new ModelConsumer();
        }
        RDFManager.ModelInfo modelInfo = new RDFManager.ModelInfo();
        modelInfo.m_model = new TransactionableModelImpl(nodeFactory);
        modelConsumer.initialize(modelInfo.m_model);
        try {
            object = new InputSource(inputStream);
            ((InputSource)object).setSystemId(string);
            RDFManager.createParser().parse((InputSource)object, modelConsumer);
        }
        catch (SAXParseException sAXParseException) {
            throw new ModelException("[line=" + sAXParseException.getLineNumber() + ", column=" + sAXParseException.getColumnNumber() + "] Error Parsing XML data.", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new ModelException("Error parsing RDF XML data.", sAXException);
        }
        catch (IOException iOException) {
            throw new ModelException("I/O error reading RDF XML data.", iOException);
        }
        object = modelConsumer.getIncludedModels();
        modelInfo.m_includedModels = new String[object.size()][2];
        object.toArray((T[])modelInfo.m_includedModels);
        return modelInfo;
    }

    public boolean deleteModel(String string) throws ModelException {
        try {
            File file = new File(new URI(string));
            if (file.exists() && !file.delete()) {
                throw new ModelException("Cannot RDF model denoted by " + string.toString());
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    static {
        RDFManager.registerFactory(INSTANCE);
    }
}

