/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.model.helper;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OWLEntityCollector;
import org.semanticweb.owl.model.helper.OWLEntityVisitorAdapter;

public class OWLObjectsUsedCollector
extends OWLEntityVisitorAdapter {
    static Logger logger = Logger.getLogger((Class)(class$org$semanticweb$owl$model$helper$OWLObjectsUsedCollector == null ? (class$org$semanticweb$owl$model$helper$OWLObjectsUsedCollector = OWLObjectsUsedCollector.class$("org.semanticweb.owl.model.helper.OWLObjectsUsedCollector")) : class$org$semanticweb$owl$model$helper$OWLObjectsUsedCollector));
    private Set entities;
    private OWLOntology ontology;
    private OWLEntityCollector collector;
    static /* synthetic */ Class class$org$semanticweb$owl$model$helper$OWLObjectsUsedCollector;

    public OWLObjectsUsedCollector(OWLOntology _ontology) {
        this.ontology = _ontology;
        this.collector = new OWLEntityCollector();
        this.reset();
    }

    public void reset() {
        this.entities = new HashSet();
    }

    public Set entities() {
        return new HashSet(this.entities);
    }

    public void visit(OWLClass entity) throws OWLException {
        this.collector.reset();
        HashSet thingsToLookIn = new HashSet();
        thingsToLookIn.addAll(entity.getSuperClasses(this.ontology));
        thingsToLookIn.addAll(entity.getEquivalentClasses(this.ontology));
        thingsToLookIn.addAll(entity.getEnumerations(this.ontology));
        thingsToLookIn.addAll(entity.getAnnotations(this.ontology));
        Iterator thingIt = thingsToLookIn.iterator();
        while (thingIt.hasNext()) {
            OWLObject oo = (OWLObject)thingIt.next();
            logger.debug((Object)("Looking at: " + oo));
            oo.accept(this.collector);
        }
        this.entities = this.collector.entities();
    }

    public void visit(OWLObjectProperty entity) throws OWLException {
        this.collector.reset();
        HashSet thingsToLookIn = new HashSet();
        thingsToLookIn.addAll(entity.getDomains(this.ontology));
        thingsToLookIn.addAll(entity.getRanges(this.ontology));
        thingsToLookIn.addAll(entity.getAnnotations(this.ontology));
        Iterator thingIt = thingsToLookIn.iterator();
        while (thingIt.hasNext()) {
            OWLObject oo = (OWLObject)thingIt.next();
            oo.accept(this.collector);
        }
        this.entities = this.collector.entities();
        this.entities.addAll(entity.getInverses(this.ontology));
    }

    public void visit(OWLDataProperty entity) throws OWLException {
        this.collector.reset();
        HashSet thingsToLookIn = new HashSet();
        thingsToLookIn.addAll(entity.getDomains(this.ontology));
        thingsToLookIn.addAll(entity.getAnnotations(this.ontology));
        Iterator thingIt = thingsToLookIn.iterator();
        while (thingIt.hasNext()) {
            OWLObject oo = (OWLObject)thingIt.next();
            oo.accept(this.collector);
        }
        this.entities = this.collector.entities();
    }

    public void visit(OWLIndividual entity) throws OWLException {
        this.collector.reset();
        HashSet thingsToLookIn = new HashSet();
        thingsToLookIn.addAll(entity.getTypes(this.ontology));
        thingsToLookIn.addAll(entity.getAnnotations(this.ontology));
        Map map = entity.getObjectPropertyValues(this.ontology);
        Iterator mit = map.keySet().iterator();
        while (mit.hasNext()) {
            Object k = mit.next();
            thingsToLookIn.add(k);
            thingsToLookIn.addAll((Set)map.get(k));
        }
        thingsToLookIn.addAll(entity.getDataPropertyValues(this.ontology).keySet());
        Iterator thingIt = thingsToLookIn.iterator();
        while (thingIt.hasNext()) {
            OWLObject oo = (OWLObject)thingIt.next();
            oo.accept(this.collector);
        }
        this.entities = this.collector.entities();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

