/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;

public abstract class OntologyProcessor
implements Serializable {
    protected static final int CHUNK_SIZE = 600;
    protected ProgressListener m_progressListener = NullProgressListener.INSTANCE;

    public void setProgressListener(ProgressListener progressListener) {
        this.m_progressListener = progressListener;
    }

    protected void processElements(Set set, OWLOntology ontology, int loadFlag, ObjectProcessor objectProcessor, int progressPhase) throws OWLException, InterruptedException {
        int processed = 0;
        this.m_progressListener.processorProgress(progressPhase, processed, set.size());
        HashSet<OWLObject> objectsToLoad = new HashSet<OWLObject>();
        Iterator objects = set.iterator();
        while (objects.hasNext()) {
            OWLObject entity = (OWLObject)objects.next();
            objectsToLoad.add(entity);
            if (objectsToLoad.size() == 600) {
                if (ontology != null) {
                    objectProcessor.processLoadedObjects(objectsToLoad);
                }
                objectsToLoad.clear();
                this.m_progressListener.processorProgress(progressPhase, processed += objectsToLoad.size(), set.size());
            }
            this.checkInterrupted();
        }
        if (!objectsToLoad.isEmpty()) {
            if (ontology != null) {
                objectProcessor.processLoadedObjects(objectsToLoad);
            }
            this.m_progressListener.processorProgress(progressPhase, processed += objectsToLoad.size(), set.size());
        }
    }

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected static class NullProgressListener
    implements ProgressListener {
        public static final ProgressListener INSTANCE = new NullProgressListener();

        protected NullProgressListener() {
        }

        public void processorProgress(int phase, int done, int steps) {
        }
    }

    public static interface ProgressListener {
        public void processorProgress(int var1, int var2, int var3);
    }

    protected static interface ObjectProcessor {
        public void processLoadedObjects(Set var1) throws OWLException, InterruptedException;
    }
}

