/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.ExtBuilder;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpExtRegistry;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.algebra.opt.TransformSimplify;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.PathBlock;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.path.PathCompiler;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementFetch;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class AlgebraGenerator {
    boolean fixedFilterPosition = false;
    private Context context;
    private PathCompiler pathCompiler = new PathCompiler();
    public static boolean applySimplification = true;
    boolean simplifyInAlgebraGeneration = false;
    protected static Transform simplify = new TransformSimplify();

    public AlgebraGenerator(Context context) {
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        this.context = context;
    }

    public AlgebraGenerator() {
        this(null);
    }

    public Op compile(Query query) {
        Op pattern = this.compile(query.getQueryPattern());
        Op op = this.compileModifiers(query, pattern);
        return op;
    }

    public Op compile(Element elt) {
        Op op;
        Op op2 = op = this.compileElement(elt);
        if (!this.simplifyInAlgebraGeneration && applySimplification && simplify != null) {
            op2 = Transformer.transform(simplify, op);
        }
        return op2;
    }

    protected Op compileElement(Element elt) {
        if (elt instanceof ElementUnion) {
            return this.compileElementUnion((ElementUnion)elt);
        }
        if (elt instanceof ElementGroup) {
            return this.compileElementGroup((ElementGroup)elt);
        }
        if (elt instanceof ElementNamedGraph) {
            return this.compileElementGraph((ElementNamedGraph)elt);
        }
        if (elt instanceof ElementService) {
            return this.compileElementService((ElementService)elt);
        }
        if (elt instanceof ElementFetch) {
            return this.compileElementFetch((ElementFetch)elt);
        }
        if (elt instanceof ElementTriplesBlock) {
            return this.compileBasicPattern(((ElementTriplesBlock)elt).getPattern());
        }
        if (elt instanceof ElementPathBlock) {
            return this.compilePathBlock(((ElementPathBlock)elt).getPattern());
        }
        if (elt instanceof ElementSubQuery) {
            return this.compileElementSubquery((ElementSubQuery)elt);
        }
        if (elt == null) {
            return OpNull.create();
        }
        this.broken("compile(Element)/Not a structural element: " + Utils.className(elt));
        return null;
    }

    protected Op compileElementUnion(ElementUnion el) {
        if (el.getElements().size() == 1) {
            Element subElt = (Element)el.getElements().get(0);
            ElementGroup elg = (ElementGroup)subElt;
            return this.compileElement(elg);
        }
        Op current = null;
        ListIterator iter = el.getElements().listIterator();
        while (iter.hasNext()) {
            Element subElt = (Element)iter.next();
            ElementGroup elg = (ElementGroup)subElt;
            Op op = this.compileElement(elg);
            if (current == null) {
                current = op;
                continue;
            }
            current = new OpUnion(current, op);
        }
        return current;
    }

    protected Op compileElementGroup(ElementGroup groupElt) {
        Op current = OpTable.unit();
        ExprList exprList = new ExprList();
        List groupElts = this.finalizeSyntax(groupElt, exprList);
        ListIterator iter = groupElts.listIterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            current = this.compileOneInGroup(elt, current, exprList);
        }
        if (!exprList.isEmpty()) {
            current = OpFilter.filter(exprList, current);
        }
        return current;
    }

    private List finalizeSyntax(ElementGroup groupElt, ExprList exprList) {
        ArrayList<Element> groupElts = new ArrayList<Element>();
        BasicPattern prev = null;
        ListIterator iter = groupElt.getElements().listIterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            if (elt instanceof ElementFilter) {
                ElementFilter f = (ElementFilter)elt;
                exprList.add(f.getExpr());
                continue;
            }
            if (!(elt instanceof ElementTriplesBlock)) {
                prev = null;
                groupElts.add(elt);
                continue;
            }
            ElementTriplesBlock etb = (ElementTriplesBlock)elt;
            if (prev != null) {
                prev.addAll(etb.getPattern());
                continue;
            }
            ElementTriplesBlock etb2 = new ElementTriplesBlock();
            etb2.getPattern().addAll(etb.getPattern());
            prev = etb2.getPattern();
            groupElts.add(etb2);
        }
        return groupElts;
    }

    private Op compileOneInGroup(Element elt, Op current, ExprList exprList) {
        if (elt instanceof ElementTriplesBlock) {
            ElementTriplesBlock etb = (ElementTriplesBlock)elt;
            Op op = this.compileBasicPattern(etb.getPattern());
            return this.join(current, op);
        }
        if (elt instanceof ElementPathBlock) {
            ElementPathBlock epb = (ElementPathBlock)elt;
            Op op = this.compilePathBlock(epb.getPattern());
            return this.join(current, op);
        }
        if (elt instanceof ElementFilter) {
            ElementFilter f = (ElementFilter)elt;
            if (this.fixedFilterPosition) {
                return OpFilter.filter(f.getExpr(), current);
            }
            exprList.add(f.getExpr());
            return current;
        }
        if (elt instanceof ElementOptional) {
            ElementOptional eltOpt = (ElementOptional)elt;
            return this.compileElementOptional(eltOpt, current);
        }
        if (elt instanceof ElementSubQuery) {
            ElementSubQuery elQuery = (ElementSubQuery)elt;
            Op op = this.compileElementSubquery(elQuery);
            return this.join(current, op);
        }
        if (elt instanceof ElementAssign) {
            ElementAssign assign2 = (ElementAssign)elt;
            Op subOp = OpAssign.assign(current, assign2.getVar(), assign2.getExpr());
            return subOp;
        }
        if (elt instanceof ElementGroup || elt instanceof ElementNamedGraph || elt instanceof ElementService || elt instanceof ElementFetch || elt instanceof ElementUnion) {
            Op op = this.compileElement(elt);
            return this.join(current, op);
        }
        this.broken("compile/Element not recognized: " + Utils.className(elt));
        return null;
    }

    protected Op compileElementOptional(ElementOptional eltOpt, Op current) {
        Element subElt = eltOpt.getOptionalElement();
        Op op = this.compileElement(subElt);
        ExprList exprs = null;
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            Op sub = f.getSubOp();
            if (sub instanceof OpFilter) {
                this.broken("compile/Optional/nested filters - unfinished");
            }
            exprs = f.getExprs();
            op = sub;
        }
        current = OpLeftJoin.create(current, op, exprs);
        return current;
    }

    protected Op compileBasicPattern(BasicPattern pattern) {
        return new OpBGP(pattern);
    }

    protected Op compilePathBlock(PathBlock pathBlock) {
        pathBlock = this.pathCompiler.reduce(pathBlock);
        BasicPattern bp = null;
        Op op = null;
        ListIterator iter = pathBlock.iterator();
        while (iter.hasNext()) {
            TriplePath obj = (TriplePath)iter.next();
            if (obj.isTriple()) {
                if (bp == null) {
                    bp = new BasicPattern();
                }
                bp.add(obj.asTriple());
                continue;
            }
            op = this.flush(bp, op);
            bp = null;
            TriplePath tp = obj;
            OpPath opPath = new OpPath(tp);
            op = OpSequence.create(op, opPath);
        }
        op = this.flush(bp, op);
        return op;
    }

    private Op flush(BasicPattern bp, Op op) {
        if (bp == null || bp.isEmpty()) {
            return op;
        }
        OpBGP opBGP = new OpBGP(bp);
        op = OpSequence.create(op, opBGP);
        return op;
    }

    protected Op compileElementGraph(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Op sub = this.compileElement(eltGraph.getElement());
        return new OpGraph(graphNode, sub);
    }

    protected Op compileElementService(ElementService eltService) {
        Node serviceNode = eltService.getServiceNode();
        Op sub = this.compileElement(eltService.getElement());
        return new OpService(serviceNode, sub);
    }

    private Op compileElementFetch(ElementFetch elt) {
        Node serviceNode = elt.getFetchNode();
        ExtBuilder builder = OpExtRegistry.builder("fetch");
        if (builder == null) {
            ALog.warn(this, "Attempt to use OpFetch - need to enable first with a call to OpFetch.enable()");
            return OpLabel.create("fetch/" + serviceNode, OpTable.unit());
        }
        Item item = Item.createNode(elt.getFetchNode());
        ItemList args = new ItemList();
        args.add(item);
        return builder.make(args);
    }

    protected Op compileElementSubquery(ElementSubQuery eltSubQuery) {
        Op sub = this.compile(eltSubQuery.getQuery());
        return sub;
    }

    public Op compileModifiers(Query query, Op pattern) {
        VarExprList projectVars = query.getProject();
        VarExprList exprs = new VarExprList();
        ArrayList<Var> vars = new ArrayList<Var>();
        if (!projectVars.isEmpty() && !query.isQueryResultStar()) {
            if (projectVars.size() == 0 && query.isSelectType()) {
                ALog.warn(this, "No project variables");
            }
            Iterator iter = query.getProject().getVars().iterator();
            while (iter.hasNext()) {
                Var v = (Var)((Object)iter.next());
                Expr e2 = query.getProject().getExpr(v);
                if (e2 != null) {
                    exprs.add(v, e2);
                }
                vars.add(v);
            }
        }
        Op op = pattern;
        if (this.context.isTrue(ARQ.generateToList)) {
            op = new OpList(op);
        }
        if (query.hasGroupBy() || query.getAggregators().size() > 0) {
            op = new OpGroupAgg(op, query.getGroupBy(), query.getAggregators());
        }
        if (!exprs.isEmpty()) {
            op = new OpAssign(op, exprs);
        }
        if (query.hasHaving()) {
            Iterator iter = query.getHavingExprs().iterator();
            while (iter.hasNext()) {
                Expr expr = (Expr)iter.next();
                op = OpFilter.filter(expr, op);
            }
        }
        if (query.getOrderBy() != null) {
            op = new OpOrder(op, query.getOrderBy());
        }
        if (vars.size() > 0) {
            op = new OpProject(op, vars);
        }
        if (query.isDistinct()) {
            op = new OpDistinct(op);
        }
        if (query.isReduced()) {
            op = new OpReduced(op);
        }
        if (query.hasLimit() || query.hasOffset()) {
            op = new OpSlice(op, query.getOffset(), query.getLimit());
        }
        return op;
    }

    protected Op join(Op current, Op newOp) {
        if (this.simplifyInAlgebraGeneration && applySimplification) {
            if (OpJoin.isJoinIdentify(current)) {
                return newOp;
            }
            if (OpJoin.isJoinIdentify(newOp)) {
                return current;
            }
        }
        return OpJoin.create(current, newOp);
    }

    private void broken(String msg) {
        throw new ARQInternalErrorException(msg);
    }
}

