/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.ontology;

import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.Severity;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooManyDifferentIndividualsPattern
implements OntologyLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();
    private int m_MaxAllowed = 50;

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + " (MaxAllowed = " + this.m_MaxAllowed + ")";
    }

    @Override
    public String getDescription() {
        return "Too many individuals involved in DifferentIndividuals axioms - maximum recommended is " + this.m_MaxAllowed;
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void setMaxAllowed(int value) {
        this.m_MaxAllowed = value;
    }

    @Override
    public List<Lint> match(OWLOntology ontology) {
        int totalEstimatedMemory = 0;
        for (OWLDifferentIndividualsAxiom axiom : ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS)) {
            totalEstimatedMemory += TooManyDifferentIndividualsPattern.estimateMemoryConcumption(axiom.getIndividuals().size());
        }
        ArrayList<Lint> allLints = new ArrayList<Lint>();
        if (totalEstimatedMemory > TooManyDifferentIndividualsPattern.estimateMemoryConcumption(this.m_MaxAllowed)) {
            Lint lint = new Lint(this, ontology);
            lint.setSeverity(new Severity(totalEstimatedMemory));
            allLints.add(lint);
        }
        return allLints;
    }

    private static int estimateMemoryConcumption(int individualCount) {
        return individualCount * (individualCount - 1);
    }
}

