/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import java.util.ArrayList;
import owlsslr_s3.X_Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvResult
implements Comparable {
    private X_Object advertisement;
    private double FS;
    private double TS;
    private double NFS;
    private double similarity;
    private ArrayList<String> inputCharacterization = new ArrayList();
    private ArrayList<String> outputCharacterization = new ArrayList();
    private ArrayList<String> taxonomicalCharacterization = new ArrayList();
    private double time;

    public X_Object getAdvertisement() {
        return this.advertisement;
    }

    public String getAdvName() {
        return this.getAdvertisement().getServiceName();
    }

    public void setAdvertisement(X_Object advertisement) {
        this.advertisement = advertisement;
    }

    public ArrayList<String> getInputCharacterization() {
        return this.inputCharacterization;
    }

    public void setInputCharacterization(ArrayList<String> inputCharacterization) {
        this.inputCharacterization.addAll(inputCharacterization);
    }

    public ArrayList<String> getOutputCharacterization() {
        return this.outputCharacterization;
    }

    public void setOutputCharacterization(ArrayList<String> outputCharacterization) {
        this.outputCharacterization.addAll(outputCharacterization);
    }

    public double getFS() {
        return this.FS;
    }

    public void setFS(double FS) {
        this.FS = FS;
    }

    public double getTS() {
        return this.TS;
    }

    public void setTS(double TS) {
        this.TS = TS;
    }

    public double getNFS() {
        return this.NFS;
    }

    public void setNFS(double NFS) {
        this.NFS = NFS;
    }

    public ArrayList<String> getTaxonomicalCharacterization() {
        return this.taxonomicalCharacterization;
    }

    public void setTaxonomicalCharacterization(ArrayList<String> taxonomicalCharacterization) {
        this.taxonomicalCharacterization = taxonomicalCharacterization;
    }

    public double getWeightedSimilarity() {
        return this.similarity;
    }

    public String getServiceCharacterizationMatch() {
        if (this.inputCharacterization.contains("sibling") || this.outputCharacterization.contains("sibling")) {
            return "sibling";
        }
        if (this.inputCharacterization.contains("subsume") || this.outputCharacterization.contains("plugin")) {
            return "subsume";
        }
        if (this.inputCharacterization.contains("plugin") || this.outputCharacterization.contains("subsume")) {
            return "plugin";
        }
        if (this.inputCharacterization.contains("exact") || this.outputCharacterization.contains("exact")) {
            return "exact";
        }
        System.out.println("UNDEFINED!!");
        System.exit(6);
        return "undefined";
    }

    void computeWeightedSimilarity(double a, double b, double c) {
        this.similarity = (a * this.TS + b * this.FS + c * this.NFS) / (a + b + c);
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public int compareTo(Object o) {
        double s2;
        double s1 = this.getWeightedSimilarity();
        if (s1 > (s2 = ((AdvResult)o).getWeightedSimilarity())) {
            return -1;
        }
        if (s1 < s2) {
            return 1;
        }
        return 0;
    }
}

