/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import owlsslr_s3.Configuration;
import owlsslr_s3.X_Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Advertisement {
    static int counter = 0;
    OWLOntology ontology;
    Set<URI> domainImports;
    Configuration conf;
    OWLOntologyManager manager;
    OWLDataFactory factory;
    X_Object po;
    private String name;

    public Advertisement(URI uri, Configuration conf, OWLOntologyManager manager, OWLDataFactory factory) {
        try {
            this.conf = conf;
            this.po = new X_Object();
            this.domainImports = new HashSet<URI>();
            this.manager = manager;
            this.factory = factory;
            this.ontology = manager.loadOntology(uri);
            this.findDomainImports();
            this.createP_Object();
        }
        catch (OWLOntologyCreationException ex) {
            Logger.getLogger(Advertisement.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void findDomainImports() {
        Set imports = this.ontology.getAxioms(AxiomType.IMPORTS_DECLARATION);
        for (OWLImportsDeclaration imp : imports) {
            if (this.conf.getOwls_repository().contains(imp.getImportedOntologyURI())) continue;
            this.domainImports.add(imp.getImportedOntologyURI());
        }
    }

    private X_Object createP_Object() {
        Set outputs;
        OWLClass profile = this.factory.getOWLClass(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#Profile"));
        OWLObjectProperty hasInput = this.factory.getOWLObjectProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#hasInput"));
        OWLObjectProperty hasOutput = this.factory.getOWLObjectProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#hasOutput"));
        OWLDataProperty parameterType = this.factory.getOWLDataProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Process.owl#parameterType"));
        OWLDataProperty serviceName = this.factory.getOWLDataProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#serviceName"));
        this.po = new X_Object();
        OWLIndividual advertisement = (OWLIndividual)profile.getIndividuals(this.ontology).iterator().next();
        Map v1 = advertisement.getObjectPropertyValues(this.ontology);
        this.po.setUri(this.ontology.getURI());
        Map dataPropertyValues = advertisement.getDataPropertyValues(this.ontology);
        this.name = ((OWLConstant)((Set)dataPropertyValues.get(serviceName)).iterator().next()).getLiteral();
        this.po.setServiceName(this.name);
        Set inputs = (Set)v1.get(hasInput);
        if (inputs != null) {
            for (OWLIndividual input : inputs) {
                Map v2 = input.getDataPropertyValues(this.ontology);
                OWLConstant paramType = (OWLConstant)((Set)v2.get(parameterType)).iterator().next();
                this.po.setInput(ATermUtils.makeTermAppl((String)paramType.getLiteral()));
            }
        }
        if ((outputs = (Set)v1.get(hasOutput)) != null) {
            for (OWLIndividual output : outputs) {
                Map v2 = output.getDataPropertyValues(this.ontology);
                OWLConstant paramType = (OWLConstant)((Set)v2.get(parameterType)).iterator().next();
                this.po.setOutput(ATermUtils.makeTermAppl((String)paramType.getLiteral()));
            }
        }
        return this.po;
    }

    public X_Object getP_Object() {
        return this.po;
    }

    public Set<URI> getDomainImports() {
        return this.domainImports;
    }

    public void printDirectImports() {
        for (URI imp : this.domainImports) {
            System.out.println(imp);
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public void printAxioms() {
        for (OWLAxiom axiom : this.ontology.getAxioms()) {
            System.out.println(axiom);
        }
    }
}

