/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import java.net.URI;
import java.util.ArrayList;
import owlsslr_s3.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration_siblings_edge
extends Configuration {
    String measure;
    String taxonomicalFilter;
    ArrayList<String> webServiceFilters = new ArrayList();
    int siblingThreshold;
    int hierarchyThreshold;
    double cotopicThreshold;
    double a;
    double b;
    double c;
    ArrayList<URI> owls_repository = new ArrayList();

    public Configuration_siblings_edge() {
        this.readConfiguration_siblings_edge();
    }

    private void readConfiguration_siblings_edge() {
        this.measure = "edgeDistance";
        this.taxonomicalFilter = "exact";
        this.webServiceFilters.add("SIBLING");
        this.siblingThreshold = 8;
        this.hierarchyThreshold = 8;
        this.cotopicThreshold = 0.5;
        this.a = 1.0;
        this.b = 1.0;
        this.c = 0.1;
        this.owls_repository.add(URI.create("http://127.0.0.1/ontology/Profile.owl"));
        this.owls_repository.add(URI.create("http://127.0.0.1/ontology/Grounding.owl"));
        this.owls_repository.add(URI.create("http://127.0.0.1/ontology/Process.owl"));
        this.owls_repository.add(URI.create("http://127.0.0.1/ontology/Service.owl"));
    }

    @Override
    public ArrayList<URI> getOwls_repository() {
        return this.owls_repository;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public double getCotopicThreshold() {
        return this.cotopicThreshold;
    }

    public int getHierarchyThreshold() {
        return this.hierarchyThreshold;
    }

    public String getMeasure() {
        return this.measure;
    }

    public int getSiblingThreshold() {
        return this.siblingThreshold;
    }

    public String getTaxonomicalFilter() {
        return this.taxonomicalFilter;
    }

    public ArrayList<String> getWebServiceFilters() {
        return this.webServiceFilters;
    }

    void printConfiguration() {
        System.out.println("Measure:" + this.measure);
        System.out.println("Taxonomical Filter: " + this.taxonomicalFilter);
        System.out.println("Web Service Filter: " + this.webServiceFilters.get(0));
        System.out.println("Sibling Threshold: " + this.siblingThreshold);
        System.out.println("Hierarchy Threshold: " + this.hierarchyThreshold);
        System.out.println("Cotopic Threshold: " + this.cotopicThreshold);
        System.out.println("a: " + this.a);
        System.out.println("b: " + this.b);
        System.out.println("c: " + this.c);
        System.out.println("OWLS Repository:");
        for (URI item : this.owls_repository) {
            System.out.println(item);
        }
    }
}

