/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;
import owlsslr_s3.DomainSubreasoner;
import owlsslr_s3.TaxonomicalOntologyHandler;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaroWinkler;

public class Distance {
    private static double cotopicDistance(ATermAppl sub, ATermAppl sup, DomainSubreasoner subR, double cotopicTheshold) {
        HashSet supersA = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSupers((Object)sub, false, false);
        HashSet same1 = new HashSet();
        same1.addAll(subR.getReasoner().getKB().getTaxonomy().getAllEquivalents((Object)sub));
        supersA.add(same1);
        HashSet supersB = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSupers((Object)sup, false, false);
        HashSet same2 = new HashSet();
        same2.addAll(subR.getReasoner().getKB().getTaxonomy().getAllEquivalents((Object)sup));
        supersB.add(same2);
        HashSet union = new HashSet();
        union.addAll(supersA);
        union.addAll(supersB);
        HashSet intersection = new HashSet();
        supersA.retainAll(supersB);
        intersection.addAll(supersA);
        double inters = intersection.size() - 1;
        double unio = union.size() - 1;
        if (inters / unio >= cotopicTheshold) {
            return 1.0 - inters / unio;
        }
        return 1.0;
    }

    private static double edgeDistance(ATermAppl sub, ATermAppl sup, DomainSubreasoner subR, int hierarchyThreshold) {
        HashSet supers = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSupers((Object)sub, false, true);
        HashSet subss = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSubs((Object)sup, false, true);
        supers.retainAll(subss);
        HashSet intersection = new HashSet();
        intersection.addAll(supers);
        HashSet<ATermAppl> expandList = new HashSet<ATermAppl>();
        expandList.add(sub);
        int dist = 0;
        while (!expandList.isEmpty()) {
            ++dist;
            HashSet temp = new HashSet();
            for (ATermAppl term : expandList) {
                temp.addAll(subR.getReasoner().getKB().getTaxonomy().getSupers((Object)term, true, true));
            }
            if (temp.contains(sup)) break;
            temp.retainAll(intersection);
            expandList.clear();
            expandList.addAll(temp);
        }
        if (dist > hierarchyThreshold) {
            return 1.0;
        }
        return (double)dist / subR.getMaxD();
    }

    private static double siblingEdgeDistance(ATermAppl sub, ATermAppl T, ATermAppl sup, DomainSubreasoner subR, int siblingThreshold) {
        HashSet supers = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSupers((Object)sub, false, true);
        HashSet subss = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSubs((Object)T, false, true);
        supers.retainAll(subss);
        HashSet intersection = new HashSet();
        intersection.addAll(supers);
        HashSet<ATermAppl> expandList = new HashSet<ATermAppl>();
        expandList.add(sub);
        int dist1 = 0;
        while (!expandList.isEmpty()) {
            ++dist1;
            HashSet temp = new HashSet();
            for (ATermAppl term : expandList) {
                temp.addAll(subR.getReasoner().getKB().getTaxonomy().getSupers((Object)term, true, true));
            }
            if (temp.contains(T)) break;
            temp.retainAll(intersection);
            expandList.clear();
            expandList.addAll(temp);
        }
        HashSet superss = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSupers((Object)sup, false, true);
        HashSet subsss = (HashSet)subR.getReasoner().getKB().getTaxonomy().getSubs((Object)T, false, true);
        superss.retainAll(subsss);
        HashSet intersection1 = new HashSet();
        intersection1.addAll(superss);
        HashSet<ATermAppl> expandList1 = new HashSet<ATermAppl>();
        expandList1.add(sup);
        int dist2 = 0;
        while (!expandList1.isEmpty()) {
            ++dist2;
            HashSet temp = new HashSet();
            for (ATermAppl term : expandList1) {
                temp.addAll(subR.getReasoner().getKB().getTaxonomy().getSupers((Object)term, true, true));
            }
            if (temp.contains(T)) break;
            temp.retainAll(intersection1);
            expandList1.clear();
            expandList1.addAll(temp);
        }
        if (dist1 + dist2 <= siblingThreshold) {
            return (double)(dist1 + dist2) / subR.getMaxD();
        }
        return 1.0;
    }

    public static double distance(ATermAppl concept, ATermAppl A, DomainSubreasoner subR, String measure, int siblingThreshold, int hierarchyThreshold, double cotopicTheshold) {
        KnowledgeBase kb = subR.getReasoner().getKB();
        if (concept.equals(A) || kb.isEquivalentClass(concept, A)) {
            return 0.0;
        }
        if (kb.isDisjoint(concept, A)) {
            return 1.0;
        }
        if (kb.isSubClassOf(concept, A)) {
            if (measure.equals("edgeDistance")) {
                return Distance.edgeDistance(concept, A, subR, hierarchyThreshold);
            }
            return Distance.cotopicDistance(concept, A, subR, cotopicTheshold);
        }
        if (kb.isSubClassOf(A, concept)) {
            if (measure.equals("edgeDistance")) {
                return Distance.edgeDistance(A, concept, subR, hierarchyThreshold);
            }
            return Distance.cotopicDistance(concept, A, subR, cotopicTheshold);
        }
        ArrayList<ATermAppl> t = new ArrayList<ATermAppl>();
        t.add(concept);
        t.add(A);
        List lcaList = kb.getTaxonomy().computeLCA(t);
        lcaList.remove(ATermUtils.TOP);
        if (!lcaList.isEmpty()) {
            double min = 1.0;
            for (ATermAppl X : lcaList) {
                double cur = measure.equals("edgeDistance") ? Distance.siblingEdgeDistance(concept, X, A, subR, siblingThreshold) : Distance.cotopicDistance(concept, A, subR, cotopicTheshold);
                if (!(cur < min)) continue;
                min = cur;
            }
            return min;
        }
        return 1.0;
    }

    private static double cotopicDistance(ATermAppl sub, ATermAppl sup, TaxonomicalOntologyHandler toh, double cotopicTheshold) {
        HashSet supersA = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSupers((Object)sub, false, false);
        HashSet same1 = new HashSet();
        same1.addAll(toh.getReasoner().getKB().getTaxonomy().getAllEquivalents((Object)sub));
        supersA.add(same1);
        HashSet supersB = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSupers((Object)sup, false, false);
        HashSet same2 = new HashSet();
        same2.addAll(toh.getReasoner().getKB().getTaxonomy().getAllEquivalents((Object)sup));
        supersB.add(same2);
        HashSet union = new HashSet();
        union.addAll(supersA);
        union.addAll(supersB);
        HashSet intersection = new HashSet();
        supersA.retainAll(supersB);
        intersection.addAll(supersA);
        double inters = intersection.size();
        double unio = union.size();
        if (inters / unio >= cotopicTheshold) {
            return 1.0 - inters / unio;
        }
        return 1.0;
    }

    private static double edgeDistance(ATermAppl sub, ATermAppl sup, TaxonomicalOntologyHandler toh, int hierarchyThreshold) {
        HashSet supers = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSupers((Object)sub, false, true);
        HashSet subss = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSubs((Object)sup, false, true);
        supers.retainAll(subss);
        HashSet intersection = new HashSet();
        intersection.addAll(supers);
        HashSet<ATermAppl> expandList = new HashSet<ATermAppl>();
        expandList.add(sub);
        int dist = 0;
        while (!expandList.isEmpty()) {
            ++dist;
            HashSet temp = new HashSet();
            for (ATermAppl term : expandList) {
                temp.addAll(toh.getReasoner().getKB().getTaxonomy().getSupers((Object)term, true, true));
            }
            if (temp.contains(sup)) break;
            temp.retainAll(intersection);
            expandList.clear();
            expandList.addAll(temp);
        }
        if (dist > hierarchyThreshold) {
            return 1.0;
        }
        return (double)dist / toh.getMaxD();
    }

    private static double siblingEdgeDistance(ATermAppl sub, ATermAppl T, ATermAppl sup, TaxonomicalOntologyHandler toh, int siblingThreshold) {
        HashSet supers = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSupers((Object)sub, false, true);
        HashSet subss = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSubs((Object)T, false, true);
        supers.retainAll(subss);
        HashSet intersection = new HashSet();
        intersection.addAll(supers);
        HashSet<ATermAppl> expandList = new HashSet<ATermAppl>();
        expandList.add(sub);
        int dist1 = 0;
        while (!expandList.isEmpty()) {
            ++dist1;
            HashSet temp = new HashSet();
            for (ATermAppl term : expandList) {
                temp.addAll(toh.getReasoner().getKB().getTaxonomy().getSupers((Object)term, true, true));
            }
            if (temp.contains(T)) break;
            temp.retainAll(intersection);
            expandList.clear();
            expandList.addAll(temp);
        }
        HashSet superss = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSupers((Object)sup, false, true);
        HashSet subsss = (HashSet)toh.getReasoner().getKB().getTaxonomy().getSubs((Object)T, false, true);
        superss.retainAll(subsss);
        HashSet intersection1 = new HashSet();
        intersection1.addAll(superss);
        HashSet<ATermAppl> expandList1 = new HashSet<ATermAppl>();
        expandList1.add(sup);
        int dist2 = 0;
        while (!expandList1.isEmpty()) {
            ++dist2;
            HashSet temp = new HashSet();
            for (ATermAppl term : expandList1) {
                temp.addAll(toh.getReasoner().getKB().getTaxonomy().getSupers((Object)term, true, true));
            }
            if (temp.contains(T)) break;
            temp.retainAll(intersection1);
            expandList1.clear();
            expandList1.addAll(temp);
        }
        if (dist1 + dist2 <= siblingThreshold) {
            return (double)(dist1 + dist2) / toh.getMaxD();
        }
        return 1.0;
    }

    public static double distance(ATermAppl concept, ATermAppl A, TaxonomicalOntologyHandler toh, String measure, int siblingThreshold, int hierarchyThreshold, double cotopicTheshold) {
        KnowledgeBase kb = toh.getReasoner().getKB();
        if (concept.equals(A) || kb.isEquivalentClass(concept, A)) {
            return 0.0;
        }
        if (kb.isDisjoint(concept, A)) {
            return 1.0;
        }
        if (kb.isSubClassOf(concept, A)) {
            if (measure.equals("edgeDistance")) {
                return Distance.edgeDistance(concept, A, toh, hierarchyThreshold);
            }
            return Distance.cotopicDistance(concept, A, toh, cotopicTheshold);
        }
        if (kb.isSubClassOf(A, concept)) {
            if (measure.equals("edgeDistance")) {
                return Distance.edgeDistance(A, concept, toh, hierarchyThreshold);
            }
            return Distance.cotopicDistance(concept, A, toh, cotopicTheshold);
        }
        ArrayList<ATermAppl> t = new ArrayList<ATermAppl>();
        t.add(concept);
        t.add(A);
        List lcaList = kb.getTaxonomy().computeLCA((List)((Object)ATermUtils.makeList(t)));
        lcaList.remove(ATermUtils.TOP);
        if (!lcaList.isEmpty()) {
            double min = 1.0;
            for (ATermAppl X : lcaList) {
                double cur = measure.equals("edgeDistance") ? Distance.siblingEdgeDistance(concept, X, A, toh, siblingThreshold) : Distance.cotopicDistance(concept, A, toh, cotopicTheshold);
                if (!(cur < min)) continue;
                min = cur;
            }
            return min;
        }
        return 1.0;
    }

    public static double str(String s1, String s2) {
        JaroWinkler jw = new JaroWinkler();
        return jw.getSimilarity(s1, s2);
    }
}

