/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import owlsslr_s3.DomainSubreasoner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainOntologyHandler {
    private HashSet<URI> domainURIs;
    private ArrayList<DomainSubreasoner> subreasoners;

    DomainOntologyHandler() {
        this.domainURIs = new HashSet();
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/ActorDefault.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/ApothecaryOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/books.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/concept.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/core-plus-office.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/Country.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/EMAOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/EmergencyPhysicianOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/Expression.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/extendedCamera.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/finance_th_web.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/geographydataset.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/HealthInsuranceOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/HospitalPhysicianOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/HospitalReceptionOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/MedicalFlightCompanyOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/MedicalTransportCompanyOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/messemodul.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/Mid-level-ontology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/my_ontology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/NonMedicalFlightCompanyOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/NonMedicalTransportCompanyOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/ObjectList.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/om2-1.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/ontosem.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/order.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/PatientOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/PDDLExpression.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/portal.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/protons.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/protont.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/protonu.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/ShoppingCart.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/simplified_sumo.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/spatial_ontology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/SUMO.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/support.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/technical.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/time-entry.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/travel.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/TravelMessageOntology.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/Units.owl"));
        this.domainURIs.add(URI.create("http://127.0.0.1/ontology/univ-bench.owl"));
        this.subreasoners = new ArrayList();
    }

    DomainOntologyHandler(HashSet<URI> domainURIs) {
        this.domainURIs = domainURIs;
        this.subreasoners = new ArrayList();
    }

    public void generateSubreasoners() {
        HashMap clusters = new HashMap();
        HashSet<OWLOntology> keys = new HashSet<OWLOntology>();
        HashSet values = new HashSet();
        for (URI tbox : this.domainURIs) {
            try {
                OWLOntologyManager clusterManager = OWLManager.createOWLOntologyManager();
                OWLOntology ontology = clusterManager.loadOntology(tbox);
                HashSet imports = new HashSet();
                imports.addAll(clusterManager.getImportsClosure(ontology));
                imports.remove(ontology);
                clusters.put(ontology, imports);
                keys.add(ontology);
                values.addAll(imports);
            }
            catch (OWLOntologyCreationException ex) {
                Logger.getLogger(DomainOntologyHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (OWLOntology key : keys) {
            if (!values.contains(key)) continue;
            clusters.remove(key);
        }
        Set keySet = clusters.keySet();
        int counter = 0;
        for (OWLOntology onto : keySet) {
            ++counter;
            this.subreasoners.add(new DomainSubreasoner(onto, (HashSet)clusters.get(onto)));
        }
    }

    public ArrayList<DomainSubreasoner> getSubreasoners() {
        return this.subreasoners;
    }

    public void print() {
        for (DomainSubreasoner s : this.subreasoners) {
            System.out.println(s.getOntology());
            System.out.println(s.getRelatedOntologies());
            System.out.println("---------");
        }
    }

    public DomainSubreasoner findSubreasoner(URI uri) {
        for (DomainSubreasoner subR : this.subreasoners) {
            HashSet<OWLOntology> temp = subR.getRelatedOntologies();
            for (OWLOntology onto : temp) {
                if (!uri.equals(onto.getURI())) continue;
                return subR;
            }
        }
        return null;
    }

    public DomainSubreasoner findSubreasoner(URI uriA, URI uriB) {
        for (DomainSubreasoner subR : this.subreasoners) {
            HashSet<OWLOntology> temp = subR.getRelatedOntologies();
            for (OWLOntology ontoA : temp) {
                if (!uriA.equals(ontoA.getURI())) continue;
                for (OWLOntology ontoB : temp) {
                    if (!uriB.equals(ontoB.getURI())) continue;
                    return subR;
                }
            }
        }
        return null;
    }
}

