/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainSubreasoner {
    private OWLOntologyManager manager;
    private OWLDataFactory factory;
    private Reasoner reasoner;
    private KnowledgeBase kb;
    HashSet<OWLOntology> relatedOntologies;
    double maxD;
    private OWLOntology ontology;

    DomainSubreasoner(OWLOntology ontology, HashSet<OWLOntology> imports) {
        try {
            PelletOptions.USE_COMPLETION_QUEUE = true;
            PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
            PelletOptions.USE_SMART_RESTORE = false;
            this.maxD = 0.0;
            this.relatedOntologies = new HashSet();
            this.relatedOntologies.add(ontology);
            this.relatedOntologies.addAll(imports);
            this.manager = OWLManager.createOWLOntologyManager();
            this.factory = this.manager.getOWLDataFactory();
            this.reasoner = new Reasoner(this.manager);
            this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this.reasoner);
            this.ontology = this.manager.loadOntology(ontology.getURI());
            this.reasoner.loadOntology(this.ontology);
            this.kb = this.reasoner.getKB();
            this.kb.classify();
            if (!this.kb.isConsistent()) {
                System.out.println("The ontology is inconsistent!");
                System.exit(1);
            }
            this.determineMaxD();
        }
        catch (OWLOntologyCreationException ex) {
            Logger.getLogger(DomainSubreasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public HashSet<OWLOntology> getRelatedOntologies() {
        return this.relatedOntologies;
    }

    public double getMaxD() {
        return 2.0 * this.maxD - 1.0;
    }

    private void determineMaxD() {
        this.maxD = 0.0;
        HashSet<ATermAppl> levelClasses = new HashSet<ATermAppl>();
        HashSet subClasses = new HashSet();
        levelClasses.add(ATermUtils.TOP);
        while (!levelClasses.isEmpty()) {
            for (ATermAppl aTermAppl : levelClasses) {
                subClasses.addAll(this.kb.getTaxonomy().getSubs((Object)aTermAppl, true, true));
            }
            HashSet temp = new HashSet();
            Iterator it = subClasses.iterator();
            while (it.hasNext()) {
                ATermAppl aTermAppl = (ATermAppl)it.next();
                if (!aTermAppl.equals(ATermUtils.BOTTOM)) continue;
                it.remove();
            }
            if (!subClasses.isEmpty()) {
                this.maxD += 1.0;
                temp.addAll(subClasses);
            }
            levelClasses.clear();
            levelClasses.addAll(subClasses);
            subClasses.clear();
        }
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public OWLDataFactory getFactory() {
        return this.factory;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }
}

