/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import aterm.ATerm;
import aterm.ATermAppl;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mindswap.pellet.utils.ATermUtils;
import owlsslr_s3.AdvResult;
import owlsslr_s3.Distance;
import owlsslr_s3.DomainOntologyHandler;
import owlsslr_s3.DomainSubreasoner;
import owlsslr_s3.QueryResult;
import owlsslr_s3.TaxonomicalOntologyHandler;
import owlsslr_s3.X_Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchmaking {
    DomainOntologyHandler doh;
    TaxonomicalOntologyHandler toh;
    String measure;
    ArrayList<String> characterization;
    ArrayList<String> characterizationI;
    ArrayList<String> characterizationO;
    ArrayList<String> characterizationTS;
    String tempChara;
    String tempTS;
    double a;
    double b;
    double c;
    int siblingThreshold;
    int hierarchyThreshold;
    double cotopicThreshold;
    ArrayList<String> WSF;
    String taxonomicalFilter;
    HashSet<String> FI;
    HashSet<String> FO;
    HashSet<String> FT;

    Matchmaking(DomainOntologyHandler doh, TaxonomicalOntologyHandler toh, String measure, int siblingThreshold, int hierarchyThreshold, double cotopicThreshold, double a, double b, double c, ArrayList<String> WSF, String taxonomicalFilter) {
        this.doh = doh;
        this.toh = toh;
        this.measure = measure;
        this.characterization = new ArrayList();
        this.characterizationI = new ArrayList();
        this.characterizationO = new ArrayList();
        this.characterizationTS = new ArrayList();
        this.WSF = new ArrayList();
        this.a = a;
        this.b = b;
        this.c = c;
        this.siblingThreshold = siblingThreshold;
        this.hierarchyThreshold = hierarchyThreshold;
        this.WSF.addAll(WSF);
        this.cotopicThreshold = cotopicThreshold;
        this.taxonomicalFilter = taxonomicalFilter;
        this.FI = new HashSet();
        this.FO = new HashSet();
        this.FT = new HashSet();
        if (WSF.contains("SIBLING")) {
            this.FI.add("exact");
            this.FI.add("plugin");
            this.FI.add("subsume");
            this.FI.add("sibling");
            this.FO.add("exact");
            this.FO.add("plugin");
            this.FO.add("subsume");
            this.FO.add("sibling");
        } else if (WSF.contains("SUBSUME")) {
            this.FI.add("exact");
            this.FI.add("plugin");
            this.FI.add("subsume");
            this.FO.add("exact");
            this.FO.add("plugin");
            this.FO.add("subsume");
        } else if (WSF.contains("PLUGIN")) {
            this.FI.add("exact");
            this.FI.add("plugin");
            this.FO.add("exact");
            this.FO.add("subsume");
        } else if (WSF.contains("EXACT")) {
            this.FI.add("exact");
            this.FO.add("exact");
        } else {
            System.out.println("Please specify a Web service filter");
            System.exit(0);
        }
        if (taxonomicalFilter.equals("exact")) {
            this.FT.add("exact");
        } else if (taxonomicalFilter.equals("plugin")) {
            this.FT.add("exact");
            this.FT.add("plugin");
        } else if (taxonomicalFilter.equals("subsume")) {
            this.FT.add("exact");
            this.FT.add("plugin");
            this.FT.add("subsume");
        } else if (taxonomicalFilter.equals("sibling")) {
            this.FT.add("exact");
            this.FT.add("plugin");
            this.FT.add("subsume");
            this.FT.add("sibling");
        }
    }

    public QueryResult start(HashSet<X_Object> advertisements, X_Object query) {
        QueryResult qr = new QueryResult();
        qr.setQ(query);
        if (!this.checkQueryIO(query)) {
            return qr;
        }
        for (X_Object adv : advertisements) {
            if (!this.checkAdvIO(adv)) continue;
            this.characterization.clear();
            this.characterizationI.clear();
            this.characterizationO.clear();
            this.characterizationTS.clear();
            this.tempChara = "";
            this.tempTS = "";
            double FSI = this.K(query.getInputs(), adv.getInputs(), this.FI, true);
            this.characterizationI.addAll(this.characterization);
            this.characterization.clear();
            double FSO = this.K(adv.getOutputs(), query.getOutputs(), this.FO, false);
            this.characterizationO.addAll(this.characterization);
            this.characterization.clear();
            double FS = Math.sqrt(FSI * FSO);
            double TS = 1.0;
            double NFS = Distance.str(query.getServiceName(), adv.getServiceName());
            if (FS == 0.0 || TS == 0.0) continue;
            AdvResult r = new AdvResult();
            r.setAdvertisement(adv);
            r.setInputCharacterization(this.characterizationI);
            r.setOutputCharacterization(this.characterizationO);
            r.setTaxonomicalCharacterization(this.characterizationTS);
            r.setFS(FS);
            r.setNFS(NFS);
            r.setTS(TS);
            r.computeWeightedSimilarity(this.a, this.b, this.c);
            qr.addResult(r);
        }
        return qr;
    }

    public double K(HashSet<ATermAppl> SA, HashSet<ATermAppl> SB, HashSet<String> F, boolean bool) {
        double sim = 0.0;
        if (bool) {
            if (SB.isEmpty()) {
                this.characterization.add("exact");
                return 0.0;
            }
        } else if (SB.isEmpty()) {
            this.characterization.add("exact");
            return 1.0;
        }
        for (ATermAppl B : SB) {
            ArrayList<String> tem = new ArrayList<String>();
            double max = 0.0;
            for (ATermAppl A : SA) {
                double temp = this.inter(B, A, F);
                if (!(temp > max)) continue;
                tem.add(this.tempChara);
                max = temp;
            }
            if (tem.contains("exact")) {
                this.characterization.add("exact");
            } else if (tem.contains("plugin")) {
                this.characterization.add("plugin");
            } else if (tem.contains("subsume")) {
                this.characterization.add("subsume");
            } else if (tem.contains("sibling")) {
                this.characterization.add("sibling");
            }
            if (max == 0.0) {
                return 0.0;
            }
            sim += max;
        }
        return sim / (double)SB.size();
    }

    public double inter(ATermAppl A, ATermAppl B, HashSet<String> F) {
        this.tempChara = "";
        String uriA = A.getName().substring(0, A.getName().indexOf("#"));
        String uriB = B.getName().substring(0, B.getName().indexOf("#"));
        DomainSubreasoner subR = this.doh.findSubreasoner(URI.create(uriA), URI.create(uriB));
        if (subR == null) {
            return 0.0;
        }
        if (F.contains("exact") && (subR.getReasoner().getKB().isEquivalentClass(A, B) || A.equals(B))) {
            this.tempChara = "exact";
            return 1.0 - Distance.distance(A, B, subR, this.measure, this.siblingThreshold, this.hierarchyThreshold, this.cotopicThreshold);
        }
        if (F.contains("plugin") && subR.getReasoner().getKB().isSubClassOf(A, B)) {
            this.tempChara = "plugin";
            return 1.0 - Distance.distance(A, B, subR, this.measure, this.siblingThreshold, this.hierarchyThreshold, this.cotopicThreshold);
        }
        if (F.contains("subsume") && subR.getReasoner().getKB().isSubClassOf(B, A)) {
            this.tempChara = "subsume";
            return 1.0 - Distance.distance(A, B, subR, this.measure, this.siblingThreshold, this.hierarchyThreshold, this.cotopicThreshold);
        }
        if (F.contains("sibling")) {
            ArrayList<ATermAppl> t = new ArrayList<ATermAppl>();
            t.add(A);
            t.add(B);
            List lcaList = subR.getReasoner().getKB().getTaxonomy().computeLCA(t);
            lcaList.remove(ATermUtils.TOP);
            if (!lcaList.isEmpty()) {
                this.tempChara = "sibling";
                return 1.0 - Distance.distance(A, B, subR, this.measure, this.siblingThreshold, this.hierarchyThreshold, this.cotopicThreshold);
            }
        }
        return 0.0;
    }

    private boolean checkQueryIO(X_Object query) {
        HashSet<ATermAppl> inputs = query.getInputs();
        inputs.addAll(query.getOutputs());
        for (ATermAppl in : inputs) {
            String uriA = in.getName().substring(0, in.getName().indexOf("#"));
            DomainSubreasoner subR = this.doh.findSubreasoner(URI.create(uriA));
            if (subR == null) {
                System.out.println("Cannot resolve ontology URI " + uriA);
                System.out.println("Query " + query.getUri() + " will be ignored");
                return false;
            }
            if (subR.getReasoner().getKB().isClass((ATerm)in)) continue;
            System.out.println(in.toString() + " is not a concept");
            System.out.println("Query " + query.getUri() + " will be ignored");
            return false;
        }
        return true;
    }

    private boolean checkAdvIO(X_Object adv) {
        HashSet<ATermAppl> inputs = adv.getInputs();
        inputs.addAll(adv.getOutputs());
        for (ATermAppl in : inputs) {
            String uriA = in.getName().substring(0, in.getName().indexOf("#"));
            DomainSubreasoner subR = this.doh.findSubreasoner(URI.create(uriA));
            if (subR == null) {
                System.out.println("Cannot resolve ontology URI " + uriA);
                System.out.println("Advertisement " + adv.getUri() + " will be ignored");
                return false;
            }
            if (subR.getReasoner().getKB().isClass((ATerm)in)) continue;
            System.out.println(in.toString() + " is not a concept");
            System.out.println("Advertisement " + adv.getUri() + " will be ignored");
            return false;
        }
        return true;
    }
}

