/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import owlsslr_s3.Configuration;
import owlsslr_s3.X_Object;

public class Query {
    OWLOntology ontology;
    Configuration conf;
    OWLOntologyManager manager;
    OWLDataFactory factory;
    X_Object qo;
    private String name;

    public Query(URI uri, Configuration conf, OWLOntologyManager manager, OWLDataFactory factory) {
        try {
            this.conf = conf;
            this.qo = new X_Object();
            this.manager = manager;
            this.factory = factory;
            this.ontology = manager.loadOntology(uri);
            this.createQ_Object();
        }
        catch (OWLOntologyCreationException ex) {
            Logger.getLogger(Query.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private X_Object createQ_Object() {
        Set outputs;
        OWLClass profile = this.factory.getOWLClass(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#Profile"));
        OWLObjectProperty hasInput = this.factory.getOWLObjectProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#hasInput"));
        OWLObjectProperty hasOutput = this.factory.getOWLObjectProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#hasOutput"));
        OWLDataProperty parameterType = this.factory.getOWLDataProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Process.owl#parameterType"));
        OWLDataProperty serviceName = this.factory.getOWLDataProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#serviceName"));
        this.qo = new X_Object();
        OWLIndividual advertisement = (OWLIndividual)profile.getIndividuals(this.ontology).iterator().next();
        Map v1 = advertisement.getObjectPropertyValues(this.ontology);
        this.qo.setUri(this.ontology.getURI());
        Map dataPropertyValues = advertisement.getDataPropertyValues(this.ontology);
        this.name = ((OWLConstant)((Set)dataPropertyValues.get(serviceName)).iterator().next()).getLiteral();
        this.qo.setServiceName(this.name);
        Set inputs = (Set)v1.get(hasInput);
        if (inputs != null) {
            for (OWLIndividual input : inputs) {
                Map v2 = input.getDataPropertyValues(this.ontology);
                OWLConstant paramType = (OWLConstant)((Set)v2.get(parameterType)).iterator().next();
                this.qo.setInput(ATermUtils.makeTermAppl((String)paramType.getLiteral()));
            }
        }
        if ((outputs = (Set)v1.get(hasOutput)) != null) {
            for (OWLIndividual output : outputs) {
                Map v2 = output.getDataPropertyValues(this.ontology);
                OWLConstant paramType = (OWLConstant)((Set)v2.get(parameterType)).iterator().next();
                this.qo.setOutput(ATermUtils.makeTermAppl((String)paramType.getLiteral()));
            }
        }
        return this.qo;
    }

    public X_Object getQ_Object() {
        return this.qo;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public void printAxioms() {
        for (OWLAxiom axiom : this.ontology.getAxioms()) {
            System.out.println(axiom);
        }
    }
}

