/*
 * Decompiled with CFR 0.152.
 */
package owlsslr_s3;

import aterm.ATermAppl;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.util.OWLOntologyMerger;
import owlsslr_s3.Advertisement;
import owlsslr_s3.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomicalOntologyHandler {
    Reasoner taxonomicalReasoner;
    OWLOntologyManager taxonomicalManager;
    OWLOntology mergedOntology;
    Configuration conf;
    double maxD;

    TaxonomicalOntologyHandler(Configuration conf) {
        try {
            this.conf = conf;
            this.taxonomicalManager = OWLManager.createOWLOntologyManager();
            for (URI uri : conf.getOwls_repository()) {
                this.taxonomicalManager.loadOntology(uri);
            }
            OWLOntologyMerger om = new OWLOntologyMerger((OWLOntologySetProvider)this.taxonomicalManager);
            this.mergedOntology = om.createMergedOntology(this.taxonomicalManager, URI.create("http://OWLS-SLR//mergedOntology.owl"));
            this.taxonomicalReasoner = new Reasoner(this.taxonomicalManager);
            this.taxonomicalManager.addOntologyChangeListener((OWLOntologyChangeListener)this.taxonomicalReasoner);
            this.taxonomicalReasoner.loadOntology(this.mergedOntology);
            this.taxonomicalReasoner.classify();
            this.determineMaxD();
        }
        catch (OWLOntologyCreationException ex) {
            Logger.getLogger(TaxonomicalOntologyHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (OWLOntologyChangeException ex) {
            Logger.getLogger(TaxonomicalOntologyHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void applyAdvertisements(ArrayList<Advertisement> parsedAdvertisements) {
        try {
            PelletOptions.REALIZE_INDIVIDUAL_AT_A_TIME = false;
            for (Advertisement adv : parsedAdvertisements) {
                Set axioms = adv.getOntology().getAxioms();
                for (OWLAxiom axiom : axioms) {
                    this.taxonomicalManager.applyChange((OWLOntologyChange)new AddAxiom(this.mergedOntology, axiom));
                }
            }
            this.taxonomicalReasoner.realise();
        }
        catch (OWLReasonerException ex) {
            Logger.getLogger(TaxonomicalOntologyHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (OWLOntologyChangeException ex) {
            Logger.getLogger(TaxonomicalOntologyHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void applyAdvertisement(Advertisement adv) {
        try {
            PelletOptions.REALIZE_INDIVIDUAL_AT_A_TIME = false;
            Set axioms = adv.getOntology().getAxioms();
            for (OWLAxiom axiom : axioms) {
                this.taxonomicalManager.applyChange((OWLOntologyChange)new AddAxiom(this.mergedOntology, axiom));
            }
            this.taxonomicalReasoner.realise();
        }
        catch (OWLReasonerException ex) {
            Logger.getLogger(TaxonomicalOntologyHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (OWLOntologyChangeException ex) {
            Logger.getLogger(TaxonomicalOntologyHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public double getMaxD() {
        return 2.0 * this.maxD - 1.0;
    }

    private void determineMaxD() {
        HashSet<ATermAppl> levelClasses = new HashSet<ATermAppl>();
        HashSet subClasses = new HashSet();
        levelClasses.add(ATermUtils.TOP);
        while (!levelClasses.isEmpty()) {
            for (ATermAppl aTermAppl : levelClasses) {
                subClasses.addAll(this.getReasoner().getKB().getTaxonomy().getSubs((Object)aTermAppl, true, true));
            }
            HashSet temp = new HashSet();
            Iterator it = subClasses.iterator();
            while (it.hasNext()) {
                ATermAppl aTermAppl = (ATermAppl)it.next();
                if (!aTermAppl.equals(ATermUtils.BOTTOM)) continue;
                it.remove();
            }
            if (!subClasses.isEmpty()) {
                this.maxD += 1.0;
                temp.addAll(subClasses);
            }
            levelClasses.clear();
            levelClasses.addAll(subClasses);
            subClasses.clear();
        }
    }

    public Reasoner getReasoner() {
        return this.taxonomicalReasoner;
    }
}

