/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.Matchmaker;
import de.dfki.sme2.TestCollection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Configuration {
    private Logger logger = Logger.getLogger(this.getClass());
    private TestCollection testCollection = null;
    private Collection<Matchmaker> selectedMatchmakers = null;
    private String outputDirectory = null;
    private boolean autoSave = false;
    private boolean checkQRT = true;
    private boolean checkOPT = true;
    private boolean checkExecTime = true;
    private boolean checkMemory = true;
    private boolean checkScalability = false;
    private int scalabilityFractionSize = 25;
    private int lambda = 20;
    private boolean checkRP = false;
    private boolean checkF1 = false;
    private boolean checkRF = false;
    private boolean useMicroAvg = false;
    private boolean useMacroAvg = true;
    private boolean checkAP = false;
    private boolean checkAPPrime = false;
    private boolean checkBpref = false;
    private boolean checkQ = false;
    private boolean checkNDCG = false;
    private boolean checkRBP = false;
    private double rbpParam = 0.8;
    private boolean checkQPrime = false;
    private boolean checkNDCGPrime = false;
    private boolean checkTCQuality = false;
    private int folds = 10;
    private long seed = 1L;

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    private void reset() {
        this.testCollection = null;
        this.selectedMatchmakers = new LinkedList<Matchmaker>();
        this.checkQRT = false;
        this.checkOPT = false;
        this.checkExecTime = false;
        this.checkMemory = false;
        this.checkScalability = false;
        this.scalabilityFractionSize = 25;
        this.lambda = 20;
        this.checkRP = false;
        this.checkF1 = false;
        this.checkRF = false;
        this.useMicroAvg = false;
        this.useMacroAvg = false;
        this.checkAP = false;
        this.checkAPPrime = false;
        this.checkBpref = false;
        this.checkQ = false;
        this.checkNDCG = false;
        this.checkRBP = false;
        this.rbpParam = 0.8;
        this.checkQPrime = false;
        this.checkNDCGPrime = false;
        this.checkTCQuality = false;
        this.folds = 10;
    }

    public boolean isCheckAP() {
        return this.checkAP;
    }

    public void setCheckAP(boolean checkAP) {
        this.checkAP = checkAP;
    }

    public boolean isCheckAPPrime() {
        return this.checkAPPrime;
    }

    public void setCheckAPPrime(boolean checkAPPrime) {
        this.checkAPPrime = checkAPPrime;
    }

    public boolean isCheckBpref() {
        return this.checkBpref;
    }

    public void setCheckBpref(boolean checkBpref) {
        this.checkBpref = checkBpref;
    }

    public boolean isCheckExecTime() {
        return this.checkExecTime;
    }

    public void setCheckExecTime(boolean checkExecTime) {
        this.checkExecTime = checkExecTime;
    }

    public boolean isCheckF1() {
        return this.checkF1;
    }

    public void setCheckF1(boolean checkF1) {
        this.checkF1 = checkF1;
    }

    public boolean isCheckMemory() {
        return this.checkMemory;
    }

    public void setCheckMemory(boolean checkMemory) {
        this.checkMemory = checkMemory;
    }

    public boolean isCheckNDCG() {
        return this.checkNDCG;
    }

    public void setCheckNDCG(boolean checkNDCG) {
        this.checkNDCG = checkNDCG;
    }

    public boolean isCheckNDCGPrime() {
        return this.checkNDCGPrime;
    }

    public void setCheckNDCGPrime(boolean checkNDCGPrime) {
        this.checkNDCGPrime = checkNDCGPrime;
    }

    public boolean isCheckQ() {
        return this.checkQ;
    }

    public void setCheckQ(boolean checkQ) {
        this.checkQ = checkQ;
    }

    public boolean isCheckQPrime() {
        return this.checkQPrime;
    }

    public void setCheckQPrime(boolean checkQPrime) {
        this.checkQPrime = checkQPrime;
    }

    public boolean isCheckQRT() {
        return this.checkQRT;
    }

    public boolean isCheckOPT() {
        return this.checkOPT;
    }

    public void setCheckQRT(boolean checkQRT) {
        this.checkQRT = checkQRT;
    }

    public void setCheckOPT(boolean checkOPT) {
        this.checkOPT = checkOPT;
    }

    public boolean isCheckRBP() {
        return this.checkRBP;
    }

    public void setCheckRBP(boolean checkRBP) {
        this.checkRBP = checkRBP;
    }

    public boolean isCheckRF() {
        return this.checkRF;
    }

    public void setCheckRF(boolean checkRF) {
        this.checkRF = checkRF;
    }

    public boolean isCheckRP() {
        return this.checkRP;
    }

    public void setCheckRP(boolean checkRP) {
        this.checkRP = checkRP;
    }

    public boolean isCheckScalability() {
        return this.checkScalability;
    }

    public void setCheckScalability(boolean checkScalability) {
        this.checkScalability = checkScalability;
    }

    public double getRbpParam() {
        return this.rbpParam;
    }

    public void setRbpParam(double rbpParam) {
        this.rbpParam = rbpParam;
    }

    public int getScalabilityFractionSize() {
        return this.scalabilityFractionSize;
    }

    public void setScalabilityFractionSize(int scalabilityFractionSize) {
        this.scalabilityFractionSize = scalabilityFractionSize;
    }

    public Collection<Matchmaker> getSelectedMatchmakers() {
        return this.selectedMatchmakers;
    }

    public void setSelectedMatchmakers(Collection<Matchmaker> selectedMatchmakers) {
        this.selectedMatchmakers = selectedMatchmakers;
    }

    public void setSelectedMatchmakers(TreeModel treeModel) {
        this.selectedMatchmakers = new LinkedList<Matchmaker>();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        int i = 0;
        while (i < rootNode.getChildCount()) {
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            int j = 0;
            while (j < groupNode.getChildCount()) {
                DefaultMutableTreeNode mmNode = (DefaultMutableTreeNode)groupNode.getChildAt(j);
                this.selectedMatchmakers.add((Matchmaker)mmNode.getUserObject());
                ++j;
            }
            ++i;
        }
    }

    public TestCollection getTestCollection() {
        return this.testCollection;
    }

    public void setTestCollection(TestCollection testCollection) {
        this.testCollection = testCollection;
    }

    public boolean isUseMacroAvg() {
        return this.useMacroAvg;
    }

    public void setUseMacroAvg(boolean useMacroAvg) {
        this.useMacroAvg = useMacroAvg;
    }

    public boolean isUseMicroAvg() {
        return this.useMicroAvg;
    }

    public void setUseMicroAvg(boolean useMicroAvg) {
        this.useMicroAvg = useMicroAvg;
    }

    public boolean isValid() {
        if (this.testCollection == null) {
            return false;
        }
        return this.selectedMatchmakers != null && !this.selectedMatchmakers.isEmpty();
    }

    public int getLambda() {
        return this.lambda;
    }

    public void setLambda(int lambda) {
        this.lambda = lambda;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void load(String fileName, List<TestCollection> testCollections, List<Matchmaker> matchmakers) {
        this.reset();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileName);
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node configNode = nodes.item(i);
                if (configNode.getNodeType() == 1) {
                    String configNodeName = configNode.getNodeName();
                    if (configNodeName.equals("testcollection")) {
                        String tcName = configNode.getTextContent();
                        for (TestCollection tc : testCollections) {
                            if (tc == null || !tc.getName().equals(tcName)) continue;
                            this.testCollection = tc;
                            break;
                        }
                    } else if (configNodeName.equals("selectedmatchmakers")) {
                        this.parseMatchmakers(configNode, matchmakers);
                    } else if (configNodeName.equals("output")) {
                        this.outputDirectory = configNode.getTextContent();
                        this.autoSave = configNode.getAttributes().getNamedItem("auto").getNodeValue().equals("true");
                    } else if (configNodeName.equals("evaluation")) {
                        NodeList subNodes = configNode.getChildNodes();
                        int j = 0;
                        while (j < subNodes.getLength()) {
                            Node subNode = subNodes.item(j);
                            if (subNode.getNodeName().equals("general")) {
                                this.parseGeneralEvalInfo(subNode);
                            } else if (subNode.getNodeName().equals("binaryrelevance")) {
                                this.parseEvalInfoForBinaryRelevance(subNode);
                            } else if (subNode.getNodeName().equals("gradedrelevance")) {
                                this.parseEvalInfoForGradedRelevance(subNode);
                            } else if (subNode.getNodeName().equals("tcquality")) {
                                this.parseTCQuality(subNode);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (SAXException e) {
            this.logger.warn((Object)("Configuration parsing error for file " + fileName + "."), (Throwable)e);
            return;
        }
        catch (IOException e) {
            this.logger.warn((Object)("File " + fileName + " not found. Unable to parse configuration file"), (Throwable)e);
            return;
        }
        catch (ParserConfigurationException e) {
            this.logger.warn((Object)"Unable to create XML parser.", (Throwable)e);
            return;
        }
    }

    private void parseEvalInfoForGradedRelevance(Node node) {
        NodeList subNodes = node.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node currentNode = subNodes.item(i);
            if (currentNode.getNodeName().equals("q")) {
                this.checkQ = true;
            } else if (currentNode.getNodeName().equals("ndcg")) {
                this.checkNDCG = true;
            } else if (currentNode.getNodeName().equals("rbp")) {
                this.checkRBP = true;
                this.rbpParam = new Double(currentNode.getAttributes().getNamedItem("p").getNodeValue());
            } else if (currentNode.getNodeName().equals("q_prime")) {
                this.checkQPrime = true;
            } else if (currentNode.getNodeName().equals("ndcg_prime")) {
                this.checkNDCGPrime = true;
            }
            ++i;
        }
    }

    private void parseTCQuality(Node node) {
        this.checkTCQuality = true;
        this.folds = new Integer(node.getAttributes().getNamedItem("folds").getNodeValue());
        this.seed = new Long(node.getAttributes().getNamedItem("seed").getNodeValue());
    }

    private void parseEvalInfoForBinaryRelevance(Node node) {
        this.lambda = new Integer(node.getAttributes().getNamedItem("lambda").getNodeValue());
        NodeList subNodes = node.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node currentNode = subNodes.item(i);
            if (currentNode.getNodeName().equals("recallprecision")) {
                this.checkRP = true;
            } else if (currentNode.getNodeName().equals("f1")) {
                this.checkF1 = true;
            } else if (currentNode.getNodeName().equals("recallfallout")) {
                this.checkRF = true;
            } else if (currentNode.getNodeName().equals("averaging")) {
                NodeList subSubNodes = currentNode.getChildNodes();
                int j = 0;
                while (j < subSubNodes.getLength()) {
                    if (subSubNodes.item(j).getNodeName().equals("micro")) {
                        this.useMicroAvg = true;
                    }
                    if (subSubNodes.item(j).getNodeName().equals("macro")) {
                        this.useMacroAvg = true;
                    }
                    ++j;
                }
            } else if (currentNode.getNodeName().equals("averageprecision")) {
                this.checkAP = true;
            } else if (currentNode.getNodeName().equals("averageprecision_prime")) {
                this.checkAPPrime = true;
            } else if (currentNode.getNodeName().equals("bpref")) {
                this.checkBpref = true;
            }
            ++i;
        }
    }

    private void parseGeneralEvalInfo(Node node) {
        NodeList subNodes = node.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node currentNode = subNodes.item(i);
            if (currentNode.getNodeName().equals("queryresponsetime")) {
                this.checkQRT = true;
            } else if (currentNode.getNodeName().equals("averageoffersprocessingtime")) {
                this.checkOPT = true;
            } else if (currentNode.getNodeName().equals("executiontime")) {
                this.checkExecTime = true;
            } else if (currentNode.getNodeName().equals("memoryconsumption")) {
                this.checkMemory = true;
            } else if (currentNode.getNodeName().equals("scalability")) {
                this.checkScalability = true;
                this.scalabilityFractionSize = new Integer(currentNode.getAttributes().getNamedItem("fractionpertest").getNodeValue());
            }
            ++i;
        }
    }

    private void parseMatchmakers(Node mmNode, List<Matchmaker> matchmakers) {
        NodeList subNodes = mmNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node currentNode = subNodes.item(i);
            if (currentNode.getNodeName().equals("matchmaker")) {
                String mmName = currentNode.getTextContent();
                for (Matchmaker mm : matchmakers) {
                    if (!mm.getName().equals(mmName)) continue;
                    this.selectedMatchmakers.add(mm);
                    break;
                }
            }
            ++i;
        }
    }

    public void save(String fileName) {
        try {
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element configuration = xml.createElement("configuration");
            Element tcElem = xml.createElement("testcollection");
            if (this.testCollection != null) {
                tcElem.setTextContent(this.testCollection.getName());
            }
            configuration.appendChild(tcElem);
            if (this.selectedMatchmakers != null) {
                Element mmsElem = xml.createElement("selectedmatchmakers");
                for (Matchmaker mm : this.selectedMatchmakers) {
                    Element mmElem = xml.createElement("matchmaker");
                    mmElem.setTextContent(mm.getName());
                    mmsElem.appendChild(mmElem);
                }
                configuration.appendChild(mmsElem);
            }
            if (this.outputDirectory != null) {
                Element outElem = xml.createElement("output");
                outElem.setTextContent(this.outputDirectory);
                if (this.autoSave) {
                    outElem.setAttribute("auto", "true");
                } else {
                    outElem.setAttribute("auto", "false");
                }
                configuration.appendChild(outElem);
            }
            Element evalElem = xml.createElement("evaluation");
            Element generalElem = xml.createElement("general");
            if (this.checkQRT) {
                generalElem.appendChild(xml.createElement("queryresponsetime"));
            }
            if (this.checkOPT) {
                generalElem.appendChild(xml.createElement("averageoffersprocessingtime"));
            }
            if (this.checkExecTime) {
                generalElem.appendChild(xml.createElement("executiontime"));
            }
            if (this.checkMemory) {
                generalElem.appendChild(xml.createElement("memoryconsumption"));
            }
            if (this.checkScalability) {
                Element scalabilityElem = xml.createElement("scalability");
                scalabilityElem.setAttribute("fractionpertest", new Integer(this.scalabilityFractionSize).toString());
                generalElem.appendChild(scalabilityElem);
            }
            evalElem.appendChild(generalElem);
            Element binaryElem = xml.createElement("binaryrelevance");
            binaryElem.setAttribute("lambda", new Integer(this.lambda).toString());
            if (this.checkRP) {
                binaryElem.appendChild(xml.createElement("recallprecision"));
            }
            if (this.checkF1) {
                binaryElem.appendChild(xml.createElement("f1"));
            }
            if (this.checkRF) {
                binaryElem.appendChild(xml.createElement("recallfallout"));
            }
            Element avgElem = xml.createElement("averaging");
            if (this.useMicroAvg) {
                avgElem.appendChild(xml.createElement("micro"));
            }
            if (this.useMacroAvg) {
                avgElem.appendChild(xml.createElement("macro"));
            }
            binaryElem.appendChild(avgElem);
            if (this.checkAP) {
                binaryElem.appendChild(xml.createElement("averageprecision"));
            }
            if (this.checkAPPrime) {
                binaryElem.appendChild(xml.createElement("averageprecision_prime"));
            }
            if (this.checkBpref) {
                binaryElem.appendChild(xml.createElement("bpref"));
            }
            evalElem.appendChild(binaryElem);
            Element gradedElem = xml.createElement("gradedrelevance");
            if (this.checkQ) {
                gradedElem.appendChild(xml.createElement("q"));
            }
            if (this.checkNDCG) {
                gradedElem.appendChild(xml.createElement("ndcg"));
            }
            if (this.checkRBP) {
                Element rbpElem = xml.createElement("rbp");
                rbpElem.setAttribute("p", new Double(this.rbpParam).toString());
                gradedElem.appendChild(rbpElem);
            }
            if (this.checkQPrime) {
                gradedElem.appendChild(xml.createElement("q_prime"));
            }
            if (this.checkNDCGPrime) {
                gradedElem.appendChild(xml.createElement("ndcg_prime"));
            }
            evalElem.appendChild(gradedElem);
            if (this.checkTCQuality) {
                Element elem = xml.createElement("tcquality");
                elem.setAttribute("folds", new Integer(this.folds).toString());
                elem.setAttribute("seed", new Long(this.seed).toString());
                evalElem.appendChild(elem);
            }
            configuration.appendChild(evalElem);
            xml.appendChild(configuration);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(new File(fileName));
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException e) {
                this.logger.error((Object)("Unable to save configuration at " + fileName + "."), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                this.logger.error((Object)("Unable to save configuration at " + fileName + "."), (Throwable)e);
            }
            catch (TransformerException e) {
                this.logger.error((Object)("Unable to save configuration at " + fileName + "."), (Throwable)e);
            }
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("Unable to save configuration at " + fileName + "."), (Throwable)e);
        }
    }

    public boolean isCheckTCQuality() {
        return this.checkTCQuality;
    }

    public void setCheckTCQuality(boolean checkTCQuality) {
        this.checkTCQuality = checkTCQuality;
    }

    public int getFolds() {
        return this.folds;
    }

    public void setFolds(int folds) {
        this.folds = folds;
    }
}

