/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.Configuration;
import de.dfki.sme2.IMatchmakerPlugin;
import de.dfki.sme2.Matchmaker;
import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.MemoryMonitor;
import de.dfki.sme2.TestCollection;
import de.dfki.sme2.http.HttpServer;
import de.dfki.sme2.util.metric.MacroAvgRecallFallout;
import de.dfki.sme2.util.metric.MacroAvgRecallPrecision;
import de.dfki.sme2.util.metric.MicroAvgRecallFallout;
import de.dfki.sme2.util.metric.MicroAvgRecallPrecision;
import de.dfki.sme2.util.metric.RecallPrecisionPair;
import de.dfki.sme2.util.metric.SingleQueryMeasures;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MatchmakerEvaluation {
    protected static Logger logger = Logger.getLogger(MatchmakerEvaluation.class);
    protected Configuration config;
    protected MemoryMonitor memMonitor;
    public boolean duplicatesDetected;
    protected String version = null;
    public long averageOfferParsingTime;
    public long averageOfferProcessingTime;
    protected HttpServer http = null;

    public MatchmakerEvaluation(Configuration config) {
        this.config = config;
    }

    public MatchmakerEvaluationResult[] evaluate() throws Exception {
        MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[this.config.getSelectedMatchmakers().size()];
        int i = 0;
        for (Matchmaker matchmaker : this.config.getSelectedMatchmakers()) {
            results[i] = this.evaluate(matchmaker);
            if (this.config.isAutoSave()) {
                String dateTimeStr = new Date().toString().replace(':', '-').replace(' ', '_');
                results[i].save(String.valueOf(this.config.getOutputDirectory()) + File.separator + dateTimeStr + "_" + results[i].getMatchmakerName() + ".xml");
            }
            ++i;
        }
        return results;
    }

    protected void startJettyHttpServer(File htdocs) throws Exception {
        this.http = new HttpServer();
        this.http.start(htdocs);
        while (!this.http.isRunning()) {
        }
        logger.info((Object)("Jetty HTTP server started on port 80 with \"" + htdocs.toString() + "\" as htdocs root."));
    }

    protected void stopJettyHttpServer() throws Exception {
        this.http.stop();
        while (!this.http.isStopped()) {
        }
        logger.info((Object)"Jetty HTTP server stopped.");
    }

    protected MatchmakerEvaluationResult evaluate(Matchmaker matchmaker) throws Exception {
        Set<URI> binaryRelevants;
        IMatchmakerPlugin plugin = matchmaker.getPluginInstance();
        this.version = matchmaker.getVersion();
        TestCollection tc = this.config.getTestCollection();
        if (tc.getHtdocs() != null) {
            this.startJettyHttpServer(tc.getHtdocs());
        }
        if (this.config.isCheckMemory()) {
            this.memMonitor = new MemoryMonitor();
            new Thread(this.memMonitor).start();
        }
        Date startTime = null;
        if (this.config.isCheckExecTime()) {
            startTime = new Date();
        }
        MatchmakerEvaluationResult evalResult = new MatchmakerEvaluationResult(matchmaker.getName(), this.config.getTestCollection().getName());
        this.registerServiceOffers(plugin, matchmaker.getName(), matchmaker.getVersion(), evalResult);
        this.sendRequestsToMatchmaker(plugin, matchmaker.getName(), evalResult, matchmaker.getVersion());
        if (this.config.isCheckExecTime()) {
            long totalExecTime = new Date().getTime() - startTime.getTime();
            evalResult.setTotalExecutionTime(totalExecTime);
        }
        if (this.config.isCheckMemory()) {
            this.memMonitor.stop();
            evalResult.setMemoryConsumption(this.memMonitor.getMemoryConsumptionPerInterval());
        }
        if (tc.getHtdocs() != null) {
            this.stopJettyHttpServer();
        }
        if ((this.config.isCheckRP() || this.config.isCheckF1()) && this.config.isUseMacroAvg()) {
            MacroAvgRecallPrecision macroRP = new MacroAvgRecallPrecision(this.config.getLambda());
            for (URI query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                macroRP.processRecallPrecision(evalResult.getRanking(query), new ArrayList<URI>(binaryRelevants));
            }
            evalResult.setMacroAvgRP(macroRP.getMacroAveragePrecisions());
        }
        if (this.config.isCheckF1() && this.config.isUseMacroAvg()) {
            ArrayList<RecallPrecisionPair> rpValues = evalResult.getMacroAvgRP();
            evalResult.setMacroAvgF1(rpValues);
        }
        if (this.config.isCheckRF() && this.config.isUseMacroAvg()) {
            MacroAvgRecallFallout macroRF = new MacroAvgRecallFallout(this.config.getLambda());
            for (URI query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                macroRF.processRecallFallout(evalResult.getRanking(query), new ArrayList<URI>(binaryRelevants), tc.getNumberOfServiceOffers());
            }
            evalResult.setMacroAvgRF(macroRF.getMacroAverageFallouts());
        }
        if ((this.config.isCheckRP() || this.config.isCheckF1()) && this.config.isUseMicroAvg()) {
            MicroAvgRecallPrecision microRP = new MicroAvgRecallPrecision(this.config.getLambda());
            for (URI query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                microRP.processRecallPrecision(evalResult.getRanking(query), new ArrayList<URI>(binaryRelevants));
            }
            evalResult.setMicroAvgRP(microRP.getMicroAveragePrecisions());
        }
        if (this.config.isCheckF1() && this.config.isUseMicroAvg()) {
            ArrayList<RecallPrecisionPair> rpValues = evalResult.getMicroAvgRP();
            evalResult.setMicroAvgF1(rpValues);
        }
        if (this.config.isCheckRF() && this.config.isUseMicroAvg()) {
            MicroAvgRecallFallout microRF = new MicroAvgRecallFallout(this.config.getLambda());
            for (URI query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                microRF.processRecallFallout(evalResult.getRanking(query), new ArrayList<URI>(binaryRelevants), tc.getNumberOfServiceOffers());
            }
            evalResult.setMicroAvgRF(microRF.getMicroAverageFallouts());
        }
        if (this.config.isCheckAP()) {
            for (URI query : tc.getQueries()) {
                Set<URI> binaryRelevants2 = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                evalResult.addAP(query, SingleQueryMeasures.getAveragePrecision(evalResult.getRanking(query), binaryRelevants2));
            }
        }
        if (this.config.isCheckAPPrime()) {
            for (URI query : tc.getQueries()) {
                evalResult.addAPPrime(query, SingleQueryMeasures.getAveragePrecisionPrime(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckQ()) {
            for (URI query : tc.getQueries()) {
                evalResult.addQ(query, SingleQueryMeasures.getQ(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckQPrime()) {
            for (URI query : tc.getQueries()) {
                evalResult.addQPrime(query, SingleQueryMeasures.getQPrime(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckNDCG()) {
            for (URI query : tc.getQueries()) {
                evalResult.addNDCG(query, SingleQueryMeasures.getNDCG(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckNDCGPrime()) {
            for (URI query : tc.getQueries()) {
                evalResult.addNDCGPrime(query, SingleQueryMeasures.getNDCGPrime(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.duplicatesDetected) {
            JOptionPane.showMessageDialog(null, "Duplicates in result service rankings have been detected and removed.", "Results Error!", 0);
        }
        return evalResult;
    }

    protected void registerServiceOffers(IMatchmakerPlugin plugin, String matchmakerName, String version, MatchmakerEvaluationResult evalResult) {
        TestCollection tc = this.config.getTestCollection();
        int i = 0;
        this.averageOfferParsingTime = 0L;
        this.averageOfferProcessingTime = 0L;
        for (URI serviceOffer : tc.getServiceOffersSorted()) {
            logger.info((Object)(String.valueOf(serviceOffer.toString()) + " registering as offer (" + ++i + " of " + this.config.getTestCollection().getNumberOfServiceOffers() + ") at " + matchmakerName + "..."));
            this.registerServiceOffer(serviceOffer, plugin, matchmakerName, version);
        }
        if (this.config.isCheckOPT()) {
            evalResult.setAverageOffersParsingTime((double)this.averageOfferParsingTime / (double)i);
        }
        evalResult.setAverageOffersProcessingTime((double)this.averageOfferProcessingTime / (double)i);
    }

    protected void registerServiceOffer(URI serviceOffer, IMatchmakerPlugin plugin, String matchmakerName, String version) {
        try {
            Date queryStart = null;
            if (version.equals("1.0")) {
                if (this.config.isCheckOPT()) {
                    queryStart = new Date();
                }
                plugin.input(serviceOffer.toURL());
                if (this.config.isCheckOPT()) {
                    this.averageOfferProcessingTime += new Date().getTime() - queryStart.getTime();
                }
            } else if (version.equals("2.0")) {
                if (this.config.isCheckOPT()) {
                    queryStart = new Date();
                }
                plugin.parseOffer(serviceOffer);
                if (this.config.isCheckOPT()) {
                    this.averageOfferParsingTime += new Date().getTime() - queryStart.getTime();
                }
                if (this.config.isCheckOPT()) {
                    queryStart = new Date();
                }
                plugin.processOffer(serviceOffer);
                if (this.config.isCheckOPT()) {
                    this.averageOfferProcessingTime += new Date().getTime() - queryStart.getTime();
                }
            } else {
                logger.warn((Object)"Wrong version number.");
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to register " + serviceOffer + " at " + matchmakerName + "."), (Throwable)e);
        }
    }

    protected void sendRequestsToMatchmaker(IMatchmakerPlugin plugin, String matchmakerName, MatchmakerEvaluationResult evalResult, String version) {
        TestCollection tc = this.config.getTestCollection();
        this.duplicatesDetected = false;
        for (URI query : tc.getQueries()) {
            try {
                logger.info((Object)("Queried " + matchmakerName + " for " + query.toString() + "."));
                this.queryMatchmaker(query, plugin, matchmakerName, evalResult, version);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to query " + matchmakerName + " for " + query + "."), (Throwable)e);
            }
        }
    }

    protected void queryMatchmaker(URI query, IMatchmakerPlugin plugin, String matchmakerName, MatchmakerEvaluationResult evalResult, String version) {
        try {
            Date queryStart = null;
            if (this.http != null) {
                this.http.resetStats();
            }
            if (version.equals("1.0")) {
                if (this.config.isCheckQRT()) {
                    queryStart = new Date();
                }
                Hashtable<URL, Vector<URL>> resultTmp = plugin.query(query.toURL());
                if (this.config.isCheckQRT()) {
                    long qrt = new Date().getTime() - queryStart.getTime();
                    evalResult.addQueryResponseTime(query, qrt);
                }
                if (this.http != null) {
                    evalResult.addHttpAccessTime(query, this.http.getRequestTimeStat());
                    evalResult.addHttpRequests(query, this.http.getRequestsStat());
                }
                Vector<URI> resultsVectorURI = new Vector<URI>();
                for (URL resultURL : resultTmp.get(query.toURL())) {
                    resultsVectorURI.add(resultURL.toURI());
                }
                Vector<URI> noDuplicatesVector = new Vector<URI>(new LinkedHashSet(resultsVectorURI));
                if (!noDuplicatesVector.equals(resultsVectorURI)) {
                    this.duplicatesDetected = true;
                }
                evalResult.addRanking(query, noDuplicatesVector);
            } else if (version.equals("2.0")) {
                Vector<URI> noDuplicatesVector;
                long qpt;
                long qrt = 0L;
                if (this.config.isCheckQRT()) {
                    queryStart = new Date();
                }
                plugin.parseQuery(query);
                if (this.config.isCheckOPT()) {
                    qpt = new Date().getTime() - queryStart.getTime();
                    evalResult.addQueryParsingTime(query, qpt);
                    qrt += qpt;
                }
                if (this.config.isCheckOPT()) {
                    queryStart = new Date();
                }
                plugin.processQuery(query);
                if (this.config.isCheckOPT()) {
                    qpt = new Date().getTime() - queryStart.getTime();
                    evalResult.addQueryProcessingTime(query, qpt);
                    qrt += qpt;
                }
                if (this.config.isCheckOPT()) {
                    queryStart = new Date();
                }
                Vector<URI> resultTmp = plugin.match(query);
                if (this.config.isCheckQRT()) {
                    long qmt = new Date().getTime() - queryStart.getTime();
                    evalResult.addQueryMatchingTime(query, qmt);
                    evalResult.addQueryResponseTime(query, qrt + qmt);
                }
                if (this.http != null) {
                    evalResult.addHttpAccessTime(query, this.http.getRequestTimeStat());
                    evalResult.addHttpRequests(query, this.http.getRequestsStat());
                }
                if (!(noDuplicatesVector = new Vector<URI>(new LinkedHashSet<URI>(resultTmp))).equals(resultTmp)) {
                    this.duplicatesDetected = true;
                }
                evalResult.addRanking(query, noDuplicatesVector);
            } else {
                logger.warn((Object)"Wrong version number.");
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to query " + matchmakerName + " for " + query + "."), (Throwable)e);
            evalResult.addRanking(query, new Vector<URI>());
        }
    }
}

