/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.util.metric.RecallFalloutPair;
import de.dfki.sme2.util.metric.RecallPrecisionPair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MatchmakerEvaluationResult {
    private static Logger logger = Logger.getLogger(MatchmakerEvaluationResult.class);
    private long totalExecutionTime = -1L;
    private HashMap<URI, Vector<URI>> rankings = new HashMap();
    private ArrayList<RecallPrecisionPair> macroAvgRP = null;
    private ArrayList<RecallPrecisionPair> microAvgRP = null;
    private ArrayList<Double> macroAvgF1 = null;
    private ArrayList<Double> microAvgF1 = null;
    private ArrayList<RecallFalloutPair> macroAvgRF = null;
    private ArrayList<RecallFalloutPair> microAvgRF = null;
    private double averageOffersParsingTime;
    private double averageOffersProcessingTime;
    private HashMap<URI, Long> queryResponseTimes = null;
    private HashMap<URI, Long> queryParsingTimes = null;
    private HashMap<URI, Long> queryProcessingTimes = null;
    private HashMap<URI, Long> queryMatchingTimes = null;
    private ArrayList<Long> memoryConsumption = null;
    private HashMap<URI, Double> APs = null;
    private HashMap<URI, Double> APPrimes = null;
    private HashMap<URI, Double> nDCGs = null;
    private HashMap<URI, Double> nDCGPrimes = null;
    private HashMap<URI, Double> Qs = null;
    private HashMap<URI, Double> QPrimes = null;
    private HashMap<URI, Long> httpAccessTimes = null;
    private HashMap<URI, Integer> httpRequests = null;
    private String matchmakerName;
    private String tcName;

    public MatchmakerEvaluationResult(String matchmakerName, String tcName) {
        this.matchmakerName = matchmakerName;
        this.tcName = tcName;
    }

    protected MatchmakerEvaluationResult() {
    }

    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    public void setTotalExecutionTime(long totalExecutionTime) {
        this.totalExecutionTime = totalExecutionTime;
    }

    public void setAverageOffersParsingTime(double parsingTime) {
        this.averageOffersParsingTime = parsingTime;
    }

    public void setAverageOffersProcessingTime(double processingTime) {
        this.averageOffersProcessingTime = processingTime;
    }

    public double getAverageOffersParsingTime() {
        return this.averageOffersParsingTime;
    }

    public double getAverageOffersProcessingTime() {
        return this.averageOffersProcessingTime;
    }

    public void addRanking(URI query, Vector<URI> ranking) {
        Vector<URI> newRanking = new Vector<URI>();
        for (URI entry : ranking) {
            try {
                newRanking.add(new URI(entry.toString().replaceAll(" ", "%20")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rankings.put(query, newRanking);
    }

    public HashMap<URI, Vector<URI>> getRankings() {
        return this.rankings;
    }

    public Vector<URI> getRanking(URI query) {
        return this.rankings.get(query);
    }

    public void addQueryResponseTime(URI query, Long qrt) {
        if (this.queryResponseTimes == null) {
            this.queryResponseTimes = new HashMap();
        }
        this.queryResponseTimes.put(query, qrt);
    }

    public void addQueryParsingTime(URI query, Long qpt) {
        if (this.queryParsingTimes == null) {
            this.queryParsingTimes = new HashMap();
        }
        this.queryParsingTimes.put(query, qpt);
    }

    public void addQueryProcessingTime(URI query, Long qpt) {
        if (this.queryProcessingTimes == null) {
            this.queryProcessingTimes = new HashMap();
        }
        this.queryProcessingTimes.put(query, qpt);
    }

    public void addQueryMatchingTime(URI query, Long qmt) {
        if (this.queryMatchingTimes == null) {
            this.queryMatchingTimes = new HashMap();
        }
        this.queryMatchingTimes.put(query, qmt);
    }

    public ArrayList<RecallPrecisionPair> getMacroAvgRP() {
        return this.macroAvgRP;
    }

    public void setMacroAvgRP(ArrayList<RecallPrecisionPair> macroAvgRP) {
        this.macroAvgRP = macroAvgRP;
    }

    public void setMacroAvgF1(ArrayList<RecallPrecisionPair> macroAvgRP) {
        this.macroAvgF1 = new ArrayList();
        for (RecallPrecisionPair rp : macroAvgRP) {
            double f1 = 2.0 * rp.precision * rp.recall / (rp.precision + rp.recall);
            this.macroAvgF1.add(new Double(f1));
        }
    }

    public void setMicroAvgF1(ArrayList<RecallPrecisionPair> microAvgRP) {
        this.microAvgF1 = new ArrayList();
        for (RecallPrecisionPair rp : microAvgRP) {
            double f1 = 2.0 * rp.precision * rp.recall / (rp.precision + rp.recall);
            this.microAvgF1.add(new Double(f1));
        }
    }

    public String getMatchmakerName() {
        return this.matchmakerName;
    }

    public void setMatchmakerName(String matchmakerName) {
        this.matchmakerName = matchmakerName;
    }

    public void save(String fileName) {
        try {
            Element apElem;
            Double AP;
            Element averagedPrecisionsElem;
            Element qhttp;
            Element qpt;
            Element timeElem;
            Long time;
            Element aopt;
            Document xml = null;
            Element eval = null;
            File file = new File(fileName);
            if (!file.exists()) {
                xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                eval = xml.createElement("evaluation");
                xml.appendChild(eval);
            } else {
                try {
                    xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                    eval = xml.getDocumentElement();
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
                    return;
                }
                catch (SAXException e) {
                    logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
                    return;
                }
            }
            Element result = xml.createElement("result");
            result.setAttribute("matchmaker", this.matchmakerName);
            Element environment = xml.createElement("environment");
            Element timeStamp = xml.createElement("timestamp");
            timeStamp.setTextContent(new Long(new Date().getTime()).toString());
            environment.appendChild(timeStamp);
            Element testCollection = xml.createElement("testcollection");
            testCollection.setTextContent(this.tcName);
            environment.appendChild(testCollection);
            Element java = xml.createElement("java");
            java.setTextContent(System.getProperty("java.version"));
            environment.appendChild(java);
            Element system = xml.createElement("system");
            system.setTextContent(System.getProperty("os.name"));
            system.setAttribute("version", System.getProperty("os.version"));
            system.setAttribute("architecture", System.getProperty("os.arch"));
            environment.appendChild(system);
            result.appendChild(environment);
            Element rankings = xml.createElement("rankings");
            for (URI query : this.rankings.keySet()) {
                Vector<URI> rankedResult = this.rankings.get(query);
                Element ranking = xml.createElement("ranking");
                ranking.setAttribute("query", query.toString());
                int rankId = 1;
                for (URI offer : rankedResult) {
                    Element rank = xml.createElement("rank");
                    rank.setTextContent(offer.toString());
                    rank.setAttribute("id", new Integer(rankId++).toString());
                    ranking.appendChild(rank);
                }
                rankings.appendChild(ranking);
            }
            result.appendChild(rankings);
            if (this.totalExecutionTime > -1L) {
                Element execTime = xml.createElement("executiontime");
                execTime.setTextContent(new Long(this.totalExecutionTime).toString());
                result.appendChild(execTime);
            }
            if (this.averageOffersParsingTime > -1.0) {
                aopt = xml.createElement("averageoffersparsingtime");
                aopt.setTextContent(new Double(this.averageOffersParsingTime).toString());
                result.appendChild(aopt);
            }
            if (this.averageOffersProcessingTime > -1.0) {
                aopt = xml.createElement("averageoffersprocessingtime");
                aopt.setTextContent(new Double(this.averageOffersProcessingTime).toString());
                result.appendChild(aopt);
            }
            Element macroAvg = xml.createElement("macroaveraged");
            if (this.macroAvgRP != null) {
                Element rp = xml.createElement("recallprecision");
                this.appendRecallPrecisionValues(xml, rp, this.macroAvgRP);
                macroAvg.appendChild(rp);
            }
            if (this.macroAvgF1 != null) {
                Element f1 = xml.createElement("f1values");
                this.appendF1Values(xml, f1, this.macroAvgF1);
                macroAvg.appendChild(f1);
            }
            if (this.macroAvgRF != null) {
                Element rf = xml.createElement("recallfallout");
                this.appendRecallFalloutValues(xml, rf, this.macroAvgRF);
                macroAvg.appendChild(rf);
            }
            result.appendChild(macroAvg);
            Element microAvg = xml.createElement("microaveraged");
            if (this.microAvgRP != null) {
                Element rp = xml.createElement("recallprecision");
                this.appendRecallPrecisionValues(xml, rp, this.microAvgRP);
                microAvg.appendChild(rp);
            }
            if (this.microAvgF1 != null) {
                Element f1 = xml.createElement("f1values");
                this.appendF1Values(xml, f1, this.microAvgF1);
                microAvg.appendChild(f1);
            }
            if (this.microAvgRF != null) {
                Element rf = xml.createElement("recallfallout");
                this.appendRecallFalloutValues(xml, rf, this.microAvgRF);
                microAvg.appendChild(rf);
            }
            result.appendChild(microAvg);
            if (this.queryResponseTimes != null) {
                Element qrt = xml.createElement("queryresponsetime");
                for (URI query : this.queryResponseTimes.keySet()) {
                    time = this.queryResponseTimes.get(query);
                    timeElem = xml.createElement("time");
                    timeElem.setAttribute("query", query.toString());
                    timeElem.setTextContent(time.toString());
                    qrt.appendChild(timeElem);
                }
                result.appendChild(qrt);
            }
            if (this.queryParsingTimes != null) {
                qpt = xml.createElement("queryparsingtime");
                for (URI query : this.queryParsingTimes.keySet()) {
                    time = this.queryParsingTimes.get(query);
                    timeElem = xml.createElement("time");
                    timeElem.setAttribute("query", query.toString());
                    timeElem.setTextContent(time.toString());
                    qpt.appendChild(timeElem);
                }
                result.appendChild(qpt);
            }
            if (this.queryProcessingTimes != null) {
                qpt = xml.createElement("queryprocessingtime");
                for (URI query : this.queryProcessingTimes.keySet()) {
                    time = this.queryProcessingTimes.get(query);
                    timeElem = xml.createElement("time");
                    timeElem.setAttribute("query", query.toString());
                    timeElem.setTextContent(time.toString());
                    qpt.appendChild(timeElem);
                }
                result.appendChild(qpt);
            }
            if (this.queryMatchingTimes != null) {
                Element qmt = xml.createElement("querymatchingtime");
                for (URI query : this.queryMatchingTimes.keySet()) {
                    time = this.queryMatchingTimes.get(query);
                    timeElem = xml.createElement("time");
                    timeElem.setAttribute("query", query.toString());
                    timeElem.setTextContent(time.toString());
                    qmt.appendChild(timeElem);
                }
                result.appendChild(qmt);
            }
            if (this.httpAccessTimes != null) {
                qhttp = xml.createElement("queryhttpaccesstime");
                for (URI query : this.httpAccessTimes.keySet()) {
                    time = this.httpAccessTimes.get(query);
                    timeElem = xml.createElement("time");
                    timeElem.setAttribute("query", query.toString());
                    timeElem.setTextContent(time.toString());
                    qhttp.appendChild(timeElem);
                }
                result.appendChild(qhttp);
            }
            if (this.httpRequests != null) {
                qhttp = xml.createElement("queryhttprequests");
                for (URI query : this.httpRequests.keySet()) {
                    Integer num = this.httpRequests.get(query);
                    Element elem = xml.createElement("quantity");
                    elem.setAttribute("query", query.toString());
                    elem.setTextContent(num.toString());
                    qhttp.appendChild(elem);
                }
                result.appendChild(qhttp);
            }
            if (this.APs != null) {
                averagedPrecisionsElem = xml.createElement("averagedprecisions");
                for (URI query : this.APs.keySet()) {
                    AP = this.APs.get(query);
                    apElem = xml.createElement("averagedprecision");
                    apElem.setAttribute("query", query.toString());
                    apElem.setTextContent(AP.toString());
                    averagedPrecisionsElem.appendChild(apElem);
                }
                result.appendChild(averagedPrecisionsElem);
            }
            if (this.APPrimes != null) {
                averagedPrecisionsElem = xml.createElement("averagedprecisionprimes");
                for (URI query : this.APPrimes.keySet()) {
                    AP = this.APPrimes.get(query);
                    apElem = xml.createElement("averagedprecisionprime");
                    apElem.setAttribute("query", query.toString());
                    apElem.setTextContent(AP.toString());
                    averagedPrecisionsElem.appendChild(apElem);
                }
                result.appendChild(averagedPrecisionsElem);
            }
            if (this.Qs != null) {
                Element qsElem = xml.createElement("qs");
                for (URI query : this.Qs.keySet()) {
                    Double Q = this.Qs.get(query);
                    Element qElem = xml.createElement("q");
                    qElem.setAttribute("query", query.toString());
                    qElem.setTextContent(Q.toString());
                    qsElem.appendChild(qElem);
                }
                result.appendChild(qsElem);
            }
            if (this.QPrimes != null) {
                Element qPrimesElem = xml.createElement("qprimes");
                for (URI query : this.QPrimes.keySet()) {
                    Double QPrime = this.QPrimes.get(query);
                    Element qprimeElem = xml.createElement("qprime");
                    qprimeElem.setAttribute("query", query.toString());
                    qprimeElem.setTextContent(QPrime.toString());
                    qPrimesElem.appendChild(qprimeElem);
                }
                result.appendChild(qPrimesElem);
            }
            if (this.nDCGs != null) {
                Element ndcgsElem = xml.createElement("ndcgs");
                for (URI query : this.nDCGs.keySet()) {
                    Double ndcg = this.nDCGs.get(query);
                    Element ndcgElem = xml.createElement("ndcg");
                    ndcgElem.setAttribute("query", query.toString());
                    ndcgElem.setTextContent(ndcg.toString());
                    ndcgsElem.appendChild(ndcgElem);
                }
                result.appendChild(ndcgsElem);
            }
            if (this.nDCGPrimes != null) {
                Element ndcgPrimesElem = xml.createElement("ndcgprimes");
                for (URI query : this.nDCGPrimes.keySet()) {
                    Double ndcgPrime = this.nDCGPrimes.get(query);
                    Element ndcgprimeElem = xml.createElement("ndcgprime");
                    ndcgprimeElem.setAttribute("query", query.toString());
                    ndcgprimeElem.setTextContent(ndcgPrime.toString());
                    ndcgPrimesElem.appendChild(ndcgprimeElem);
                }
                result.appendChild(ndcgPrimesElem);
            }
            if (this.memoryConsumption != null) {
                Element memElem = xml.createElement("memoryusage");
                for (Long value : this.memoryConsumption) {
                    Element entry = xml.createElement("sample");
                    entry.setTextContent(value.toString());
                    memElem.appendChild(entry);
                }
                result.appendChild(memElem);
            }
            eval.appendChild(result);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(new File(fileName));
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException e) {
                logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
            }
            catch (TransformerException e) {
                logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
        }
    }

    private void load(Element result) {
        this.matchmakerName = result.getAttribute("matchmaker");
        NodeList subNodes = result.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("environment")) {
                    this.loadEnvironment(node);
                } else if (node.getNodeName().equals("rankings")) {
                    this.loadRankings(node);
                } else if (node.getNodeName().equals("executiontime")) {
                    this.totalExecutionTime = new Long(node.getTextContent());
                } else if (node.getNodeName().equals("averageoffersparsingtime")) {
                    this.averageOffersParsingTime = new Double(node.getTextContent());
                } else if (node.getNodeName().equals("averageoffersprocessingtime")) {
                    this.averageOffersProcessingTime = new Double(node.getTextContent());
                } else if (node.getNodeName().equals("macroaveraged")) {
                    this.loadMacroResults(node);
                } else if (node.getNodeName().equals("microaveraged")) {
                    this.loadMicroResults(node);
                } else if (node.getNodeName().equals("queryresponsetime")) {
                    this.loadQueryResponseTimes(node);
                } else if (node.getNodeName().equals("queryhttpaccesstime")) {
                    this.loadQueryHttpAccessTimes(node);
                } else if (node.getNodeName().equals("queryhttprequests")) {
                    this.loadQueryHttpRequests(node);
                } else if (node.getNodeName().equals("queryparsingtime")) {
                    this.loadQueryParsingTimes(node);
                } else if (node.getNodeName().equals("queryprocessingtime")) {
                    this.loadQueryProcessingTimes(node);
                } else if (node.getNodeName().equals("querymatchingtime")) {
                    this.loadQueryMatchingTimes(node);
                } else if (node.getNodeName().equals("averagedprecisions")) {
                    this.loadAveragedPrecisions(node);
                } else if (node.getNodeName().equals("averagedprecisionprimes")) {
                    this.loadAveragedPrecisionPrimes(node);
                } else if (node.getNodeName().equals("qs")) {
                    this.loadQs(node);
                } else if (node.getNodeName().equals("qprimes")) {
                    this.loadQPrimes(node);
                } else if (node.getNodeName().equals("ndcgs")) {
                    this.loadNDCGs(node);
                } else if (node.getNodeName().equals("ndcgprimes")) {
                    this.loadNDCGPrimes(node);
                } else if (node.getNodeName().equals("memoryusage")) {
                    this.loadMemoryUsage(node);
                }
            }
            ++i;
        }
    }

    private void loadQueryResponseTimes(Node qrtNode) {
        try {
            this.queryResponseTimes = new HashMap();
            NodeList subNodes = qrtNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("time")) {
                    this.queryResponseTimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Long(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load query response times because of a malformed URI.", (Throwable)e);
            this.queryResponseTimes = null;
        }
    }

    private void loadQueryHttpAccessTimes(Node qhttpNode) {
        try {
            this.httpAccessTimes = new HashMap();
            NodeList subNodes = qhttpNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("time")) {
                    this.httpAccessTimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Long(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load query HTTP access times because of a malformed URI.", (Throwable)e);
            this.httpAccessTimes = null;
        }
    }

    private void loadQueryHttpRequests(Node qhttpNode) {
        try {
            this.httpRequests = new HashMap();
            NodeList subNodes = qhttpNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("quantity")) {
                    this.httpRequests.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Integer(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load number of query HTTP requests because of a malformed URI.", (Throwable)e);
            this.httpRequests = null;
        }
    }

    private void loadQueryParsingTimes(Node qrtNode) {
        try {
            this.queryParsingTimes = new HashMap();
            NodeList subNodes = qrtNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("time")) {
                    this.queryParsingTimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Long(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load query parsing times because of a malformed URI.", (Throwable)e);
            this.queryParsingTimes = null;
        }
    }

    private void loadQueryProcessingTimes(Node qrtNode) {
        try {
            this.queryProcessingTimes = new HashMap();
            NodeList subNodes = qrtNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("time")) {
                    this.queryProcessingTimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Long(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load query processing times because of a malformed URI.", (Throwable)e);
            this.queryProcessingTimes = null;
        }
    }

    private void loadQueryMatchingTimes(Node qrtNode) {
        try {
            this.queryMatchingTimes = new HashMap();
            NodeList subNodes = qrtNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("time")) {
                    this.queryMatchingTimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Long(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load query matching times because of a malformed URI.", (Throwable)e);
            this.queryMatchingTimes = null;
        }
    }

    private void loadAveragedPrecisions(Node APNode) {
        try {
            this.APs = new HashMap();
            NodeList subNodes = APNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("averagedprecision")) {
                    this.APs.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load APs because of a malformed URI.", (Throwable)e);
            this.APs = null;
        }
    }

    private void loadAveragedPrecisionPrimes(Node APPNode) {
        try {
            this.APPrimes = new HashMap();
            NodeList subNodes = APPNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("averagedprecisionprime")) {
                    this.APPrimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load AP's because of a malformed URI.", (Throwable)e);
            this.APPrimes = null;
        }
    }

    private void loadQs(Node QNode) {
        try {
            this.Qs = new HashMap();
            NodeList subNodes = QNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("q")) {
                    this.Qs.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load Q values because of a malformed URI.", (Throwable)e);
            this.Qs = null;
        }
    }

    private void loadQPrimes(Node QPNode) {
        try {
            this.QPrimes = new HashMap();
            NodeList subNodes = QPNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("qprime")) {
                    this.QPrimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load Q' values because of a malformed URI.", (Throwable)e);
            this.QPrimes = null;
        }
    }

    private void loadNDCGs(Node nDCGNode) {
        try {
            this.nDCGs = new HashMap();
            NodeList subNodes = nDCGNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("ndcg")) {
                    this.nDCGs.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load nDCG values because of a malformed URI.", (Throwable)e);
            this.nDCGs = null;
        }
    }

    private void loadNDCGPrimes(Node nDCGPNode) {
        try {
            this.nDCGPrimes = new HashMap();
            NodeList subNodes = nDCGPNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("ndcgprime")) {
                    this.nDCGPrimes.put(new URI(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to load nDCG' values because of a malformed URI.", (Throwable)e);
            this.QPrimes = null;
        }
    }

    private void loadMemoryUsage(Node node) {
        this.memoryConsumption = new ArrayList();
        NodeList subNodes = node.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node current = subNodes.item(i);
            if (current.getNodeName().equals("sample")) {
                this.memoryConsumption.add(new Long(current.getTextContent()));
            }
            ++i;
        }
    }

    private void loadEnvironment(Node environmentNode) {
        NodeList subNodes = environmentNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("testcollection")) {
                this.tcName = node.getTextContent();
            } else if (node.getNodeName().equals("testcollection")) {
                this.tcName = node.getTextContent();
            }
            ++i;
        }
    }

    private void loadRankings(Node rankingsNode) {
        NodeList subNodes = rankingsNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("ranking")) {
                this.loadRanking(node);
            }
            ++i;
        }
    }

    private void loadRanking(Node rankingNode) {
        try {
            NodeList subNodes = rankingNode.getChildNodes();
            URI query = new URI(rankingNode.getAttributes().getNamedItem("query").getNodeValue());
            Vector<URI> ranking = new Vector<URI>();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeName().equals("rank")) {
                    ranking.add(new Integer(node.getAttributes().getNamedItem("id").getNodeValue()) - 1, new URI(node.getTextContent()));
                }
                ++i;
            }
            this.rankings.put(query, ranking);
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Unable to parse ranking because of malformed URI.", (Throwable)e);
        }
    }

    private void loadMacroResults(Node macroNode) {
        NodeList subNodes = macroNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("recallprecision")) {
                this.macroAvgRP = this.parseRP(node);
            } else if (node.getNodeName().equals("recallfallout")) {
                this.macroAvgRF = this.parseRF(node);
            } else if (node.getNodeName().equals("f1values")) {
                this.macroAvgF1 = this.parseF1(node);
            }
            ++i;
        }
    }

    private void loadMicroResults(Node microNode) {
        NodeList subNodes = microNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("recallprecision")) {
                this.microAvgRP = this.parseRP(node);
            } else if (node.getNodeName().equals("recallfallout")) {
                this.microAvgRF = this.parseRF(node);
            } else if (node.getNodeName().equals("f1values")) {
                this.microAvgF1 = this.parseF1(node);
            }
            ++i;
        }
    }

    private ArrayList<RecallPrecisionPair> parseRP(Node rpNode) {
        NodeList subNodes = rpNode.getChildNodes();
        ArrayList<RecallPrecisionPair> rps = new ArrayList<RecallPrecisionPair>(subNodes.getLength());
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("precision")) {
                RecallPrecisionPair rp = new RecallPrecisionPair(new Double(node.getAttributes().getNamedItem("recall").getNodeValue()), new Double(node.getTextContent()));
                rps.add(rp);
            }
            ++i;
        }
        Collections.sort(rps);
        return rps;
    }

    private ArrayList<RecallFalloutPair> parseRF(Node rfNode) {
        NodeList subNodes = rfNode.getChildNodes();
        ArrayList<RecallFalloutPair> rfs = new ArrayList<RecallFalloutPair>(subNodes.getLength());
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("fallout")) {
                RecallFalloutPair rf = new RecallFalloutPair(new Double(node.getAttributes().getNamedItem("recall").getNodeValue()), new Double(node.getTextContent()));
                rfs.add(rf);
            }
            ++i;
        }
        Collections.sort(rfs);
        return rfs;
    }

    private ArrayList<Double> parseF1(Node f1Node) {
        NodeList subNodes = f1Node.getChildNodes();
        ArrayList<Double> f1s = new ArrayList<Double>(subNodes.getLength());
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("f1")) {
                f1s.add(new Integer(node.getAttributes().getNamedItem("step").getNodeValue()) - 1, new Double(node.getTextContent()));
            }
            ++i;
        }
        return f1s;
    }

    public static MatchmakerEvaluationResult[] load(String fileName) {
        try {
            Vector<MatchmakerEvaluationResult> results = new Vector<MatchmakerEvaluationResult>();
            File file = new File(fileName);
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            Element docRoot = xml.getDocumentElement();
            NodeList subNodes = docRoot.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals("result")) {
                    MatchmakerEvaluationResult result = new MatchmakerEvaluationResult();
                    result.load((Element)node);
                    results.add(result);
                }
                ++i;
            }
            return results.toArray(new MatchmakerEvaluationResult[0]);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Unable to load evaluation results from " + fileName + "."), (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            logger.error((Object)("Unable to load evaluation results from " + fileName + "."), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)("Unable to load evaluation results from " + fileName + "."), (Throwable)e);
            return null;
        }
    }

    private void appendRecallPrecisionValues(Document xmlDoc, Element elem, ArrayList<RecallPrecisionPair> rpPairs) {
        for (RecallPrecisionPair rpPair : rpPairs) {
            Element pairElem = xmlDoc.createElement("precision");
            pairElem.setTextContent(new Double(rpPair.precision).toString());
            pairElem.setAttribute("recall", new Double(rpPair.recall).toString());
            elem.appendChild(pairElem);
        }
    }

    private void appendF1Values(Document xmlDoc, Element elem, ArrayList<Double> f1Values) {
        int i = 1;
        for (Double f1 : f1Values) {
            Element f1Elem = xmlDoc.createElement("f1");
            f1Elem.setTextContent(f1.toString());
            f1Elem.setAttribute("step", new Integer(i++).toString());
            elem.appendChild(f1Elem);
        }
    }

    private void appendRecallFalloutValues(Document xmlDoc, Element elem, ArrayList<RecallFalloutPair> rfPairs) {
        for (RecallFalloutPair rfPair : rfPairs) {
            Element pairElem = xmlDoc.createElement("fallout");
            pairElem.setTextContent(new Double(rfPair.fallout).toString());
            pairElem.setAttribute("recall", new Double(rfPair.recall).toString());
            elem.appendChild(pairElem);
        }
    }

    public ArrayList<RecallPrecisionPair> getMicroAvgRP() {
        return this.microAvgRP;
    }

    public void setMicroAvgRP(ArrayList<RecallPrecisionPair> microAvgRP) {
        this.microAvgRP = microAvgRP;
    }

    public ArrayList<Double> getMacroAvgF1() {
        return this.macroAvgF1;
    }

    public ArrayList<Double> getMicroAvgF1() {
        return this.microAvgF1;
    }

    public ArrayList<RecallFalloutPair> getMacroAvgRF() {
        return this.macroAvgRF;
    }

    public void setMacroAvgRF(ArrayList<RecallFalloutPair> macroAvgRF) {
        this.macroAvgRF = macroAvgRF;
    }

    public ArrayList<RecallFalloutPair> getMicroAvgRF() {
        return this.microAvgRF;
    }

    public void setMicroAvgRF(ArrayList<RecallFalloutPair> microAvgRF) {
        this.microAvgRF = microAvgRF;
    }

    public HashMap<URI, Long> getQueryResponseTimes() {
        return this.queryResponseTimes;
    }

    public HashMap<URI, Long> getQueryParsingTimes() {
        return this.queryParsingTimes;
    }

    public HashMap<URI, Long> getQueryProcessingTimes() {
        return this.queryProcessingTimes;
    }

    public HashMap<URI, Long> getQueryMatchingTimes() {
        return this.queryMatchingTimes;
    }

    public void setQueryParsingTimes(HashMap<URI, Long> queryParsingTimes) {
        this.queryParsingTimes = queryParsingTimes;
    }

    public long getAverageQueryParsingTime() {
        if (this.queryParsingTimes == null) {
            return -1L;
        }
        long avgQrt = 0L;
        for (Long qrt : this.queryParsingTimes.values()) {
            avgQrt += qrt.longValue();
        }
        return avgQrt /= (long)this.queryParsingTimes.size();
    }

    public void setQueryProcessingTimes(HashMap<URI, Long> queryProcessingTimes) {
        this.queryProcessingTimes = queryProcessingTimes;
    }

    public long getAverageQueryProcessingTime() {
        if (this.queryProcessingTimes == null) {
            return -1L;
        }
        long avgQrt = 0L;
        for (Long qrt : this.queryProcessingTimes.values()) {
            avgQrt += qrt.longValue();
        }
        return avgQrt /= (long)this.queryProcessingTimes.size();
    }

    public void setQueryMatchingTimes(HashMap<URI, Long> queryMatchingTimes) {
        this.queryMatchingTimes = queryMatchingTimes;
    }

    public long getAverageQueryMatchingTime() {
        if (this.queryMatchingTimes == null) {
            return -1L;
        }
        long avgQrt = 0L;
        for (Long qrt : this.queryMatchingTimes.values()) {
            avgQrt += qrt.longValue();
        }
        return avgQrt /= (long)this.queryMatchingTimes.size();
    }

    public void setQueryResponseTimes(HashMap<URI, Long> queryResponseTimes) {
        this.queryResponseTimes = queryResponseTimes;
    }

    public long getAverageQueryResponseTime() {
        if (this.queryResponseTimes == null) {
            return -1L;
        }
        long avgQrt = 0L;
        for (Long qrt : this.queryResponseTimes.values()) {
            avgQrt += qrt.longValue();
        }
        return avgQrt /= (long)this.queryResponseTimes.size();
    }

    public String getTcName() {
        return this.tcName;
    }

    public HashMap<URI, Double> getAPs() {
        return this.APs;
    }

    public void addAP(URI query, Double AP) {
        if (this.APs == null) {
            this.APs = new HashMap();
        }
        this.APs.put(query, AP);
    }

    public void addAPPrime(URI query, Double AP) {
        if (this.APPrimes == null) {
            this.APPrimes = new HashMap();
        }
        this.APPrimes.put(query, AP);
    }

    public void addNDCG(URI query, Double nDCG) {
        if (this.nDCGs == null) {
            this.nDCGs = new HashMap();
        }
        this.nDCGs.put(query, nDCG);
    }

    public void addNDCGPrime(URI query, Double nDCG) {
        if (this.nDCGPrimes == null) {
            this.nDCGPrimes = new HashMap();
        }
        this.nDCGPrimes.put(query, nDCG);
    }

    public HashMap<URI, Double> getQPrimes() {
        return this.QPrimes;
    }

    public void addQPrime(URI query, Double QPrime) {
        if (this.QPrimes == null) {
            this.QPrimes = new HashMap();
        }
        this.QPrimes.put(query, QPrime);
    }

    public void addQ(URI query, Double q) {
        if (this.Qs == null) {
            this.Qs = new HashMap();
        }
        this.Qs.put(query, q);
    }

    public ArrayList<Long> getMemoryConsumption() {
        return this.memoryConsumption;
    }

    public void setMemoryConsumption(ArrayList<Long> memoryConsumption) {
        this.memoryConsumption = memoryConsumption;
    }

    public String toString() {
        return this.matchmakerName;
    }

    public HashMap<URI, Double> getAPPrimes() {
        return this.APPrimes;
    }

    public HashMap<URI, Double> getNDCGPrimes() {
        return this.nDCGPrimes;
    }

    public HashMap<URI, Double> getNDCGs() {
        return this.nDCGs;
    }

    public HashMap<URI, Double> getQs() {
        return this.Qs;
    }

    public HashMap<URI, Long> getHttpAccessTimes() {
        return this.httpAccessTimes;
    }

    public long getAverageHttpAccessTimes() {
        if (this.httpAccessTimes == null) {
            return -1L;
        }
        long avg = 0L;
        for (Long time : this.httpAccessTimes.values()) {
            avg += time.longValue();
        }
        return avg /= (long)this.httpAccessTimes.size();
    }

    public void addHttpAccessTime(URI query, Long time) {
        if (this.httpAccessTimes == null) {
            this.httpAccessTimes = new HashMap();
        }
        this.httpAccessTimes.put(query, time);
    }

    public HashMap<URI, Integer> getHttpRequests() {
        return this.httpRequests;
    }

    public void addHttpRequests(URI query, Integer number) {
        if (this.httpRequests == null) {
            this.httpRequests = new HashMap();
        }
        this.httpRequests.put(query, number);
    }
}

