/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class PdfReport {
    private final MatchmakerEvaluationResult[] results;
    private Vector<Chart> charts;

    public PdfReport(MatchmakerEvaluationResult[] results, Vector<Chart> charts) {
        this.results = results;
        this.charts = charts;
    }

    public void write(String fileName) {
        Document pdfDoc = new Document();
        try {
            Paragraph space;
            PdfWriter writer = PdfWriter.getInstance((Document)pdfDoc, (OutputStream)new FileOutputStream(fileName));
            pdfDoc.addTitle("SME^2 Report Sheet");
            pdfDoc.addSubject("Semantic Matchmaker Benchmark Results");
            pdfDoc.addCreator("SME^2");
            HeaderFooter hf = new HeaderFooter(new Phrase(""), true);
            hf.setBorderWidth(0.0f);
            hf.setAlignment(1);
            pdfDoc.setFooter(hf);
            pdfDoc.open();
            Paragraph p1 = new Paragraph(new Chunk("Semantic Web Service Matchmaker Evaluation Environment\n\n", FontFactory.getFont((String)"Helvetica", (float)18.0f)));
            p1.setAlignment(1);
            pdfDoc.add((Element)p1);
            Paragraph p2 = new Paragraph(new Chunk("Experimental Results Report\n\n", FontFactory.getFont((String)"Helvetica", (float)18.0f)));
            p2.setAlignment(1);
            pdfDoc.add((Element)p2);
            Chunk c = new Chunk("                                                                                                          ");
            c.setUnderline(new Color(0, 0, 0), 0.0f, 0.3f, 0.0f, 0.4f, 0);
            Paragraph pLine = new Paragraph(c);
            pLine.setAlignment(1);
            pdfDoc.add((Element)pLine);
            Paragraph p3 = new Paragraph(new Chunk("\n\n\nSettings:\n", FontFactory.getFont((String)"Helvetica", (float)16.0f)));
            Calendar calendar = Calendar.getInstance();
            p3.add((Object)new Phrase(new Chunk("\t\tDate: " + calendar.get(1) + "." + (calendar.get(2) + 1) + "." + calendar.get(5) + "." + calendar.get(11) + ":" + calendar.get(12) + "\n", FontFactory.getFont((String)"Helvetica", (float)12.0f))));
            p3.add((Object)new Phrase(new Chunk("\t\tTest collection: " + this.results[0].getTcName() + "\n", FontFactory.getFont((String)"Helvetica", (float)12.0f))));
            String tempString = "";
            int i = 0;
            while (i < this.results.length) {
                tempString = String.valueOf(tempString) + this.results[i].getMatchmakerName();
                tempString = i < this.results.length - 1 ? String.valueOf(tempString) + ", " : String.valueOf(tempString);
                ++i;
            }
            p3.add((Object)new Phrase(new Chunk("\t\tMatchmakers: " + tempString + "\n", FontFactory.getFont((String)"Helvetica", (float)12.0f))));
            p3.add((Object)new Phrase(new Chunk("\t\tSystem: " + System.getProperty("os.name") + "\n\n", FontFactory.getFont((String)"Helvetica", (float)12.0f))));
            p3.setAlignment(0);
            pdfDoc.add((Element)p3);
            Paragraph p9 = new Paragraph(new Chunk("Total Execution Time\n", FontFactory.getFont((String)"Helvetica", (float)16.0f)));
            pdfDoc.add((Element)p9);
            int i2 = 0;
            while (i2 < this.results.length) {
                pdfDoc.add((Element)new Chunk("\t\t" + this.results[i2].getMatchmakerName() + ": " + this.results[i2].getTotalExecutionTime() / 1000L + "sec.\n"));
                ++i2;
            }
            pdfDoc.newPage();
            PdfContentByte cb = writer.getDirectContent();
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            cb.beginText();
            cb.setFontAndSize(bf, 12.0f);
            int chartCount = 0;
            boolean wasNewPage = false;
            for (Chart chart : this.charts) {
                BufferedImage image = chart.snapshot(420, 300);
                File tempFile = new File("temp.png");
                ImageIO.write((RenderedImage)image, "PNG", tempFile);
                Image chartImage = Image.getInstance((String)"temp.png");
                chartImage.setAlignment(1);
                pdfDoc.add((Element)chartImage);
                tempFile.delete();
                if (++chartCount % 2 == 0) {
                    cb.endText();
                    pdfDoc.newPage();
                    cb.beginText();
                    cb.setFontAndSize(bf, 12.0f);
                    wasNewPage = true;
                    continue;
                }
                c = new Chunk(" ", FontFactory.getFont((String)"Helvetica", (float)18.0f));
                space = new Paragraph(c);
                space.setAlignment(1);
                pdfDoc.add((Element)space);
                wasNewPage = false;
            }
            if (!wasNewPage) {
                cb.endText();
                pdfDoc.newPage();
                cb.beginText();
                cb.setFontAndSize(bf, 12.0f);
            }
            Chunk c1 = new Chunk("");
            Paragraph pLine1 = new Paragraph(c1);
            c1 = new Chunk("Explanations\n\n");
            c1.setFont(FontFactory.getFont((String)"Helvetica", (float)16.0f));
            pLine1.add((Object)c1);
            pLine1.setAlignment(0);
            pdfDoc.add((Element)pLine1);
            Paragraph defParagraph = new Paragraph();
            Chunk cDefP = new Chunk("Recall/Precision/Fallout:\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)12.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Standard information retrieval measures for evaluating search strategies.\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("RECALL: Ratio of the number of relevant services retrieved to the total number of relevant services in the database. Higher recall means a smaller amount of missed categories, smaller amount of false negatives.\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("PRECISION: Ratio of the number of relevant records retrieved to the total number of records retrieved. The higher the precision the smaller the amount of false positives.\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("FALLOUT: Ratio of the number of irrelevant services retrieved to the number irrelevant services. The smaller the fallout the smaller the amount of false positives.");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            c = new Chunk(" ", FontFactory.getFont((String)"Helvetica", (float)18.0f));
            space = new Paragraph(c);
            space.setAlignment(1);
            defParagraph.add((Object)space);
            cDefP = new Chunk("\nF1 measure:\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)12.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("F1 score is a statistical measure for a classifier. It combines recall and precision values with equal importance.\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("F1 = 2PR/(P+R).\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("LAMBDA: Number of steps up to the maximum recall value for each request.");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            c = new Chunk(" ", FontFactory.getFont((String)"Helvetica", (float)18.0f));
            space = new Paragraph(c);
            space.setAlignment(1);
            defParagraph.add((Object)space);
            cDefP = new Chunk("\nMicro-averaging:\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)12.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Recall(i) is defined as the sum of the numbers of true positives of all requests found at evaluation level i (0<=i<lambda) divided by the sum of the magnitudes of all relevance sets in the test collection.\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Precision(i) is defined as the sum of the numbers of true positives of all requests found at evaluation level i (0<=i<lambda) divided by the number of retrieved services for all queries at i.\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Fallout(i) is computed analogous considering false positives and the number of irrelevant services.");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            c = new Chunk(" ", FontFactory.getFont((String)"Helvetica", (float)18.0f));
            space = new Paragraph(c);
            space.setAlignment(1);
            defParagraph.add((Object)space);
            cDefP = new Chunk("\nMacro-averaging:\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)12.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Macro-averaging measures the precision and fallout values for each query seperatly at standard recall levels (with lambda being the number of levels) and afterwards computes the mean value for the measures at each level i (0<=i<lambda).\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("To determine the precision and fallout values at the standard recall levels, ceiling interpolation is adopted.");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            c = new Chunk(" ", FontFactory.getFont((String)"Helvetica", (float)18.0f));
            space = new Paragraph(c);
            space.setAlignment(1);
            defParagraph.add((Object)space);
            cDefP = new Chunk("\nQuery Response Time:\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)12.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Time taken by the matchmaker to compose an ordered list of services for each query, presented as query parsing time, query processing time and matching time. The average query response time is also displayed in the chart.");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            c = new Chunk(" ", FontFactory.getFont((String)"Helvetica", (float)18.0f));
            space = new Paragraph(c);
            space.setAlignment(1);
            defParagraph.add((Object)space);
            cDefP = new Chunk("\nMemory Consumption:\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)12.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Memory used by the matchmaker during the whole evaluation process.");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            c = new Chunk(" ", FontFactory.getFont((String)"Helvetica", (float)18.0f));
            space = new Paragraph(c);
            space.setAlignment(1);
            defParagraph.add((Object)space);
            cDefP = new Chunk("\nScalability:\n");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)12.0f));
            defParagraph.add((Object)cDefP);
            cDefP = new Chunk("Measures the average query response times for an increasing number of service offers. Subsets of service offers of the test collection are drawn deterministically for each evaluation run.");
            cDefP.setFont(FontFactory.getFont((String)"Helvetica", (float)10.0f));
            defParagraph.add((Object)cDefP);
            pdfDoc.add((Element)defParagraph);
            cb.endText();
        }
        catch (Exception e) {
            System.err.println("Error writing pdf report: " + e.toString());
            JOptionPane.showMessageDialog(null, "The report could not be saved. Make sure that the file is not already open or read-only.");
            return;
        }
        pdfDoc.close();
    }
}

