/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RelevanceSet {
    private HashSet<URI> binaryRelevants = new HashSet();
    private HashSet<URI> binaryIrrelevants = new HashSet();
    private HashMap<String, Double> grades = new HashMap();
    private HashMap<URI, String> gradedRelevants = new HashMap();
    private HashSet<URI> gradedIrrelevants = new HashSet();

    public void addGrade(String grade, double gain) {
        this.grades.put(grade, new Double(gain));
    }

    public void addAsBinaryRelevant(URI service) {
        this.binaryRelevants.add(service);
    }

    public void addAsBinaryIrrelevant(URI service) {
        this.binaryIrrelevants.add(service);
    }

    public void addAsGradedRelevant(URI service, String grade) {
        this.gradedRelevants.put(service, grade);
    }

    public void addAsGradedIrrelevant(URI service) {
        this.gradedIrrelevants.add(service);
    }

    public boolean isBinaryRelevant(URI service) {
        return this.binaryRelevants.contains(service);
    }

    public boolean isBinaryIrrelevant(URI service) {
        return this.binaryIrrelevants.contains(service);
    }

    public boolean isGradedRelevant(URI service) {
        return this.gradedRelevants.containsKey(service);
    }

    public boolean isGradedIrrelevant(URI service) {
        return this.gradedIrrelevants.contains(service);
    }

    public String getGradeOfRelevance(URI service) {
        if (this.gradedRelevants.containsKey(service)) {
            return this.gradedRelevants.get(service);
        }
        if (this.gradedIrrelevants.contains(service)) {
            return "irrelevant";
        }
        return "unknown";
    }

    public double getGain(URI service) {
        String grade = this.getGradeOfRelevance(service);
        if (this.grades.containsKey(grade)) {
            return this.grades.get(grade);
        }
        return 0.0;
    }

    public double getGain(String grade) {
        if (this.grades.containsKey(grade)) {
            return this.grades.get(grade);
        }
        return 0.0;
    }

    public int getNumberOfBinaryJudgements() {
        return this.binaryRelevants.size() + this.binaryIrrelevants.size();
    }

    public int getNumberOfGradedJudgements() {
        return this.gradedRelevants.size() + this.gradedIrrelevants.size();
    }

    public Set<URI> getBinaryRelevants() {
        return this.binaryRelevants;
    }

    public Set<URI> getBinaryIrrelevants() {
        return this.binaryIrrelevants;
    }

    public HashSet<URI> getGradedIrrelevants() {
        return this.gradedIrrelevants;
    }

    public HashMap<URI, String> getGradedRelevants() {
        return this.gradedRelevants;
    }

    public double getMaxGain() {
        double maxGain = -1.0;
        for (Double gain : this.grades.values()) {
            if (!(gain > maxGain)) continue;
            maxGain = gain;
        }
        return maxGain;
    }
}

