/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.Configuration;
import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.TCQualityTestResult;
import de.dfki.sme2.TestCollection;
import de.dfki.sme2.ThreadedEvaluation;
import de.dfki.sme2.gui.SME2MainFrame;
import java.util.Collection;
import org.apache.log4j.Logger;

public class TCQualityTest {
    protected static Logger logger = Logger.getLogger(TCQualityTest.class);
    private SME2MainFrame gui;
    private Configuration config;
    private ThreadedEvaluation currentEval = null;

    public TCQualityTest(Configuration config, SME2MainFrame gui) {
        this.config = config;
        this.gui = gui;
    }

    public TCQualityTestResult test() {
        try {
            Collection<TestCollection> tcFolds = this.config.getTestCollection().nFold(this.config.getFolds(), this.config.getSeed());
            MatchmakerEvaluationResult[][] results = new MatchmakerEvaluationResult[tcFolds.size()][this.config.getSelectedMatchmakers().size()];
            int count = 0;
            for (TestCollection tc : tcFolds) {
                Configuration testConfig = new Configuration();
                testConfig.setCheckAP(true);
                testConfig.setSelectedMatchmakers(this.config.getSelectedMatchmakers());
                testConfig.setTestCollection(tc);
                this.currentEval = new ThreadedEvaluation(testConfig, this.gui);
                this.currentEval.setInfoToAppend(" TC quality tests (fold " + (count + 1) + ")");
                results[count] = this.currentEval.evaluate();
                ++count;
            }
            return new TCQualityTestResult(results, this.config.getFolds(), this.config.getSeed());
        }
        catch (Exception e) {
            logger.error((Object)"Unable to perform test collection quality tests.", (Throwable)e);
            return null;
        }
    }
}

