/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.RelevanceSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestCollection {
    private Logger logger = Logger.getLogger(this.getClass());
    public static final String OFFER_DIR = "offers" + File.separator + "services";
    public static final String REQUEST_DIR = "requests" + File.separator + "services";
    private Collection<URI> serviceOffers = new HashSet<URI>();
    private Collection<URI> serviceOffersSorted = new ArrayList<URI>();
    private Map<URI, RelevanceSet> queries = new HashMap<URI, RelevanceSet>();
    private Map<URI, RelevanceSet> queriesSorted = new LinkedHashMap<URI, RelevanceSet>();
    private String name = null;
    private String type = "";
    private String description = "";
    private String authors = "";
    private File htdocs = null;

    public File getHtdocs() {
        return this.htdocs;
    }

    public void addServiceOffer(URI offer) {
        this.serviceOffers.add(offer);
    }

    public Collection<URI> getServiceOffers() {
        return this.serviceOffers;
    }

    public Collection<URI> getServiceOffersSorted() {
        return this.serviceOffersSorted;
    }

    public int getNumberOfServiceOffers() {
        return this.serviceOffers.size();
    }

    public int getNumberOfRequests() {
        return this.queries.size();
    }

    public void addQuery(URI query, RelevanceSet relevanceSet) {
        this.queries.put(query, relevanceSet);
    }

    public Collection<URI> getQueries() {
        return this.queriesSorted.keySet();
    }

    public RelevanceSet getRelevanceSet(URI query) {
        return this.queries.get(query);
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isBinaryComplete() {
        for (RelevanceSet set : this.queries.values()) {
            if (set.getNumberOfBinaryJudgements() == this.serviceOffers.size()) continue;
            return false;
        }
        return true;
    }

    public boolean isGradedComplete() {
        for (RelevanceSet set : this.queries.values()) {
            if (set.getNumberOfGradedJudgements() == this.serviceOffers.size()) continue;
            return false;
        }
        return true;
    }

    public static TestCollection parse(String xmlFileName) {
        TestCollection tc = new TestCollection();
        try {
            File xmlFile = new File(xmlFileName);
            xmlFileName = xmlFile.getAbsolutePath();
            String string = xmlFileName.substring(0, xmlFileName.lastIndexOf(File.separator));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFileName);
            NodeList nodes = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node configNode = nodes.item(i);
                if (configNode.getNodeType() == 1) {
                    String configNodeName = configNode.getNodeName();
                    if (configNodeName.equals("proprietary")) {
                        tc.proprietaryReadTCData(string);
                    } else if (configNodeName.equals("type")) {
                        tc.type = configNode.getTextContent();
                    } else if (configNodeName.equals("authors")) {
                        tc.authors = configNode.getTextContent();
                    } else if (configNodeName.equals("description")) {
                        tc.description = configNode.getTextContent();
                    } else if (configNodeName.equals("name")) {
                        tc.name = configNode.getTextContent();
                    } else if (configNodeName.equals("htdocs")) {
                        tc.htdocs = new File(configNode.getTextContent());
                    } else if (configNodeName.equals("relevancegradeexport")) {
                        tc.parseSWSRATExport(configNode, string);
                    } else if (configNodeName.equals("offers")) {
                        NodeList offerNodes = configNode.getChildNodes();
                        int j = 0;
                        while (j < offerNodes.getLength()) {
                            if (offerNodes.item(j).getNodeType() == 1) {
                                String offer = ((Element)offerNodes.item(j)).getElementsByTagName("uri").item(0).getTextContent();
                                try {
                                    URI offerURI = new URI(offer);
                                    tc.serviceOffers.add(offerURI);
                                }
                                catch (Exception e) {
                                    tc.logger.warn((Object)("Unable to add service offer " + offer + "."), (Throwable)e);
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (tc.name == null) {
                tc.name = xmlFile.getName().replaceFirst(".xml", "");
            }
        }
        catch (SAXException e) {
            tc.logger.warn((Object)("Parsing error while processing " + xmlFileName + "."), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            tc.logger.warn((Object)("File " + xmlFileName + " not found. Unable to parse test collection file"), (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            tc.logger.warn((Object)"Unable to create XML parser.", (Throwable)e);
            return null;
        }
        ArrayList<String> serviceOffersStrings = new ArrayList<String>(tc.serviceOffers.size());
        for (URI uRI : tc.serviceOffers) {
            serviceOffersStrings.add(uRI.toString());
        }
        Collections.sort(serviceOffersStrings);
        for (String string : serviceOffersStrings) {
            try {
                URI serviceURI = new URI(string);
                tc.serviceOffersSorted.add(serviceURI);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(tc.queries.keySet().size());
        for (URI uRI : tc.queries.keySet()) {
            arrayList.add(uRI.toString());
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            try {
                URI queryURI = new URI(string);
                tc.queriesSorted.put(queryURI, tc.queries.get(queryURI));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return tc;
    }

    private void parseSWSRATExport(Node rootNode, String directory) {
        NodeList childNodes = rootNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("binaryrelevanceset")) {
                NodeList requestNodes = node.getChildNodes();
                int j = 0;
                while (j < requestNodes.getLength()) {
                    try {
                        if (requestNodes.item(j).getNodeType() == 1) {
                            Element requestNode = (Element)requestNodes.item(j);
                            String requestUriContent = requestNode.getElementsByTagName("uri").item(0).getTextContent().replaceAll("\\s", "%20");
                            URI requestURI = !URI.create(requestUriContent).isAbsolute() ? this.getFileURI(requestUriContent, String.valueOf(directory) + File.separator + REQUEST_DIR) : new URI(requestUriContent.split("#")[0]);
                            RelevanceSet relevanceSet = this.getRelevanceSet(requestURI);
                            if (relevanceSet == null) {
                                relevanceSet = new RelevanceSet();
                            }
                            NodeList offerNodes = requestNode.getElementsByTagName("offer");
                            int k = 0;
                            while (k < offerNodes.getLength()) {
                                boolean relevant;
                                Element offerNode = (Element)offerNodes.item(k);
                                String offerUriContent = offerNode.getElementsByTagName("uri").item(0).getTextContent().replaceAll("\\s", "%20");
                                URI offerURI = !URI.create(offerUriContent).isAbsolute() ? this.getFileURI(offerUriContent, String.valueOf(directory) + File.separator + OFFER_DIR) : new URI(offerUriContent.split("#")[0]);
                                boolean bl = relevant = offerNode.getElementsByTagName("relevant").item(0).getTextContent().equals("1");
                                if (relevant) {
                                    relevanceSet.addAsBinaryRelevant(offerURI);
                                } else {
                                    relevanceSet.addAsBinaryIrrelevant(offerURI);
                                }
                                this.addServiceOffer(offerURI);
                                ++k;
                            }
                            this.addQuery(requestURI, relevanceSet);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Unable to read request from <binaryrelevanceset> tag.", (Throwable)e);
                    }
                    ++j;
                }
            }
            if (nodeName.equals("relevancegrades")) {
                Element scaleNode = (Element)((Element)node).getElementsByTagName("scale").item(0);
                NodeList requestNodes = scaleNode.getElementsByTagName("services").item(0).getChildNodes();
                int j = 0;
                while (j < requestNodes.getLength()) {
                    try {
                        if (requestNodes.item(j).getNodeType() == 1) {
                            Element requestNode = (Element)requestNodes.item(j);
                            String requestUriContent = requestNode.getElementsByTagName("uri").item(0).getTextContent().replaceAll("\\s", "%20");
                            URI requestURI = !URI.create(requestUriContent).isAbsolute() ? this.getFileURI(requestUriContent, String.valueOf(directory) + File.separator + REQUEST_DIR) : new URI(requestUriContent.split("#")[0]);
                            RelevanceSet relevanceSet = this.getRelevanceSet(requestURI);
                            if (relevanceSet == null) {
                                relevanceSet = new RelevanceSet();
                            }
                            NodeList offerNodes = requestNode.getElementsByTagName("offer");
                            int k = 0;
                            while (k < offerNodes.getLength()) {
                                Element offerNode = (Element)offerNodes.item(k);
                                String offerUriContent = offerNode.getElementsByTagName("uri").item(0).getTextContent().replaceAll("\\s", "%20");
                                URI offerURI = !URI.create(offerUriContent).isAbsolute() ? this.getFileURI(offerUriContent, String.valueOf(directory) + File.separator + OFFER_DIR) : new URI(offerUriContent.split("#")[0]);
                                Element gradeNode = (Element)offerNode.getElementsByTagName("grade").item(0);
                                String gradeName = gradeNode.getElementsByTagName("name").item(0).getTextContent();
                                Double gain = new Double(gradeNode.getElementsByTagName("value").item(0).getTextContent());
                                relevanceSet.addGrade(gradeName, gain);
                                if (gain == 0.0) {
                                    relevanceSet.addAsGradedIrrelevant(offerURI);
                                } else {
                                    relevanceSet.addAsGradedRelevant(offerURI, gradeName);
                                }
                                this.addServiceOffer(offerURI);
                                ++k;
                            }
                            this.addQuery(requestURI, relevanceSet);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Unable to read request from <relevancegrades> tag.", (Throwable)e);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private URI getFileURI(String nodeContent, String dirStr) {
        String serviceId = nodeContent.substring(0, nodeContent.indexOf(95));
        File dir = new File(dirStr);
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (fileName.substring(0, fileName.indexOf(95)).equals(serviceId)) {
                try {
                    return file.toURI();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Unable to get file for " + nodeContent + " from directory " + dirStr), (Throwable)e);
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    private void proprietaryReadTCData(String directory) {
        int n;
        File offerDir = new File(String.valueOf(directory) + File.separator + "services");
        try {
            File[] services;
            offerDir = new File(String.valueOf(offerDir.getAbsolutePath()) + File.separator + offerDir.list()[0]);
            File[] fileArray = services = offerDir.listFiles();
            n = services.length;
            int n2 = 0;
            while (n2 < n) {
                File service = fileArray[n2];
                try {
                    if (service.isFile()) {
                        this.serviceOffers.add(service.toURI());
                    }
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Service offer " + service + " is no valid URI."), (Throwable)e);
                }
                ++n2;
            }
        }
        catch (NullPointerException e) {
            this.logger.warn((Object)"services folder is missing.");
        }
        try {
            File[] requests;
            File requestDir = new File(String.valueOf(directory) + File.separator + "queries");
            requestDir = new File(String.valueOf(requestDir.getAbsolutePath()) + File.separator + requestDir.list()[0]);
            File[] e = requests = requestDir.listFiles();
            int n3 = requests.length;
            n = 0;
            while (n < n3) {
                File request = e[n];
                try {
                    if (request.isFile()) {
                        this.queries.put(request.toURI(), new RelevanceSet());
                    }
                }
                catch (Exception e2) {
                    this.logger.warn((Object)("Request " + request + " is no valid URI."), (Throwable)e2);
                }
                ++n;
            }
        }
        catch (NullPointerException e) {
            this.logger.warn((Object)"queries folder is missing.");
        }
        try {
            File relevanceSetsDir = new File(String.valueOf(directory) + File.separator + "relevance_sets");
            block14: for (URI query : this.queries.keySet()) {
                String queryPath = query.getPath();
                String fileName = queryPath.substring(queryPath.lastIndexOf(47) + 1);
                String[] stringArray = relevanceSetsDir.list();
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    String relDir = stringArray[n5];
                    String relName = relDir.substring(relDir.indexOf(45) + 1);
                    if (fileName.equals(relName)) {
                        File relSetDir = new File(String.valueOf(directory) + File.separator + "relevance_sets" + File.separator + relDir);
                        String[] stringArray2 = relSetDir.list();
                        int n6 = stringArray2.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            String relFile = stringArray2[n7];
                            try {
                                this.queries.get(query).addAsBinaryRelevant(new File(String.valueOf(offerDir.toString()) + File.separator + relFile).toURI());
                            }
                            catch (Exception e) {
                                this.logger.warn((Object)("No valid service URI for " + relFile + " could be constructed."), (Throwable)e);
                            }
                            ++n7;
                        }
                        for (URI offer : this.serviceOffers) {
                            if (this.queries.get(query).isBinaryRelevant(offer)) continue;
                            this.queries.get(query).addAsBinaryIrrelevant(offer);
                        }
                        continue block14;
                    }
                    ++n5;
                }
            }
        }
        catch (NullPointerException e) {
            this.logger.warn((Object)"relevance_sets folder is missing.");
        }
    }

    public Collection<TestCollection> nFold(int n, long randomSeed) {
        int foldSize = this.serviceOffers.size() / n;
        int overhang = this.serviceOffers.size() % n;
        LinkedList<URI> tmpOffers = new LinkedList<URI>(this.serviceOffers);
        HashSet<TestCollection> resultTCs = new HashSet<TestCollection>();
        Random rnd = new Random(randomSeed);
        int i = 0;
        while (i < n) {
            TestCollection tc = new TestCollection();
            tc.setName(String.valueOf(this.name) + " fold " + (i + 1));
            tc.setDescription("Automatically derived from " + this.name + ".");
            tc.setAuthors(this.authors);
            int mod = i < overhang ? 1 : 0;
            int j = 0;
            while (j < foldSize + mod) {
                int offerIndex = rnd.nextInt(tmpOffers.size());
                tc.addServiceOffer(tmpOffers.get(offerIndex));
                tmpOffers.remove(offerIndex);
                ++j;
            }
            for (URI query : this.queriesSorted.keySet()) {
                RelevanceSet relSet = new RelevanceSet();
                HashSet<URI> binaryRelevants = new HashSet<URI>();
                HashSet<URI> binaryIrrelevants = new HashSet<URI>();
                Collection<URI> reducedOffers = tc.getServiceOffersSorted();
                for (URI offer : reducedOffers) {
                    if (this.queries.get(query).isBinaryRelevant(offer)) {
                        binaryRelevants.add(offer);
                        continue;
                    }
                    if (!this.queries.get(query).isBinaryIrrelevant(offer)) continue;
                    binaryIrrelevants.add(offer);
                }
                for (URI offer : binaryRelevants) {
                    relSet.addAsBinaryRelevant(offer);
                }
                for (URI offer : binaryIrrelevants) {
                    relSet.addAsBinaryIrrelevant(offer);
                }
                if (binaryRelevants.isEmpty()) continue;
                tc.addQuery(query, relSet);
            }
            if (!tc.queries.isEmpty()) {
                resultTCs.add(tc);
            }
            ++i;
        }
        return resultTCs;
    }

    public void save(String fileName) {
        try {
            Document xml = null;
            Element tc = null;
            File file = new File(fileName);
            xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            tc = xml.createElement("testcollection");
            xml.appendChild(tc);
            if (this.name != null) {
                Element name = xml.createElement("name");
                name.appendChild(xml.createTextNode(this.name));
                tc.appendChild(name);
            }
            Element authors = xml.createElement("authors");
            authors.appendChild(xml.createTextNode(this.authors));
            tc.appendChild(authors);
            Element type = xml.createElement("type");
            type.appendChild(xml.createTextNode(this.type));
            tc.appendChild(type);
            Element description = xml.createElement("description");
            description.appendChild(xml.createTextNode(this.description));
            tc.appendChild(description);
            if (this.htdocs != null) {
                Element htdocs = xml.createElement("htdocs");
                htdocs.appendChild(xml.createTextNode(this.htdocs.toString()));
                tc.appendChild(htdocs);
            }
            Element offers = xml.createElement("offers");
            tc.appendChild(offers);
            for (URI offerURI : this.serviceOffers) {
                Element element = xml.createElement("offer");
                offers.appendChild(element);
                Element uri = xml.createElement("uri");
                uri.appendChild(xml.createTextNode(offerURI.toString()));
                element.appendChild(uri);
            }
            Element exports = xml.createElement("relevancegradeexport");
            tc.appendChild(exports);
            Element binSets = xml.createElement("binaryrelevanceset");
            exports.appendChild(binSets);
            for (Map.Entry entry : this.queries.entrySet()) {
                Element relevant;
                Element offerUri;
                Element offer;
                URI requestURI = (URI)entry.getKey();
                RelevanceSet relSet = (RelevanceSet)entry.getValue();
                Element request = xml.createElement("request");
                binSets.appendChild(request);
                Element reqUri = xml.createElement("uri");
                reqUri.appendChild(xml.createTextNode(requestURI.toString()));
                request.appendChild(reqUri);
                Element ratings = xml.createElement("ratings");
                request.appendChild(ratings);
                for (URI offerURI : relSet.getBinaryRelevants()) {
                    offer = xml.createElement("offer");
                    ratings.appendChild(offer);
                    offerUri = xml.createElement("uri");
                    offerUri.appendChild(xml.createTextNode(offerURI.toString()));
                    offer.appendChild(offerUri);
                    relevant = xml.createElement("relevant");
                    relevant.appendChild(xml.createTextNode("1"));
                    offer.appendChild(relevant);
                }
                for (URI offerURI : relSet.getBinaryIrrelevants()) {
                    offer = xml.createElement("offer");
                    ratings.appendChild(offer);
                    offerUri = xml.createElement("uri");
                    offerUri.appendChild(xml.createTextNode(offerURI.toString()));
                    offer.appendChild(offerUri);
                    relevant = xml.createElement("relevant");
                    relevant.appendChild(xml.createTextNode("0"));
                    offer.appendChild(relevant);
                }
            }
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(new File(fileName));
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                this.logger.error((Object)("Unable to save test collection to " + fileName + "."), (Throwable)transformerConfigurationException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.error((Object)("Unable to save test collection to " + fileName + "."), (Throwable)fileNotFoundException);
            }
            catch (TransformerException transformerException) {
                this.logger.error((Object)("Unable to save evaluation test collection to " + fileName + "."), (Throwable)transformerException);
            }
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("Unable to save test collection to " + fileName + "."), (Throwable)e);
        }
    }

    public String toString() {
        return this.name;
    }

    public double getMaxGain() {
        double maxGain = -1.0;
        for (RelevanceSet relSet : this.queries.values()) {
            double tmp = relSet.getMaxGain();
            if (!(tmp > maxGain)) continue;
            maxGain = tmp;
        }
        return maxGain;
    }

    public static void main(String[] args) {
        try {
            String input = args[0];
            String output = args[1];
            System.out.println("Load test collection from " + input);
            TestCollection tc = TestCollection.parse(input);
            TreeSet<String> names = new TreeSet<String>();
            for (URI offer : tc.getServiceOffersSorted()) {
                names.add(offer.toString().substring(offer.toString().lastIndexOf(47) + 1));
            }
            File dir = new File("C:\\Programme\\xampp\\htdocs\\services\\1.1");
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                names.remove(fileName);
                ++n2;
            }
            for (String remaining : names) {
                System.out.println(remaining);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

