/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.Configuration;
import de.dfki.sme2.IMatchmakerPlugin;
import de.dfki.sme2.Matchmaker;
import de.dfki.sme2.MatchmakerEvaluation;
import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.TCQualityTest;
import de.dfki.sme2.TCQualityTestResult;
import de.dfki.sme2.TestCollection;
import de.dfki.sme2.gui.ResultDesktopPane;
import de.dfki.sme2.gui.SME2MainFrame;
import java.io.File;
import java.net.URI;
import java.util.Date;
import javax.swing.JOptionPane;

public class ThreadedEvaluation
extends MatchmakerEvaluation
implements Runnable {
    public static final long THREAD_KILL_TIMEOUT = 10000L;
    private SME2MainFrame gui;
    private static State currentState = State.STOPPED;
    private long suspensionTime;
    private String infoToAppend = "";

    public ThreadedEvaluation(Configuration config, SME2MainFrame gui) {
        super(config);
        this.gui = gui;
    }

    @Override
    public void run() {
        try {
            currentState = State.RUNNING;
            this.gui.updateEvalProgressBar("Evaluation started...", 0);
            MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[]{};
            Date currentDate = new Date();
            String dateTimeStr = currentDate.toString().replace(':', '-').replace(' ', '_');
            if (this.checkEvaluateMatchmakers()) {
                results = this.evaluate();
                if (currentState == State.STOPPED) {
                    this.gui.updateEvalProgressBar("Evaluation stopped", 0);
                    this.gui.switchControlsAfterEvaluation();
                    return;
                }
            }
            TCQualityTestResult tcTestResult = null;
            if (this.config.isCheckTCQuality()) {
                TCQualityTest tcTest = new TCQualityTest(this.config, this.gui);
                tcTestResult = tcTest.test();
                if (this.config.isAutoSave()) {
                    tcTestResult.save(String.valueOf(this.config.getOutputDirectory()) + File.separator + dateTimeStr + ".xml");
                }
            }
            ResultDesktopPane resultPane = this.gui.addResultDesktopPane(dateTimeStr, results, this.config.isAutoSave());
            if (tcTestResult != null) {
                resultPane.addTCQualityTestResult(tcTestResult);
            }
            this.gui.updateEvalProgressBar("Ready", 0);
            this.gui.switchControlsAfterEvaluation();
            currentState = State.STOPPED;
        }
        catch (NullPointerException e) {
            logger.error((Object)"Evaluation error.", (Throwable)e);
            this.gui.updateEvalProgressBar("Evaluation stopped", 0);
            this.gui.switchControlsAfterEvaluation();
            return;
        }
        catch (Exception e) {
            logger.error((Object)"Evaluation error.", (Throwable)e);
            this.gui.updateEvalProgressBar("Evaluation stopped", 0);
            JOptionPane.showMessageDialog(null, "Evaluation stopped. Details are printed to log.\n\n" + e, "SME^2 - Evaluation error", 0);
            this.gui.switchControlsAfterEvaluation();
            return;
        }
    }

    protected boolean checkEvaluateMatchmakers() {
        return this.config.isCheckAP() || this.config.isCheckAPPrime() || this.config.isCheckBpref() || this.config.isCheckExecTime() || this.config.isCheckF1() || this.config.isCheckMemory() || this.config.isCheckNDCG() || this.config.isCheckNDCGPrime() || this.config.isCheckQ() || this.config.isCheckQPrime() || this.config.isCheckQRT() || this.config.isCheckRBP() || this.config.isCheckRF() || this.config.isCheckRP() || this.config.isCheckOPT();
    }

    @Override
    protected void startJettyHttpServer(File htdocs) throws Exception {
        this.gui.updateEvalProgressBar("Starting Jetty on port 80 with \"" + htdocs.toString() + "\" has htdocs root...", 0);
        super.startJettyHttpServer(htdocs);
    }

    @Override
    protected void stopJettyHttpServer() throws Exception {
        this.gui.updateEvalProgressBar("Stopping Jetty on port 80...", 100);
        super.stopJettyHttpServer();
    }

    @Override
    protected MatchmakerEvaluationResult evaluate(Matchmaker matchmaker) throws Exception {
        this.suspensionTime = 0L;
        MatchmakerEvaluationResult result = super.evaluate(matchmaker);
        if (this.suspensionTime > 0L) {
            result.setTotalExecutionTime(result.getTotalExecutionTime() - this.suspensionTime);
        }
        return result;
    }

    protected void registerServiceOffer(URI serviceOffer, IMatchmakerPlugin plugin, String matchmakerName, int counter, String version) {
        this.performThreadSuspension();
        int tcSize = this.config.getTestCollection().getNumberOfServiceOffers();
        int progressValue = (int)((float)counter * 100.0f / (float)tcSize);
        this.gui.updateEvalProgressBar(String.valueOf(matchmakerName) + ": registering service offers (" + counter + " of " + tcSize + ")..." + this.infoToAppend, progressValue);
        super.registerServiceOffer(serviceOffer, plugin, matchmakerName, version);
    }

    @Override
    protected void queryMatchmaker(URI query, IMatchmakerPlugin plugin, String matchmakerName, MatchmakerEvaluationResult evalResult, String version) {
        this.performThreadSuspension();
        super.queryMatchmaker(query, plugin, matchmakerName, evalResult, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performThreadSuspension() {
        if (currentState == State.SUSPENDED) {
            long suspensionStart = new Date().getTime();
            this.memMonitor.suspend();
            ThreadedEvaluation threadedEvaluation = this;
            synchronized (threadedEvaluation) {
                try {
                    while (currentState == State.SUSPENDED) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Error while suspending evaluation thread.", (Throwable)e);
                    this.resume();
                }
            }
            this.suspensionTime += new Date().getTime() - suspensionStart;
            this.memMonitor.resume();
        }
    }

    @Override
    protected void registerServiceOffers(IMatchmakerPlugin plugin, String matchmakerName, String version, MatchmakerEvaluationResult evalResult) {
        TestCollection tc = this.config.getTestCollection();
        int i = 1;
        for (URI serviceOffer : tc.getServiceOffersSorted()) {
            if (currentState == State.STOPPED) {
                return;
            }
            this.registerServiceOffer(serviceOffer, plugin, matchmakerName, i++, version);
        }
        if (this.config.isCheckOPT()) {
            evalResult.setAverageOffersParsingTime((double)this.averageOfferParsingTime / (double)(i - 1));
        }
        evalResult.setAverageOffersProcessingTime((double)this.averageOfferProcessingTime / (double)(i - 1));
    }

    @Override
    protected void sendRequestsToMatchmaker(IMatchmakerPlugin plugin, String matchmakerName, MatchmakerEvaluationResult evalResult, String version) {
        TestCollection tc = this.config.getTestCollection();
        this.duplicatesDetected = false;
        int queryCounter = 0;
        for (URI query : tc.getQueries()) {
            if (currentState == State.STOPPED) {
                return;
            }
            try {
                int numberOfRequests = this.config.getTestCollection().getNumberOfRequests();
                int progressValue = (int)((float)(++queryCounter) * 100.0f / (float)numberOfRequests);
                this.gui.updateEvalProgressBar(String.valueOf(matchmakerName) + ": processing query " + queryCounter + " of " + numberOfRequests + "..." + this.infoToAppend, progressValue);
                this.queryMatchmaker(query, plugin, matchmakerName, evalResult, version);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to query " + matchmakerName + " for " + query + "."), (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        currentState = State.STOPPED;
        this.notify();
        new StopperThread(10000L, Thread.currentThread()).start();
    }

    public synchronized void suspend() {
        currentState = State.SUSPENDED;
        this.gui.updateEvalProgressBar("Evaluation process suspended. Press \"Start\" to resume...", 0);
    }

    public synchronized void resume() {
        currentState = State.RUNNING;
        this.notify();
    }

    public State getState() {
        return currentState;
    }

    public void setInfoToAppend(String infoToAppend) {
        this.infoToAppend = infoToAppend;
    }

    public static enum State {
        RUNNING,
        SUSPENDED,
        STOPPED;

    }

    private class StopperThread
    extends Thread {
        private long mSec;
        private Thread threadToKill;

        public StopperThread(long mSec, Thread threadToKill) {
            this.mSec = mSec;
            this.threadToKill = threadToKill;
        }

        @Override
        public void run() {
            super.run();
            try {
                this.wait(this.mSec);
                this.threadToKill.stop();
            }
            catch (InterruptedException e) {
                logger.error((Object)"Unable to stop evaluation thread.", (Throwable)e);
            }
        }
    }
}

