/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.SME2;
import de.dfki.sme2.gui.CustomizableFileFilter;
import de.dfki.sme2.gui.RankingsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class InternalResultsFrame
extends JInternalFrame {
    private static final long serialVersionUID = 3248748923749823L;
    private JPanel jContentPane = null;
    private JSplitPane mainSplitPane = null;
    private JScrollPane treeScrollPane = null;
    private JTree menuTree = null;
    private JScrollPane infoScrollPane = null;
    private JTable infoTable = null;
    private DefaultMutableTreeNode resultsNode = null;
    private DefaultMutableTreeNode rankingsNode = null;
    private JMenuBar resultsJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem saveMenuItem = null;
    private JMenuItem printMenuItem = null;
    private SME2 sme2;

    public InternalResultsFrame(MatchmakerEvaluationResult[] results, SME2 sme2) {
        this.sme2 = sme2;
        this.initialize();
        this.appendResults(results);
        this.appendRankings(results);
    }

    private void appendResults(MatchmakerEvaluationResult[] results) {
        JTable resultsTable = this.getNewDefaultTable("results", new CombinedResultsTableModel(results));
        this.resultsNode.setUserObject(resultsTable);
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n2];
            JTable resultTable = this.getNewDefaultTable("for " + result.getMatchmakerName(), new ResultsTableModel(result));
            DefaultMutableTreeNode resultNode = new DefaultMutableTreeNode(resultTable);
            this.resultsNode.add(resultNode);
            ++n2;
        }
    }

    private void appendRankings(MatchmakerEvaluationResult[] results) {
        HashSet<URI> queries = new HashSet<URI>();
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n2];
            for (URI query : result.getRankings().keySet()) {
                if (queries.contains(query)) continue;
                queries.add(query);
                DefaultMutableTreeNode queryNode = new DefaultMutableTreeNode(new RankingsTable(results, query, this.sme2.getTestCollection(result.getTcName())));
                this.rankingsNode.add(queryNode);
                MatchmakerEvaluationResult[] matchmakerEvaluationResultArray2 = results;
                int n3 = results.length;
                int n4 = 0;
                while (n4 < n3) {
                    MatchmakerEvaluationResult res = matchmakerEvaluationResultArray2[n4];
                    JTable rankingTable = this.getNewDefaultTable("for " + res.getMatchmakerName(), new RankingTableModel(res, query));
                    DefaultMutableTreeNode forMMNode = new DefaultMutableTreeNode(rankingTable);
                    queryNode.add(forMMNode);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void initialize() {
        this.setSize(700, 500);
        this.setJMenuBar(this.getResultsJMenuBar());
        this.setTitle("Info");
        this.setIconifiable(true);
        this.setResizable(true);
        this.setMaximizable(true);
        this.setPreferredSize(new Dimension(700, 500));
        this.setVisible(true);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane();
            this.mainSplitPane.setLeftComponent(this.getTreeScrollPane());
            this.mainSplitPane.setRightComponent(this.getInfoScrollPane());
        }
        return this.mainSplitPane;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new JScrollPane();
            this.treeScrollPane.setViewportView(this.getMenuTree());
        }
        return this.treeScrollPane;
    }

    private JTree getMenuTree() {
        if (this.menuTree == null) {
            this.menuTree = new JTree();
            this.menuTree.setSize(new Dimension(150, 447));
            this.menuTree.setPreferredSize(new Dimension(150, 72));
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("evaluation info");
            this.resultsNode = new DefaultMutableTreeNode("results");
            this.rankingsNode = new DefaultMutableTreeNode("rankings");
            rootNode.add(this.resultsNode);
            rootNode.add(this.rankingsNode);
            DefaultTreeModel model = new DefaultTreeModel(rootNode);
            this.menuTree.setModel(model);
            this.menuTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)InternalResultsFrame.this.menuTree.getSelectionPath().getLastPathComponent();
                        InternalResultsFrame.this.infoTable = (JTable)selectedNode.getUserObject();
                        InternalResultsFrame.this.infoScrollPane.setViewportView(InternalResultsFrame.this.infoTable);
                        InternalResultsFrame.this.resizeInfoTableColumns();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.menuTree.getSelectionModel().setSelectionMode(1);
        }
        return this.menuTree;
    }

    private void resizeInfoTableColumns() {
        int i = 0;
        while (i < this.infoTable.getModel().getColumnCount()) {
            Component headerComp = this.infoTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this.infoTable, this.infoTable.getColumnName(i), false, false, 0, 0);
            int maxWidth = (int)headerComp.getPreferredSize().getWidth() + this.infoTable.getRowMargin() + 4;
            int j = 0;
            while (j < this.infoTable.getModel().getRowCount()) {
                DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)this.infoTable.getCellRenderer(j, i);
                Component component = cellRenderer.getTableCellRendererComponent(this.infoTable, this.infoTable.getModel().getValueAt(j, i), false, false, j, i);
                int width = (int)component.getPreferredSize().getWidth() + this.infoTable.getRowMargin() + 4;
                maxWidth = Math.max(maxWidth, width);
                ++j;
            }
            this.infoTable.getColumnModel().getColumn(i).setPreferredWidth(maxWidth);
            ++i;
        }
        this.infoTable.doLayout();
    }

    private JScrollPane getInfoScrollPane() {
        if (this.infoScrollPane == null) {
            this.infoScrollPane = new JScrollPane();
            this.infoScrollPane.setViewportView(this.getInfoTable());
        }
        return this.infoScrollPane;
    }

    private JTable getInfoTable() {
        return this.infoTable;
    }

    private JMenuBar getResultsJMenuBar() {
        if (this.resultsJMenuBar == null) {
            this.resultsJMenuBar = new JMenuBar();
            this.resultsJMenuBar.add(this.getFileMenu());
        }
        return this.resultsJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.add(this.getPrintMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText("Save selected table as text");
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block7: {
                        boolean result;
                        File file;
                        block8: {
                            int confirmValue;
                            do {
                                JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                                fileChooser.setFileSelectionMode(0);
                                fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Matchmaker results text file (.txt)", "txt"));
                                fileChooser.setAcceptAllFileFilterUsed(false);
                                int returnValue = fileChooser.showDialog(null, "Save");
                                if (returnValue != 0) break block7;
                                file = fileChooser.getSelectedFile();
                                String fileName = file.getAbsolutePath();
                                if (!fileName.toLowerCase().endsWith(".txt")) {
                                    file = new File(String.valueOf(fileName) + ".txt");
                                }
                                if (!file.exists()) break block8;
                            } while ((confirmValue = JOptionPane.showConfirmDialog(null, "File " + file.getName() + " already exists! Do you really want to overwrite?", "Warning", 1)) == 1);
                            if (confirmValue == 2) break block7;
                            if (confirmValue == 0) {
                                file.delete();
                            }
                        }
                        if (!(result = InternalResultsFrame.this.saveTableAsText(file.getAbsolutePath()))) {
                            JOptionPane.showMessageDialog(null, "Error: Could not save table.", "Save error", 0);
                        }
                    }
                }
            });
        }
        return this.saveMenuItem;
    }

    private boolean saveTableAsText(String path) {
        try {
            FileWriter writer = new FileWriter(path);
            int i = 0;
            while (i < this.infoTable.getModel().getColumnCount()) {
                if (i > 0) {
                    writer.write("\t");
                }
                writer.write(this.infoTable.getModel().getColumnName(i));
                ++i;
            }
            writer.write("\n");
            i = 0;
            while (i < this.infoTable.getModel().getRowCount()) {
                int j = 0;
                while (j < this.infoTable.getModel().getColumnCount()) {
                    Object obj;
                    if (j > 0) {
                        writer.write("\t");
                    }
                    if ((obj = this.infoTable.getModel().getValueAt(i, j)) != null) {
                        writer.write(obj.toString());
                    }
                    ++j;
                }
                writer.write("\n");
                ++i;
            }
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private JMenuItem getPrintMenuItem() {
        if (this.printMenuItem == null) {
            this.printMenuItem = new JMenuItem();
            this.printMenuItem.setText("Print selected table");
            this.printMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        InternalResultsFrame.this.infoTable.print();
                    }
                    catch (PrinterException ex) {
                        JOptionPane.showMessageDialog(null, "Error: Could not print results.", "Printer error", 0);
                    }
                }
            });
        }
        return this.printMenuItem;
    }

    private JTable getNewDefaultTable(String label, TableModel model) {
        JTable table = new JTable(){
            protected static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                return this.getName();
            }
        };
        table.setName(label);
        table.setAutoResizeMode(0);
        table.setShowGrid(true);
        table.setSelectionMode(0);
        table.setEnabled(false);
        table.setRowSelectionAllowed(false);
        table.setDragEnabled(false);
        table.setModel(model);
        return table;
    }

    private class CombinedResultsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 32482394384L;

        public CombinedResultsTableModel(MatchmakerEvaluationResult[] results) {
            Double avgQpt;
            Double avgAP;
            MatchmakerEvaluationResult result;
            int n;
            int n2;
            MatchmakerEvaluationResult[] matchmakerEvaluationResultArray;
            int col;
            Object[] row;
            MatchmakerEvaluationResult res;
            this.addColumn("test");
            MatchmakerEvaluationResult[] matchmakerEvaluationResultArray2 = results;
            int n3 = results.length;
            int n4 = 0;
            while (n4 < n3) {
                MatchmakerEvaluationResult result2 = matchmakerEvaluationResultArray2[n4];
                this.addColumn(result2.getMatchmakerName());
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getTotalExecutionTime() > -1L) {
                    row = new Object[results.length + 1];
                    row[0] = "total execution time";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getTotalExecutionTime() > -1L) {
                            row[col] = String.valueOf(new Double((double)result.getTotalExecutionTime() / 60000.0).toString()) + " min";
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getAverageOffersParsingTime() > -1.0) {
                    row = new Object[results.length + 1];
                    row[0] = "average offers parsing time";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getAverageOffersParsingTime() > -1.0) {
                            row[col] = String.valueOf(new Double(result.getAverageOffersParsingTime()).toString()) + " miliseconds";
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getAverageOffersProcessingTime() > -1.0) {
                    row = new Object[results.length + 1];
                    row[0] = "average offers processing time";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getAverageOffersProcessingTime() > -1.0) {
                            row[col] = String.valueOf(new Double(result.getAverageOffersProcessingTime()).toString()) + " miliseconds";
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getAPs() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average AP";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getAPs() != null) {
                            avgAP = 0.0;
                            for (Double ap : result.getAPs().values()) {
                                avgAP = avgAP + ap;
                            }
                            avgAP = avgAP / (double)result.getAPs().size();
                            row[col] = avgAP.toString();
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getAPPrimes() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average AP'";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getAPPrimes() != null) {
                            avgAP = 0.0;
                            for (Double ap : result.getAPPrimes().values()) {
                                avgAP = avgAP + ap;
                            }
                            avgAP = avgAP / (double)result.getAPPrimes().size();
                            row[col] = avgAP.toString();
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getQs() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average Q";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getQs() != null) {
                            Double avgQ = 0.0;
                            for (Double q : result.getQs().values()) {
                                avgQ = avgQ + q;
                            }
                            avgQ = avgQ / (double)result.getQs().size();
                            row[col] = avgQ.toString();
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getQPrimes() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average Q'";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getQPrimes() != null) {
                            Double avgQP = 0.0;
                            for (Double qp : result.getQPrimes().values()) {
                                avgQP = avgQP + qp;
                            }
                            avgQP = avgQP / (double)result.getQPrimes().size();
                            row[col] = avgQP.toString();
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getNDCGs() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average nDCG";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getNDCGs() != null) {
                            Double avgNDCG = 0.0;
                            for (Double ndcg : result.getNDCGs().values()) {
                                avgNDCG = avgNDCG + ndcg;
                            }
                            avgNDCG = avgNDCG / (double)result.getNDCGs().size();
                            row[col] = avgNDCG.toString();
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getNDCGPrimes() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average nDCG'";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getNDCGPrimes() != null) {
                            Double avgNDCGP = 0.0;
                            for (Double ndcgp : result.getNDCGPrimes().values()) {
                                avgNDCGP = avgNDCGP + ndcgp;
                            }
                            avgNDCGP = avgNDCGP / (double)result.getNDCGPrimes().size();
                            row[col] = avgNDCGP.toString();
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getQueryResponseTimes() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average query response time";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getQueryResponseTimes() != null) {
                            Double avgQrt = 0.0;
                            for (Long qrt : result.getQueryResponseTimes().values()) {
                                avgQrt = avgQrt + (double)qrt.longValue();
                            }
                            avgQrt = avgQrt / (double)result.getQueryResponseTimes().size();
                            avgQrt = avgQrt / 1000.0;
                            row[col] = String.valueOf(avgQrt.toString()) + " sec";
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getQueryParsingTimes() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average query parsing time";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getQueryParsingTimes() != null) {
                            avgQpt = 0.0;
                            for (Long qpt : result.getQueryParsingTimes().values()) {
                                avgQpt = avgQpt + (double)qpt.longValue();
                            }
                            avgQpt = avgQpt / (double)result.getQueryParsingTimes().size();
                            avgQpt = avgQpt / 1000.0;
                            row[col] = String.valueOf(avgQpt.toString()) + " sec";
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getQueryProcessingTimes() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average query processing time";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getQueryProcessingTimes() != null) {
                            avgQpt = 0.0;
                            for (Long qpt : result.getQueryProcessingTimes().values()) {
                                avgQpt = avgQpt + (double)qpt.longValue();
                            }
                            avgQpt = avgQpt / (double)result.getQueryProcessingTimes().size();
                            avgQpt = avgQpt / 1000.0;
                            row[col] = String.valueOf(avgQpt.toString()) + " sec";
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
            matchmakerEvaluationResultArray2 = results;
            n3 = results.length;
            n4 = 0;
            while (n4 < n3) {
                res = matchmakerEvaluationResultArray2[n4];
                if (res.getQueryMatchingTimes() != null) {
                    row = new Object[results.length + 1];
                    row[0] = "average matching time";
                    col = 1;
                    matchmakerEvaluationResultArray = results;
                    n2 = results.length;
                    n = 0;
                    while (n < n2) {
                        result = matchmakerEvaluationResultArray[n];
                        if (result.getQueryMatchingTimes() != null) {
                            Double avgQmt = 0.0;
                            for (Long qmt : result.getQueryMatchingTimes().values()) {
                                avgQmt = avgQmt + (double)qmt.longValue();
                            }
                            avgQmt = avgQmt / (double)result.getQueryMatchingTimes().size();
                            avgQmt = avgQmt / 1000.0;
                            row[col] = String.valueOf(avgQmt.toString()) + " sec";
                        }
                        ++col;
                        ++n;
                    }
                    this.addRow(row);
                    break;
                }
                ++n4;
            }
        }

        public String toString() {
            return "results";
        }
    }

    private class RankingTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 523487923L;
        private String matchmakerName;

        public RankingTableModel(MatchmakerEvaluationResult result, URI query) {
            this.matchmakerName = result.getMatchmakerName();
            this.addColumn("rank");
            this.addColumn((Object)(String.valueOf(result.getMatchmakerName()) + " for " + query.toString()), result.getRanking(query).toArray());
            int i = 0;
            while (i < result.getRanking(query).size()) {
                this.setValueAt(new Integer(i + 1), i, 0);
                ++i;
            }
        }

        public String toString() {
            return "for " + this.matchmakerName;
        }
    }

    private class ResultsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 32482394384L;
        private String matchmakerName;

        public ResultsTableModel(MatchmakerEvaluationResult result) {
            Double avgQpt;
            this.matchmakerName = result.getMatchmakerName();
            this.addColumn("test");
            this.addColumn("value");
            if (result.getTotalExecutionTime() > -1L) {
                this.addRow(new Object[]{"total execution time", String.valueOf(new Double((double)result.getTotalExecutionTime() / 60000.0).toString()) + " min"});
            }
            if (result.getAPs() != null) {
                Double avgAP = 0.0;
                for (Double ap : result.getAPs().values()) {
                    avgAP = avgAP + ap;
                }
                avgAP = avgAP / (double)result.getAPs().size();
                this.addRow(new Object[]{"average AP", avgAP.toString()});
            }
            if (result.getAverageOffersParsingTime() > -1.0) {
                this.addRow(new Object[]{"average offers parsing time", String.valueOf(new Double(result.getAverageOffersParsingTime()).toString()) + " miliseconds"});
            }
            if (result.getAverageOffersProcessingTime() > -1.0) {
                this.addRow(new Object[]{"average offers processing time", String.valueOf(new Double(result.getAverageOffersProcessingTime()).toString()) + " miliseconds"});
            }
            if (result.getQueryResponseTimes() != null) {
                Double avgQrt = 0.0;
                for (Long qrt : result.getQueryResponseTimes().values()) {
                    avgQrt = avgQrt + (double)qrt.longValue();
                }
                avgQrt = avgQrt / (double)result.getQueryResponseTimes().size();
                avgQrt = avgQrt / 1000.0;
                this.addRow(new Object[]{"average query response time", String.valueOf(avgQrt.toString()) + " sec"});
            }
            if (result.getQueryParsingTimes() != null) {
                avgQpt = 0.0;
                for (Long qpt : result.getQueryParsingTimes().values()) {
                    avgQpt = avgQpt + (double)qpt.longValue();
                }
                avgQpt = avgQpt / (double)result.getQueryParsingTimes().size();
                avgQpt = avgQpt / 1000.0;
                this.addRow(new Object[]{"average query parsing time", String.valueOf(avgQpt.toString()) + " sec"});
            }
            if (result.getQueryProcessingTimes() != null) {
                avgQpt = 0.0;
                for (Long qpt : result.getQueryProcessingTimes().values()) {
                    avgQpt = avgQpt + (double)qpt.longValue();
                }
                avgQpt = avgQpt / (double)result.getQueryProcessingTimes().size();
                avgQpt = avgQpt / 1000.0;
                this.addRow(new Object[]{"average query processing time", String.valueOf(avgQpt.toString()) + " sec"});
            }
            if (result.getQueryMatchingTimes() != null) {
                Double avgQmt = 0.0;
                for (Long qmt : result.getQueryMatchingTimes().values()) {
                    avgQmt = avgQmt + (double)qmt.longValue();
                }
                avgQmt = avgQmt / (double)result.getQueryMatchingTimes().size();
                avgQmt = avgQmt / 1000.0;
                this.addRow(new Object[]{"average matching time", String.valueOf(avgQmt.toString()) + " sec"});
            }
        }

        public String toString() {
            return "for " + this.matchmakerName;
        }
    }
}

