/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.TestCollection;
import java.awt.Color;
import java.net.URI;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class RankingsTable
extends JTable {
    private static final long serialVersionUID = 34893489323232L;
    private URI query;
    private MatchmakerEvaluationResult[] results;
    private TestCollection tc;
    private DefaultTableCellRenderer emptyCellRenderer;
    private DefaultTableCellRenderer tpCellRenderer;
    private DefaultTableCellRenderer fpCellRenderer;
    private double maxGain;

    public RankingsTable(MatchmakerEvaluationResult[] results, URI query, TestCollection tc) {
        this.setModel(new RankingsTableModel(results, query));
        this.query = query;
        this.results = results;
        this.tc = tc;
        this.setAutoResizeMode(0);
        this.setShowGrid(true);
        this.setSelectionMode(0);
        this.setEnabled(false);
        this.setRowSelectionAllowed(false);
        this.setDragEnabled(false);
        this.setName(query.toString());
        this.emptyCellRenderer = new DefaultTableCellRenderer();
        this.emptyCellRenderer.setBackground(Color.LIGHT_GRAY);
        this.tpCellRenderer = new DefaultTableCellRenderer();
        this.tpCellRenderer.setBackground(new Color(100, 255, 100));
        this.tpCellRenderer.setToolTipText("relevant");
        this.fpCellRenderer = new DefaultTableCellRenderer();
        this.fpCellRenderer.setBackground(new Color(255, 100, 100));
        this.fpCellRenderer.setToolTipText("irrelevant");
        this.maxGain = tc.getMaxGain();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        block9: {
            if (column == 0) {
                return super.getCellRenderer(row, column);
            }
            if (this.results[column - 1].getRanking(this.query).size() - 1 < row) {
                return this.emptyCellRenderer;
            }
            if (this.tc.getRelevanceSet(this.query).getNumberOfGradedJudgements() <= 0) {
                try {
                    if (this.tc.getRelevanceSet(this.query).isBinaryRelevant(this.results[column - 1].getRanking(this.query).elementAt(row))) {
                        return this.tpCellRenderer;
                    }
                    if (this.tc.getRelevanceSet(this.query).isBinaryIrrelevant(this.results[column - 1].getRanking(this.query).elementAt(row))) {
                        return this.fpCellRenderer;
                    }
                    break block9;
                }
                catch (Exception e) {
                    return super.getCellRenderer(row, column);
                }
            }
            String grade = this.tc.getRelevanceSet(this.query).getGradeOfRelevance(this.results[column - 1].getRanking(this.query).elementAt(row));
            if (grade.equals("irrelevant")) {
                return this.fpCellRenderer;
            }
            if (grade.equals("unknown")) {
                return super.getCellRenderer(row, column);
            }
            double gain = this.tc.getRelevanceSet(this.query).getGain(grade);
            int add = (int)((1.0 - gain / this.maxGain) * 255.0);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(String.valueOf(grade) + "(" + gain + ")");
            renderer.setBackground(new Color(0 + add, 255 - (255 - add) / 4, 0 + add));
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private class RankingsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 32482394384L;
        private URI query;

        public RankingsTableModel(MatchmakerEvaluationResult[] results, URI query) {
            this.query = query;
            this.addColumn("rank");
            int maxRankingSize = 0;
            MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n2];
                this.addColumn((Object)result.getMatchmakerName(), result.getRanking(query).toArray());
                if (maxRankingSize < result.getRanking(query).size()) {
                    maxRankingSize = result.getRanking(query).size();
                }
                ++n2;
            }
            int i = 0;
            while (i < maxRankingSize) {
                this.setValueAt(new Integer(i + 1), i, 0);
                ++i;
            }
        }

        public String toString() {
            return this.query.toString();
        }
    }
}

