/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.util.metric.FriedmanTest;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class APPrimeChart
extends Chart {
    public APPrimeChart(MatchmakerEvaluationResult[] results) {
        super("Average precision (AP')");
        DefaultCategoryDataset apDataSet = new DefaultCategoryDataset();
        double[] avgAPs = new double[results.length];
        double maxAvg = 0.0;
        int i = 0;
        while (i < results.length) {
            for (Double apValue : results[i].getAPPrimes().values()) {
                int n = i;
                avgAPs[n] = avgAPs[n] + apValue;
            }
            int n = i;
            avgAPs[n] = avgAPs[n] / (double)results[i].getAPPrimes().size();
            if (maxAvg < avgAPs[i]) {
                maxAvg = avgAPs[i];
            }
            ++i;
        }
        double maxValue = 0.0;
        int i2 = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n2];
            int column = 1;
            apDataSet.addValue(avgAPs[i2], (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)"avg"));
            apDataSet.addValue(0.0, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)""));
            for (Double apValue : result.getAPPrimes().values()) {
                apDataSet.addValue((Number)apValue, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)("qry " + column)));
                ++column;
                if (!(apValue > maxValue)) continue;
                maxValue = apValue;
            }
            ++i2;
            ++n2;
        }
        this.chart = ChartFactory.createBarChart((String)this.title, (String)"queries", (String)"average precision (AP')", (CategoryDataset)apDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getCategoryPlot().getDomainAxis().setTickLabelsVisible(false);
        Vector<Vector<Double>> apResults = new Vector<Vector<Double>>();
        MatchmakerEvaluationResult[] column = results;
        int n3 = results.length;
        n = 0;
        while (n < n3) {
            MatchmakerEvaluationResult result = column[n];
            apResults.add(new Vector<Double>(result.getAPPrimes().values()));
            ++n;
        }
        double p = FriedmanTest.test(apResults);
        String annotationText = "Friedman test result: ";
        annotationText = FriedmanTest.isSignificant(p) ? String.valueOf(annotationText) + "there is a " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")" : String.valueOf(annotationText) + "no " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")";
        CategoryTextAnnotation annotation = new CategoryTextAnnotation(annotationText, apDataSet.getColumnKey(apDataSet.getColumnCount() / 2), maxValue + 0.01);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)annotation);
        CategoryPointerAnnotation avgAnn = new CategoryPointerAnnotation("avg", (Comparable)((Object)"avg"), maxAvg, -1.55);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)avgAnn);
    }
}

