/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.TestCollection;
import de.dfki.sme2.gui.chart.APChart;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.gui.chart.F1Chart;
import de.dfki.sme2.gui.chart.QRTChart;
import de.dfki.sme2.gui.chart.RecallFalloutChart;
import de.dfki.sme2.gui.chart.RecallPrecisionChart;
import de.dfki.sme2.util.metric.MacroAvgRecallFallout;
import de.dfki.sme2.util.metric.MacroAvgRecallPrecision;
import de.dfki.sme2.util.metric.SingleQueryMeasures;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ChartComponentFactory {
    public static int LAMBDA = 20;

    private ChartComponentFactory() {
    }

    public static Chart createMacroAveragedRPChart(TestCollection testCollection, String mmName, HashMap<URI, Vector<URI>> mmResults) {
        MacroAvgRecallPrecision rp = new MacroAvgRecallPrecision(LAMBDA);
        for (Map.Entry<URI, Vector<URI>> entry : mmResults.entrySet()) {
            ArrayList<URI> relevantItems = new ArrayList<URI>(testCollection.getRelevanceSet(entry.getKey()).getBinaryRelevants());
            ArrayList retrievals = new ArrayList(entry.getValue());
            rp.processRecallPrecision(retrievals, relevantItems);
        }
        MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[]{new MatchmakerEvaluationResult(mmName, testCollection.getName())};
        results[0].setMacroAvgRP(rp.getMacroAveragePrecisions());
        return new RecallPrecisionChart(results, false);
    }

    public static Chart createMacroAveragedF1Chart(TestCollection testCollection, String mmName, HashMap<URI, Vector<URI>> mmResults) {
        MacroAvgRecallPrecision rp = new MacroAvgRecallPrecision(LAMBDA);
        for (Map.Entry<URI, Vector<URI>> entry : mmResults.entrySet()) {
            ArrayList<URI> relevantItems = new ArrayList<URI>(testCollection.getRelevanceSet(entry.getKey()).getBinaryRelevants());
            ArrayList retrievals = new ArrayList(entry.getValue());
            rp.processRecallPrecision(retrievals, relevantItems);
        }
        MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[]{new MatchmakerEvaluationResult(mmName, testCollection.getName())};
        results[0].setMacroAvgF1(rp.getMacroAveragePrecisions());
        return new F1Chart(results, false);
    }

    public static Chart createMacroAveragedRFChart(TestCollection testCollection, String mmName, HashMap<URI, Vector<URI>> mmResults) {
        MacroAvgRecallFallout rf = new MacroAvgRecallFallout(LAMBDA);
        for (Map.Entry<URI, Vector<URI>> entry : mmResults.entrySet()) {
            ArrayList<URI> relevantItems = new ArrayList<URI>(testCollection.getRelevanceSet(entry.getKey()).getBinaryRelevants());
            ArrayList retrievals = new ArrayList(entry.getValue());
            rf.processRecallFallout(retrievals, relevantItems, testCollection.getNumberOfServiceOffers());
        }
        MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[]{new MatchmakerEvaluationResult(mmName, testCollection.getName())};
        results[0].setMacroAvgRF(rf.getMacroAverageFallouts());
        return new RecallFalloutChart(results, false);
    }

    public static Chart createAPChart(TestCollection testCollection, String mmName, HashMap<URI, Vector<URI>> mmResults) {
        MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[]{new MatchmakerEvaluationResult(mmName, testCollection.getName())};
        for (Map.Entry<URI, Vector<URI>> entry : mmResults.entrySet()) {
            Set<URI> relevantItems = testCollection.getRelevanceSet(entry.getKey()).getBinaryRelevants();
            Vector<URI> retrievals = entry.getValue();
            results[0].addAP(entry.getKey(), SingleQueryMeasures.getAveragePrecision(retrievals, relevantItems));
        }
        return new APChart(results);
    }

    public static Chart createQRTChart(TestCollection testCollection, String mmName, HashMap<URI, Long> qrts) {
        MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[]{new MatchmakerEvaluationResult(mmName, testCollection.getName())};
        for (Map.Entry<URI, Long> entry : qrts.entrySet()) {
            results[0].addQueryResponseTime(entry.getKey(), entry.getValue());
        }
        return new QRTChart(results);
    }
}

