/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class F1Chart
extends Chart {
    public F1Chart(MatchmakerEvaluationResult[] results, boolean microAvg) {
        super("F1");
        this.title = microAvg ? String.valueOf(this.title) + " (micro-averaged)" : String.valueOf(this.title) + " (macro-averaged)";
        XYSeriesCollection dataset = new XYSeriesCollection();
        int lambda = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n2];
            ArrayList<Double> f1Values = microAvg ? result.getMicroAvgF1() : result.getMacroAvgF1();
            lambda = f1Values.size();
            XYSeries series = new XYSeries((Comparable)((Object)result.getMatchmakerName()));
            int i = 1;
            for (Double f1 : f1Values) {
                series.add((double)i++, (Number)f1);
            }
            dataset.addSeries(series);
            ++n2;
        }
        this.chart = ChartFactory.createXYLineChart((String)this.title, (String)"lambda", (String)"f1", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().getDomainAxis().setRange(1.0, (double)lambda);
    }
}

