/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.util.metric.RecallPrecisionPair;
import java.util.ArrayList;
import java.util.Collections;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RecallPrecisionChart
extends Chart {
    public RecallPrecisionChart(MatchmakerEvaluationResult[] results, boolean microAvg) {
        super("Recall/Precision");
        this.title = microAvg ? String.valueOf(this.title) + " (micro-averaged)" : String.valueOf(this.title) + " (macro-averaged)";
        XYSeriesCollection dataset = new XYSeriesCollection();
        int seriesID = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<RecallPrecisionPair> rpPairs;
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n2];
            if (microAvg) {
                rpPairs = result.getMicroAvgRP();
                Collections.sort(rpPairs);
            } else {
                rpPairs = result.getMacroAvgRP();
            }
            XYSeries series = new XYSeries((Comparable)((Object)result.getMatchmakerName()));
            for (RecallPrecisionPair pair : rpPairs) {
                series.add(pair.recall, pair.precision);
            }
            dataset.addSeries(series);
            ++seriesID;
            ++n2;
        }
        this.chart = ChartFactory.createXYLineChart((String)this.title, (String)"recall", (String)"precision", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().getDomainAxis().setRange(0.0, 1.0);
    }
}

