/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class StackedBarQRTChart
extends Chart {
    private long maxAverage;

    public StackedBarQRTChart(MatchmakerEvaluationResult[] results) {
        super("Query response time");
        DefaultCategoryDataset dataset = this.createNewDataset(results);
        this.chart = this.createChart((CategoryDataset)dataset, results);
        this.chart.getCategoryPlot().getDomainAxis().setTickLabelsVisible(false);
    }

    private DefaultCategoryDataset createNewDataset(MatchmakerEvaluationResult[] results) {
        MatchmakerEvaluationResult result;
        DefaultCategoryDataset qrtDataSet = new DefaultCategoryDataset();
        long[] averageParsing = new long[results.length];
        long[] averageProcessing = new long[results.length];
        long[] averageMatching = new long[results.length];
        this.maxAverage = 0L;
        int currentResultCount = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            result = matchmakerEvaluationResultArray[n2];
            averageParsing[currentResultCount] = result.getAverageQueryParsingTime();
            averageProcessing[currentResultCount] = result.getAverageQueryProcessingTime();
            averageMatching[currentResultCount] = result.getAverageQueryMatchingTime();
            ++currentResultCount;
            if (this.maxAverage < result.getAverageQueryResponseTime()) {
                this.maxAverage = result.getAverageQueryResponseTime();
            }
            ++n2;
        }
        currentResultCount = 0;
        matchmakerEvaluationResultArray = results;
        n = results.length;
        n2 = 0;
        while (n2 < n) {
            result = matchmakerEvaluationResultArray[n2];
            int column = 1;
            qrtDataSet.addValue((double)averageParsing[currentResultCount], (Comparable)((Object)("parsing " + result.getMatchmakerName())), (Comparable)((Object)"avg"));
            qrtDataSet.addValue((double)averageProcessing[currentResultCount], (Comparable)((Object)("processing " + result.getMatchmakerName())), (Comparable)((Object)"avg"));
            qrtDataSet.addValue((double)averageMatching[currentResultCount], (Comparable)((Object)("matching " + result.getMatchmakerName())), (Comparable)((Object)"avg"));
            ++currentResultCount;
            for (Long qrtValue : result.getQueryParsingTimes().values()) {
                qrtDataSet.addValue((Number)qrtValue, (Comparable)((Object)("parsing " + result.getMatchmakerName())), (Comparable)((Object)("qry" + column)));
                ++column;
            }
            column = 1;
            for (Long qrtValue : result.getQueryProcessingTimes().values()) {
                qrtDataSet.addValue((Number)qrtValue, (Comparable)((Object)("processing " + result.getMatchmakerName())), (Comparable)((Object)("qry" + column)));
                ++column;
            }
            column = 1;
            for (Long qrtValue : result.getQueryMatchingTimes().values()) {
                qrtDataSet.addValue((Number)qrtValue, (Comparable)((Object)("matching " + result.getMatchmakerName())), (Comparable)((Object)("qry" + column)));
                ++column;
            }
            ++n2;
        }
        return qrtDataSet;
    }

    private JFreeChart createChart(CategoryDataset dataset, MatchmakerEvaluationResult[] results) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"Query response time ", (String)"queries", (String)"miliseconds", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        GroupedStackedBarRenderer renderer = new GroupedStackedBarRenderer();
        KeyToGroupMap map = new KeyToGroupMap((Comparable)((Object)"G1"));
        int count = 1;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n2];
            map.mapKeyToGroup((Comparable)((Object)("parsing " + result.getMatchmakerName())), (Comparable)((Object)("G" + count)));
            map.mapKeyToGroup((Comparable)((Object)("processing " + result.getMatchmakerName())), (Comparable)((Object)("G" + count)));
            map.mapKeyToGroup((Comparable)((Object)("matching " + result.getMatchmakerName())), (Comparable)((Object)("G" + count)));
            ++count;
            ++n2;
        }
        renderer.setSeriesToGroupMap(map);
        renderer.setItemMargin(0.0);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.getRenderer().setSeriesPaint(0, (Paint)new Color(128, 0, 0));
        plot.getRenderer().setSeriesPaint(1, (Paint)new Color(0, 0, 255));
        CategoryPointerAnnotation annotation = new CategoryPointerAnnotation("avg", (Comparable)((Object)"avg"), (double)this.maxAverage, -1.55);
        plot.addAnnotation((CategoryAnnotation)annotation);
        return chart;
    }
}

