/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.TCQualityTestResult;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.util.metric.FriedmanTest;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class TCQualityChart
extends Chart {
    public TCQualityChart(TCQualityTestResult result) {
        super("Test collection quality (seed: " + result.getSeed() + ")");
        DefaultCategoryDataset aapDataSet = new DefaultCategoryDataset();
        double[][] avgAPs = result.getAvgAPs();
        double maxValue = 0.0;
        int i = 0;
        while (i < avgAPs.length) {
            int j = 0;
            while (j < avgAPs[i].length) {
                aapDataSet.addValue(avgAPs[i][j], (Comparable)((Object)result.getMatchmakerName(j)), (Comparable)((Object)new Integer(i + 1).toString()));
                maxValue = Math.max(maxValue, avgAPs[i][j]);
                ++j;
            }
            ++i;
        }
        this.chart = ChartFactory.createBarChart((String)this.title, (String)"folds", (String)"average AP", (CategoryDataset)aapDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        Vector<Vector<Double>> aapResults = new Vector<Vector<Double>>();
        int i2 = 0;
        while (i2 < avgAPs.length) {
            Vector<Double> vec = new Vector<Double>();
            int j = 0;
            while (j < avgAPs[i2].length) {
                vec.add(avgAPs[i2][j]);
                ++j;
            }
            aapResults.add(vec);
            ++i2;
        }
        double p = FriedmanTest.test(aapResults);
        String annotationText = "Friedman test result: ";
        annotationText = FriedmanTest.isSignificant(p) ? String.valueOf(annotationText) + "there is a " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")" : String.valueOf(annotationText) + "no " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")";
        CategoryTextAnnotation annotation = new CategoryTextAnnotation(annotationText, aapDataSet.getColumnKey(aapDataSet.getColumnCount() / 2), maxValue + 0.01);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)annotation);
    }
}

