/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.http;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class HttpServer {
    private Server server = null;
    private long requestTime = 0L;
    private int requests = 0;

    public void start(File htDocs) throws Exception {
        this.server = new Server(80);
        ResourceHandler resourceHandler = new ResourceHandler(){

            public void handle(String arg0, Request arg1, HttpServletRequest arg2, HttpServletResponse arg3) throws IOException, ServletException {
                long startTime = new Date().getTime();
                super.handle(arg0, arg1, arg2, arg3);
                HttpServer httpServer = HttpServer.this;
                httpServer.requestTime = httpServer.requestTime + (new Date().getTime() - startTime);
                HttpServer httpServer2 = HttpServer.this;
                httpServer2.requests = httpServer2.requests + 1;
            }
        };
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setResourceBase(htDocs.toString());
        this.server.setHandler((Handler)resourceHandler);
        this.server.setGracefulShutdown(5000);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public String getState() {
        return this.server.getState();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    public void printStats() {
        System.out.println("requests: " + this.requests);
        System.out.println("requests handling time: " + this.requestTime);
    }

    public void resetStats() {
        this.requestTime = 0L;
        this.requests = 0;
    }

    public int getRequestsStat() {
        return this.requests;
    }

    public long getRequestTimeStat() {
        return this.requestTime;
    }

    public static void main(String[] args) {
        try {
            HttpServer server = new HttpServer();
            server.start(new File("htdocs"));
            while (true) {
                Thread.sleep(5000L);
                server.printStats();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

