/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.util.metric;

import java.util.Vector;

public class FriedmanTest {
    public static double SIGNIFICANCE_THRESHOLD = 0.05;

    public static double test(Vector<Vector<Double>> results) {
        int j;
        int n = results.elementAt(0).size();
        int m = results.size();
        double[][] yij = new double[n][m];
        int i = 0;
        while (i < n) {
            int j2 = 0;
            while (j2 < m) {
                yij[i][j2] = results.elementAt(j2).elementAt(i);
                ++j2;
            }
            ++i;
        }
        double[][] Rij = new double[n][m];
        int i2 = 0;
        while (i2 < n) {
            j = 0;
            while (j < m) {
                Rij[i2][j] = FriedmanTest.computeRank(yij[i2][j], yij[i2]);
                ++j;
            }
            ++i2;
        }
        double[] Rj = new double[m];
        j = 0;
        while (j < m) {
            Rj[j] = 0.0;
            int i3 = 0;
            while (i3 < n) {
                int n2 = j;
                Rj[n2] = Rj[n2] + Rij[i3][j];
                ++i3;
            }
            ++j;
        }
        double A = 0.0;
        int i4 = 0;
        while (i4 < n) {
            int j3 = 0;
            while (j3 < m) {
                A += Rij[i4][j3] * Rij[i4][j3];
                ++j3;
            }
            ++i4;
        }
        double C = (double)(n * m * (m + 1) * (m + 1)) * 0.25;
        double B = 0.0;
        double c = (double)(n * (m + 1)) * 0.5;
        int j4 = 0;
        while (j4 < m) {
            B += (Rj[j4] - c) * (Rj[j4] - c);
            ++j4;
        }
        double T = (double)(m - 1) * B / (A - C);
        double FN = (double)(n - 1) * T / ((double)(n * (m - 1)) - T);
        double p = FriedmanTest.fDistribution(FN, m - 1, (n - 1) * (m - 1));
        System.out.println("F = " + FN + ", df1 = " + (m - 1) + ", df2 = " + (n - 1) * (m - 1));
        return p;
    }

    private static double computeRank(double value, double[] row) {
        int equal = 0;
        int larger = 0;
        int i = 0;
        while (i < row.length) {
            if (row[i] == value) {
                ++equal;
            } else if (row[i] > value) {
                ++larger;
            }
            ++i;
        }
        double rank = 0.0;
        int i2 = 0;
        while (i2 < equal) {
            rank += (double)(larger + i2 + 1);
            ++i2;
        }
        return rank / (double)equal;
    }

    private static double fDistribution(double F, int df1, int df2) {
        double x = (double)df2 / ((double)df1 * F + (double)df2);
        if (df1 % 2 == 0) {
            return FriedmanTest.statCom(1.0 - x, df2, df1 + df2 - 4, df2 - 2) * Math.pow(x, (double)df2 * 0.5);
        }
        if (df2 % 2 == 0) {
            return 1.0 - FriedmanTest.statCom(x, df1, df1 + df2 - 4, df1 - 2) * Math.pow(1.0 - x, (double)df1 * 0.5);
        }
        double th = Math.atan(Math.sqrt((double)df1 * F / (double)df2));
        double a = th / 1.5707963267948966;
        double sth = Math.sin(th);
        double cth = Math.cos(th);
        if (df2 > 1) {
            a += sth * cth * FriedmanTest.statCom(cth * cth, 2, df2 - 3, -1) / 1.5707963267948966;
        }
        if (df1 == 1) {
            return 1.0 - a;
        }
        double c = 4.0 * FriedmanTest.statCom(sth * sth, df2 + 1, df1 + df2 - 4, df2 - 2) * sth * Math.pow(cth, df2) / Math.PI;
        if (df2 == 1) {
            return 1.0 - a + 0.5 * c;
        }
        int k = 2;
        while (k <= (df2 - 1) / 2) {
            c *= (double)k / ((double)k - 0.5);
            ++k;
        }
        return 1.0 - a + c;
    }

    private static double statCom(double q, int i, int j, int b) {
        double zz = 1.0;
        double z = 1.0;
        int k = i;
        while (k <= j) {
            z += (zz *= q * (double)k / (double)(k - b));
            k += 2;
        }
        return z;
    }

    public static boolean isSignificant(double p) {
        return p <= SIGNIFICANCE_THRESHOLD;
    }

    public static void main(String[] args) {
        Vector<Vector<Double>> results = new Vector<Vector<Double>>();
        Vector<Double> result = new Vector<Double>();
        result.add(new Double(0.4));
        result.add(new Double(0.5658631340820883));
        result.add(new Double(0.4131057257017636));
        result.add(new Double(0.24603174603174605));
        result.add(new Double(0.5));
        result.add(new Double(0.31898842464399524));
        result.add(new Double(0.10945839874411302));
        result.add(new Double(0.22142857142857145));
        result.add(new Double(0.3357460049410514));
        result.add(new Double(0.0));
        result.add(new Double(0.3));
        result.add(new Double(0.4117448839039748));
        result.add(new Double(0.3431648212898213));
        result.add(new Double(0.6174698133113161));
        result.add(new Double(0.3256313131313131));
        result.add(new Double(0.478698243127776));
        result.add(new Double(0.410935441370224));
        result.add(new Double(0.047619047619047616));
        result.add(new Double(0.43083003952569165));
        result.add(new Double(0.11398011311804417));
        result.add(new Double(0.26282051282051283));
        result.add(new Double(0.22861260901121583));
        result.add(new Double(0.22459657776153938));
        result.add(new Double(0.21621621621621623));
        result.add(new Double(0.26290980540980535));
        results.add(result);
        result = new Vector();
        result.add(new Double(0.6217676767676767));
        result.add(new Double(0.6846516176366537));
        result.add(new Double(0.5128763480019656));
        result.add(new Double(0.3074006065447353));
        result.add(new Double(0.5015350877192982));
        result.add(new Double(0.2787794338683347));
        result.add(new Double(0.28479102687581925));
        result.add(new Double(0.3355356476297126));
        result.add(new Double(0.49199387435604275));
        result.add(new Double(0.536497870906473));
        result.add(new Double(0.55));
        result.add(new Double(0.5790442488434998));
        result.add(new Double(0.4685018310937428));
        result.add(new Double(0.744857606517935));
        result.add(new Double(0.5476239971748719));
        result.add(new Double(0.5341148441228646));
        result.add(new Double(0.47855525817566447));
        result.add(new Double(0.24394501924825374));
        result.add(new Double(0.505144056409969));
        result.add(new Double(0.2626965150943329));
        result.add(new Double(0.5257607776838545));
        result.add(new Double(0.2524779142426201));
        result.add(new Double(0.5061463052609281));
        result.add(new Double(0.5436851678314922));
        result.add(new Double(0.46717191298103933));
        results.add(result);
        double p = FriedmanTest.test(results);
        System.out.print("SAWSDL-M0 vs. SAWSDL-M3: p = " + p + ", ");
        if (FriedmanTest.isSignificant(p)) {
            System.out.println(", significant!");
        } else {
            System.out.println(", not significant.");
        }
        results = new Vector();
        result = new Vector();
        result.add(new Double(0.156346435786727));
        result.add(new Double(0.40590642005658184));
        result.add(new Double(0.34646915584415583));
        result.add(new Double(0.41867966775332166));
        result.add(new Double(0.2585953534030688));
        result.add(new Double(0.5597794117647059));
        result.add(new Double(0.40423747425605006));
        result.add(new Double(0.6057098076649597));
        result.add(new Double(0.42255966833635183));
        result.add(new Double(0.41025641025641024));
        result.add(new Double(0.22178511592574096));
        result.add(new Double(0.3974908073140268));
        result.add(new Double(0.5263464332587372));
        result.add(new Double(0.16172995663293674));
        result.add(new Double(0.35023636359040083));
        result.add(new Double(0.3044196168169785));
        result.add(new Double(0.17163884700067286));
        result.add(new Double(0.5521177742405364));
        result.add(new Double(0.46132478632478624));
        result.add(new Double(0.211390151135042));
        result.add(new Double(0.5118083807307833));
        result.add(new Double(0.0625));
        result.add(new Double(0.524476525926923));
        result.add(new Double(0.40775496928566435));
        result.add(new Double(0.5898544973544974));
        result.add(new Double(0.0641025641025641));
        results.add(result);
        result = new Vector();
        result.add(new Double(0.17163483769050014));
        result.add(new Double(0.4144791588698802));
        result.add(new Double(0.3320684523809524));
        result.add(new Double(0.4407932617491441));
        result.add(new Double(0.25853149955634425));
        result.add(new Double(0.6));
        result.add(new Double(0.3933189033189033));
        result.add(new Double(0.45953894943971835));
        result.add(new Double(0.4522197269519793));
        result.add(new Double(0.15384615384615385));
        result.add(new Double(0.3125));
        result.add(new Double(0.2763896749707955));
        result.add(new Double(0.5116752737148126));
        result.add(new Double(0.2369030280145287));
        result.add(new Double(0.3016533333474156));
        result.add(new Double(0.4369047619047619));
        result.add(new Double(0.19169700972419595));
        result.add(new Double(0.49431260121241216));
        result.add(new Double(0.37042124542124544));
        result.add(new Double(0.22970443772629495));
        result.add(new Double(0.5271758579030256));
        result.add(new Double(0.0625));
        result.add(new Double(0.5115482642572425));
        result.add(new Double(0.3187819165373826));
        result.add(new Double(0.5185185185185185));
        result.add(new Double(0.0641025641025641));
        results.add(result);
        result = new Vector();
        result.add(new Double(0.21026479432896605));
        result.add(new Double(0.4626779138963356));
        result.add(new Double(0.31294282118913874));
        result.add(new Double(0.39121858642715));
        result.add(new Double(0.24299120642104938));
        result.add(new Double(0.55));
        result.add(new Double(0.45953403078403077));
        result.add(new Double(0.599204415120689));
        result.add(new Double(0.46672153699345353));
        result.add(new Double(0.41025641025641024));
        result.add(new Double(0.010416666666666666));
        result.add(new Double(0.5493457949165238));
        result.add(new Double(0.5496304845954335));
        result.add(new Double(0.21993855162573264));
        result.add(new Double(0.2170583620820935));
        result.add(new Double(0.2709533044553287));
        result.add(new Double(0.31921701486918874));
        result.add(new Double(0.4038450073059817));
        result.add(new Double(0.30692529935950985));
        result.add(new Double(0.3011146257585343));
        result.add(new Double(0.536497870906473));
        result.add(new Double(0.0));
        result.add(new Double(0.5090242000608689));
        result.add(new Double(0.3115112321562817));
        result.add(new Double(0.5275311807094228));
        result.add(new Double(0.0));
        results.add(result);
        result = new Vector();
        result.add(new Double(0.17392096716020566));
        result.add(new Double(0.40906095441168216));
        result.add(new Double(0.3246212017318684));
        result.add(new Double(0.49281847781847776));
        result.add(new Double(0.24724902212888408));
        result.add(new Double(0.553172084623323));
        result.add(new Double(0.4584233646302611));
        result.add(new Double(0.6509644567400726));
        result.add(new Double(0.42646214132614785));
        result.add(new Double(0.41025641025641024));
        result.add(new Double(0.22178511592574096));
        result.add(new Double(0.5344404975389423));
        result.add(new Double(0.5415850570053514));
        result.add(new Double(0.22616939471953698));
        result.add(new Double(0.32505435345396466));
        result.add(new Double(0.2887833181311442));
        result.add(new Double(0.17069473519328243));
        result.add(new Double(0.559274738457016));
        result.add(new Double(0.264725614586001));
        result.add(new Double(0.24937874057480217));
        result.add(new Double(0.5274934632764217));
        result.add(new Double(0.0625));
        result.add(new Double(0.5141961968261357));
        result.add(new Double(0.38429913233459007));
        result.add(new Double(0.5472759745030732));
        result.add(new Double(0.0));
        results.add(result);
        p = FriedmanTest.test(results);
        System.out.print("syntactic variants: p = " + p + ", ");
        if (FriedmanTest.isSignificant(p)) {
            System.out.println(", significant!");
        } else {
            System.out.println(", not significant.");
        }
    }
}

