/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.util.metric;

import de.dfki.sme2.util.metric.RecallFalloutPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MacroAvgRecallFallout {
    public final int LEMDA_LEVELS;
    private double[] recall_levels;
    private double[] fallouts;
    private int numOfQueries = 0;

    public MacroAvgRecallFallout(int lambda) {
        this.LEMDA_LEVELS = lambda;
        this.recall_levels = new double[lambda];
        int i = 0;
        while (i < lambda) {
            this.recall_levels[i] = (double)i / (double)(lambda - 1);
            ++i;
        }
        this.fallouts = new double[lambda];
        i = 0;
        while (i < lambda) {
            this.fallouts[i] = 0.0;
            ++i;
        }
    }

    public void processRecallFallout(List retrievals, ArrayList correctRetrievals, int numOfDocs) {
        ++this.numOfQueries;
        ArrayList<RecallFalloutPair> RFs = new ArrayList<RecallFalloutPair>();
        Vector<Double> retrieved = new Vector<Double>();
        Vector<Double> retrievedRelevant = new Vector<Double>();
        int goodRetrievals = 0;
        int badRetrievals = 0;
        int i = 0;
        while (i < retrievals.size()) {
            int numRetrieved = i + 1;
            if (correctRetrievals.contains(retrievals.get(i))) {
                retrievedRelevant.add(new Double(++goodRetrievals));
                retrieved.add(new Double(numRetrieved));
                double recall = (double)goodRetrievals / (double)correctRetrievals.size();
                double fallout = (double)badRetrievals / (double)(numOfDocs - correctRetrievals.size());
                RFs.add(new RecallFalloutPair(recall, fallout));
            } else {
                ++badRetrievals;
            }
            ++i;
        }
        double[] interpolatedFs = this.interpolate(RFs);
        int i2 = 0;
        while (i2 < this.LEMDA_LEVELS) {
            int n = i2;
            this.fallouts[n] = this.fallouts[n] + interpolatedFs[i2];
            ++i2;
        }
    }

    public ArrayList<RecallFalloutPair> getMacroAverageFallouts() {
        ArrayList<RecallFalloutPair> rfList = new ArrayList<RecallFalloutPair>();
        int i = 0;
        while (i < this.LEMDA_LEVELS) {
            rfList.add(new RecallFalloutPair(this.recall_levels[i], this.fallouts[i] / (double)this.numOfQueries));
            ++i;
        }
        return rfList;
    }

    private double[] interpolate(ArrayList<RecallFalloutPair> rfPairs) {
        double[] fallouts = new double[this.LEMDA_LEVELS];
        int i = 0;
        while (i < this.LEMDA_LEVELS) {
            double maxFallout = 0.0;
            for (RecallFalloutPair rfPair : rfPairs) {
                if (!(rfPair.recall <= this.recall_levels[i]) || !(rfPair.fallout > maxFallout)) continue;
                maxFallout = rfPair.fallout;
            }
            fallouts[i] = maxFallout;
            ++i;
        }
        return fallouts;
    }
}

