/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.DefaultProcessMonitor;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.execution.ProcessMonitor;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;

public class ExecutionMonitor {
    public static void main(String[] args) throws Exception {
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        exec.addMonitor(new CustomProcessMonitor());
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        Service service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/FrenchDictionary.owl");
        Process process = service.getProcess();
        ValueMap values = new ValueMap();
        values.setDataValue(process.getInput("InputString"), "mere");
        values = exec.execute(process, values);
    }

    public static class CustomProcessMonitor
    extends DefaultProcessMonitor
    implements ProcessMonitor {
        JTextArea textArea;
        JButton execButton;

        public CustomProcessMonitor() {
            this.setMonitorFilter(1);
            JFrame info = new JFrame("Execution results");
            this.textArea = new JTextArea(15, 40);
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.execButton = new JButton("Continue");
            this.execButton.setEnabled(false);
            this.execButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CustomProcessMonitor.this.execButton.setEnabled(false);
                }
            });
            this.print("Initializing...");
            info.setDefaultCloseOperation(3);
            info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
            info.getContentPane().add(new JScrollPane(this.textArea));
            info.getContentPane().add(this.execButton);
            this.execButton.setAlignmentX(0.5f);
            info.pack();
            info.setVisible(true);
        }

        private void print(String msg) {
            this.textArea.append(msg);
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }

        private void println(String msg) {
            this.textArea.append(msg + "\n");
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }

        private void println() {
            this.textArea.append("\n");
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }

        public void executionStarted() {
            this.println("done.");
            this.println();
        }

        public void executionFinished() {
            this.println();
            this.println("No more processes to execute, execution finished succesfully!");
            this.println();
        }

        public void executionStarted(Process process, ValueMap inputs) {
            this.println("Process: " + process);
            this.println("Inputs: ");
            Iterator i = process.getInputs().iterator();
            while (i.hasNext()) {
                Input input = (Input)i.next();
                this.print(input.getLabel() + " =  ");
                OWLValue value = inputs.getValue(input);
                if (value.isDataValue()) {
                    this.println(value.toString());
                    continue;
                }
                OWLIndividual ind = (OWLIndividual)value;
                if (ind.isAnon()) {
                    this.println(ind.toRDF(false));
                    continue;
                }
                this.println(value.toString());
            }
            this.println();
            this.println("Click 'Continue' to execute");
            this.execButton.setEnabled(true);
            while (this.execButton.isEnabled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.println();
            this.print("Executing...");
        }

        public void executionFinished(Process process, ValueMap inputs, ValueMap outputs) {
            this.println("done.");
            this.println();
            this.println("Outputs: ");
            Iterator i = process.getOutputs().iterator();
            while (i.hasNext()) {
                Output output = (Output)i.next();
                this.print(output.getLabel() + " =  ");
                OWLValue value = outputs.getValue(output);
                if (value.isDataValue()) {
                    this.println(value.toString());
                    continue;
                }
                OWLIndividual ind = (OWLIndividual)value;
                if (ind.isAnon()) {
                    this.println(ind.toRDF(false));
                    continue;
                }
                this.println(value.toString());
            }
            this.println();
            this.println("Click 'Continue' to go to next process execution");
            this.execButton.setEnabled(true);
            while (this.execButton.isEnabled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.println();
        }

        public void executionFailed(ExecutionException e) {
            this.println();
            this.println("Execution failed: ");
            this.println(e.toString());
            e.printStackTrace();
        }
    }
}

