/*
 * Decompiled with CFR 0.152.
 */
package examples;

import impl.owl.WrappedIndividual;
import impl.owls.profile.ProfileImpl;
import java.util.Iterator;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.OWLS_1_1;

public class OWLSExtensions {
    public static void main(String[] args) throws Exception {
        OWLConfig.addConverter(OwnerEntity.class, new OwnerConverter());
        OWLConfig.addConverter(Profile.class, new ExtendedProfileConverter());
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        Service s = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/Dictionary.owl");
        ExtendedProfile profile = (ExtendedProfile)s.getProfile();
        OwnerEntity owner = profile.getOwner();
        System.out.println("Service name: " + profile.getServiceName());
        System.out.println();
        System.out.println("Display service parameters using generic functions");
        System.out.println("--------------------------------------------------");
        OWLIndividualList params = profile.getServiceParameters();
        Iterator i = params.iterator();
        while (i.hasNext()) {
            ServiceParameter param = (ServiceParameter)i.next();
            System.out.println("Service Parameter: ");
            System.out.println("  Name  : " + param.getName());
            System.out.println("  Value : " + param.getParameter());
        }
        System.out.println();
        System.out.println("Display service parameters using custom functions");
        System.out.println("-------------------------------------------------");
        System.out.println("Owner: ");
        System.out.println("  Name : " + owner.getLabel());
        System.out.println("  ID   : " + owner.getEntityID());
    }

    public static class ExtendedProfileConverter
    implements OWLObjectConverter {
        public boolean canCast(OWLObject object) {
            return object instanceof OWLIndividual && ((OWLIndividual)object).isType(OWLS_1_1.Profile.Profile);
        }

        public OWLObject cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be cast to Profile class");
            }
            return new ExtendedProfile((OWLIndividual)object);
        }

        public OWLObject convert(OWLObject object) {
            if (!this.canCast(object)) {
                ((OWLIndividual)object).addType(OWLS_1_1.Profile.Profile);
            }
            return this.cast(object);
        }
    }

    public static class OwnerConverter
    implements OWLObjectConverter {
        public boolean canCast(OWLObject object) {
            return object instanceof OWLIndividual && ((OWLIndividual)object).isType(FLAServiceOnt.OwnerEntity);
        }

        public OWLObject cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be cast to Actor class");
            }
            return new OwnerEntity((OWLIndividual)object);
        }
    }

    public static class OwnerEntity
    extends WrappedIndividual {
        public OwnerEntity(OWLIndividual ind) {
            super(ind);
        }

        public String getEntityID() {
            return this.getPropertyAsString(FLAServiceOnt.ownerEntityID);
        }
    }

    public static class ExtendedProfile
    extends ProfileImpl {
        public ExtendedProfile(OWLIndividual ind) {
            super(ind);
        }

        public OwnerEntity getOwner() {
            OWLIndividual ind = this.getServiceParameterValue(FLAServiceOnt.ownedBy);
            return ind == null ? null : (OwnerEntity)ind.castTo(class$examples$OWLSExtensions$OwnerEntity == null ? (class$examples$OWLSExtensions$OwnerEntity = OWLSExtensions.class$("examples.OWLSExtensions$OwnerEntity")) : class$examples$OWLSExtensions$OwnerEntity);
        }
    }
}

