/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.OutputFormatter;

public class OWLSValidator {
    boolean parseRDFFinished = false;
    List serviceURIs = new ArrayList();
    List errors = new ArrayList();
    List warnings = new ArrayList();
    List rdfProblems = new ArrayList();

    public boolean validate(String fileURI) throws Exception {
        return this.validate(fileURI, new PrintWriter(System.out));
    }

    public boolean validate(String fileURI, PrintWriter output) throws Exception {
        return this.validate(fileURI, output, false);
    }

    public boolean validate(String fileURI, PrintWriter output, boolean isHTML) throws Exception {
        return this.validate(fileURI, new OutputFormatter(output, isHTML));
    }

    public boolean validate(String fileURI, OutputFormatter out) throws Exception {
        URI uri = new URI(fileURI);
        OWLKnowledgeBase kb = OWLFactory.createKB();
        OWLOntology ont = kb.read(uri);
        ArrayList services = new ArrayList();
        out.printBold("Number of services found: ").println(ont.getServices().size() + "");
        out.printBold("Number of valid services: ").println(services.size() + "");
        out.println();
        this.printMesssages(out, "RDF Problems: ", this.rdfProblems.iterator());
        this.printMesssages(out, "Errors: ", this.errors.iterator());
        this.printMesssages(out, "Warnings: ", this.warnings.iterator());
        if (services != null) {
            for (int i = 0; i < services.size(); ++i) {
                Service service = (Service)services.get(i);
                out.printBold("Service: ").printLink(service.getURI().toString());
                out.printBold("Name: ").println(service.getLabel());
                out.printBold("Description: ").println(service.getProfile().getTextDescription());
            }
        }
        out.flush();
        return true;
    }

    public void printMesssages(OutputFormatter out, String header, Iterator i) {
        if (i.hasNext()) {
            out.printBold(header).println();
            while (i.hasNext()) {
                String error = (String)i.next();
                if (out.isFormatHTML()) {
                    out.print("<ul>");
                }
                if (out.isFormatHTML()) {
                    out.print("<li>");
                    out.print(this.format(error));
                    out.print("</li>");
                } else {
                    out.println(error);
                }
                if (!out.isFormatHTML()) continue;
                out.print("</ul>");
            }
            out.println();
        }
    }

    public String format(String str) {
        return str;
    }

    public String getServiceURI() {
        return (String)this.serviceURIs.get(this.serviceURIs.size() - 1);
    }

    public void put(Map table, String key, String value) {
        ArrayList<String> list = (ArrayList<String>)table.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            table.put(key, list);
        }
        list.add(value);
    }

    public void startService(String serviceURI) {
        this.serviceURIs.add(serviceURI);
    }

    public void finishService(String serviceURI) {
    }

    public void warning(String msg) {
        if (this.parseRDFFinished) {
            this.warnings.add(msg);
        } else {
            this.rdfProblems.add(msg);
        }
    }

    public void error(String msg) {
        if (this.parseRDFFinished) {
            this.errors.add(msg);
        } else {
            this.rdfProblems.add(msg);
        }
    }

    public void startParseRDF() {
        this.parseRDFFinished = false;
    }

    public void finishParseRDF() {
        this.parseRDFFinished = true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            if (args.length < 1) {
                System.err.println("Not enough parameters");
            }
            if (args.length > 1) {
                System.err.println("Too many parameters");
            }
            System.err.println("usage: java OWLSValidator <serviceURI>");
            System.exit(0);
        }
        OWLSValidator validator = new OWLSValidator();
        System.out.println("Valid: " + validator.validate(args[0]));
    }
}

