/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.util.Iterator;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceCategory;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;

public class ServiceParameterExample {
    static OWLKnowledgeBase kb = OWLFactory.createKB();

    public static void main(String[] args) throws Exception {
        System.out.print("Reading service...");
        Service service = kb.readService("http://www.daml.org/services/owl-s/1.1/BravoAirService.owl");
        System.out.println("done");
        ServiceParameterExample.printProfileInfo(service, null);
        ServiceParameterExample.printProfileInfo(service, "RDFS");
        ServiceParameterExample.printProfileInfo(service, "Pellet");
        OWLConfig.setStrictConversion(false);
        ServiceParameterExample.printProfileInfo(service, null);
    }

    public static void printProfileInfo(Service s, String reasoner) {
        try {
            String name = reasoner == null ? "no" : reasoner;
            System.out.println("===================================");
            System.out.println("Results using " + name + " reasoner");
            System.out.println("Strict type checking: " + OWLConfig.getStrictConversion());
            System.out.println("===================================");
            kb.setReasoner(reasoner);
            Profile profile = s.getProfile();
            System.out.println("Service name: " + profile.getServiceName());
            System.out.println();
            System.out.println("Display service parameters");
            System.out.println("--------------------------");
            OWLIndividualList params = profile.getServiceParameters();
            Iterator i = params.iterator();
            while (i.hasNext()) {
                ServiceParameter param = (ServiceParameter)i.next();
                System.out.println("Service Parameter: ");
                System.out.println("  Name  : " + ServiceParameterExample.trimString(param.getName()));
                System.out.println("  Value : " + param.getParameter());
            }
            System.out.println();
            System.out.println("Display service categories");
            System.out.println("--------------------------");
            OWLIndividualList categories = profile.getCategories();
            Iterator i2 = categories.iterator();
            while (i2.hasNext()) {
                ServiceCategory category = (ServiceCategory)i2.next();
                System.out.println("Service Category: ");
                System.out.println("  Name  : " + ServiceParameterExample.trimString(category.getName()));
                System.out.println("  Code : " + ServiceParameterExample.trimString(category.getCode()));
                System.out.println("  Taxonomy : " + ServiceParameterExample.trimString(category.getTaxonomy()));
                System.out.println("  Value : " + ServiceParameterExample.trimString(category.getValue()));
            }
        }
        catch (RuntimeException e) {
            System.out.println("The following error occurred: ");
            System.out.println(e);
        }
        System.out.println();
    }

    public static String trimString(String str) {
        return str == null ? "<null>" : str.trim();
    }
}

