/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.OWLSValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import org.mindswap.owl.vocabulary.OWL;
import org.mindswap.utils.QNameProvider;
import org.mindswap.utils.SwingUtils;
import org.mindswap.utils.URIUtils;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;
import org.mindswap.wsdl.WSDLTranslator;

public class WSDL2OWLS
extends JPanel
implements ActionListener {
    final String[] nsColumnNames = new String[]{"Abbr", "URI"};
    final String[] columnNames = new String[]{"WSDL Parameter", "WSDL Type", "OWL-S Name", "OWL Type", "XSLT"};
    final String[][] emptyRow = new String[0][5];
    final String[] defaultFiles = new String[]{"http://www.swanandmokashi.com/HomePage/WebServices/StockQuotes.asmx?WSDL", "http://www.xmethods.net/sd/2001/BNQuoteService.wsdl", "http://www.mindswap.org/services/AddressPhotoService.wsdl", "http://www.mindswap.org/2002/services/BabelFishTranslator.wsdl", "http://www.tinetics.com/webservices/get_states.cfc?wsdl", "http://www.webservicex.net/uszip.asmx?WSDL", "http://www.mindswap.org/2002/services/Dictionary.wsdl"};
    JComboBox urls = new JComboBox<String>(this.defaultFiles);
    JList opList = new JList();
    JTable inputTable = new JTable(this.emptyRow, this.columnNames);
    JTable outputTable = new JTable(this.emptyRow, this.columnNames);
    JTextField nameSpaceField = new JTextField();
    JTextField serviceNameField = new JTextField();
    JTextArea textDescription = new JTextArea(10, 20);
    JTable nsTable = new JTable(0, 2);
    JButton generateButton;
    JButton addNSButton;
    JButton removeNSButton;
    JDialog advanced;
    JRadioButton prefixButton;
    JRadioButton manualButton;
    JTextField prefixText = new JTextField();
    JTextField serviceText = new JTextField();
    JTextField profileText = new JTextField();
    JTextField processText = new JTextField();
    JTextField groundingText = new JTextField();
    QNameProvider qnames = new QNameProvider();

    public WSDL2OWLS() {
        JPanel contentPane = new JPanel();
        JPanel addressPanel = new JPanel();
        JPanel middlePanel = new JPanel();
        JPanel operationsPanel = new JPanel();
        JPanel detailsPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        this.setLayout(new GridLayout(1, 1));
        this.add(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        contentPane.add(addressPanel);
        contentPane.add(Box.createVerticalStrut(2));
        contentPane.add(middlePanel);
        contentPane.add(Box.createVerticalStrut(2));
        contentPane.add(buttonPanel);
        JButton browseButton = new JButton("Browse Local...");
        browseButton.setActionCommand("browse");
        browseButton.addActionListener(this);
        addressPanel.setLayout(new BoxLayout(addressPanel, 0));
        addressPanel.add(new JLabel("Enter URL: "));
        addressPanel.add(Box.createHorizontalStrut(2));
        addressPanel.add(this.urls);
        this.urls.setEditable(true);
        this.urls.setSelectedItem("");
        addressPanel.add(Box.createHorizontalStrut(2));
        addressPanel.add(browseButton);
        addressPanel.add(Box.createHorizontalStrut(2));
        this.urls.setActionCommand("load");
        this.urls.addActionListener(this);
        middlePanel.setLayout(new BoxLayout(middlePanel, 0));
        middlePanel.add(operationsPanel);
        middlePanel.add(detailsPanel);
        operationsPanel.setBorder(BorderFactory.createTitledBorder("Operations"));
        operationsPanel.setLayout(new BoxLayout(operationsPanel, 0));
        operationsPanel.add(new JScrollPane(this.opList));
        this.opList.setSelectionMode(0);
        this.opList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WSDL2OWLS.this.doSelect();
            }
        });
        JPanel servicePanel = new JPanel();
        JPanel inputsPanel = new JPanel();
        JPanel outputsPanel = new JPanel();
        JPanel nsPanel = new JPanel();
        JPanel nsButtons = new JPanel();
        JScrollPane textDescriptionPane = new JScrollPane(this.textDescription);
        textDescriptionPane.setPreferredSize(new Dimension(textDescriptionPane.getPreferredSize().width, 50));
        textDescriptionPane.setMinimumSize(new Dimension(textDescriptionPane.getPreferredSize().width, 50));
        JButton advancedButton = new JButton("Advanced...");
        advancedButton.setActionCommand("advanced");
        advancedButton.addActionListener(this);
        servicePanel = this.createTableLayout(new JComponent[]{new JLabel("Service Name"), new JLabel("Text description"), new JLabel("Logical URI")}, new JComponent[]{this.serviceNameField, textDescriptionPane, this.nameSpaceField});
        servicePanel.setBorder(BorderFactory.createTitledBorder("Service information"));
        this.textDescription.setLineWrap(true);
        this.textDescription.setWrapStyleWord(true);
        this.nsTable.getSelectionModel().setSelectionMode(0);
        this.nsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WSDL2OWLS.this.removeNSButton.setEnabled(true);
            }
        });
        this.addNSButton = new JButton("Add");
        this.removeNSButton = new JButton("Remove");
        this.addNSButton.setActionCommand("addNS");
        this.addNSButton.addActionListener(this);
        this.removeNSButton.setActionCommand("removeNS");
        this.removeNSButton.addActionListener(this);
        nsButtons.setLayout(new BoxLayout(nsButtons, 0));
        nsButtons.add(Box.createHorizontalGlue());
        nsButtons.add(this.addNSButton);
        nsButtons.add(Box.createHorizontalStrut(5));
        nsButtons.add(this.removeNSButton);
        nsPanel.setLayout(new BoxLayout(nsPanel, 1));
        nsPanel.setBorder(BorderFactory.createTitledBorder("Namespaces"));
        nsPanel.add(new JScrollPane(this.nsTable));
        nsPanel.add(Box.createVerticalStrut(2));
        nsPanel.add(nsButtons);
        inputsPanel.setLayout(new BoxLayout(inputsPanel, 1));
        inputsPanel.setBorder(BorderFactory.createTitledBorder("Inputs"));
        inputsPanel.add(new JScrollPane(this.inputTable));
        outputsPanel.setLayout(new BoxLayout(outputsPanel, 1));
        outputsPanel.setBorder(BorderFactory.createTitledBorder("Outputs"));
        outputsPanel.add(new JScrollPane(this.outputTable));
        this.generateButton = new JButton("Generate OWL-S");
        this.generateButton.setEnabled(false);
        this.generateButton.setActionCommand("generate");
        this.generateButton.addActionListener(this);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.generateButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(closeButton);
        detailsPanel.setLayout(new BoxLayout(detailsPanel, 1));
        detailsPanel.add(servicePanel);
        detailsPanel.add(inputsPanel);
        detailsPanel.add(outputsPanel);
        detailsPanel.add(nsPanel);
        this.qnames.setMapping("soapEnc", "http://schemas.xmlsoap.org/soap/encoding/#");
        this.updateNS();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("browse")) {
            this.doBrowse();
        } else if (e.getActionCommand().equals("load")) {
            this.doLoad();
        } else if (e.getActionCommand().equals("advanced")) {
            this.showAdvanced();
        } else if (e.getActionCommand().equals("addNS")) {
            this.addNS();
        } else if (e.getActionCommand().equals("removeNS")) {
            this.removeNS();
        } else if (e.getActionCommand().equals("generate")) {
            this.doGenerate();
        } else if (e.getActionCommand().equals("close")) {
            System.exit(0);
        } else if (e.getActionCommand().equals("load")) {
            this.doLoad();
        }
    }

    JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        label.setVerticalAlignment(1);
        int labelWidth = 100;
        label.setPreferredSize(new Dimension(labelWidth, label.getPreferredSize().height));
        label.setMaximumSize(new Dimension(labelWidth, label.getMaximumSize().height));
        label.setMinimumSize(new Dimension(labelWidth, label.getMinimumSize().height));
        return label;
    }

    public void addNS() {
        JDialog info = new JDialog((Frame)null, "Add namespace", true);
        JTextField t1 = new JTextField(50);
        JTextField t2 = new JTextField(5);
        JComponent[] labels = new JLabel[]{new JLabel("Enter URL: "), new JLabel("Abbreviation:")};
        JComponent[] textFields = new JComponent[]{t1, t2};
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComponent c = (JComponent)e.getSource();
                Window w = (Window)c.getTopLevelAncestor();
                w.dispose();
            }
        });
        info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
        info.getContentPane().add(this.createTableLayout(labels, textFields));
        info.getContentPane().add(ok);
        ok.setAlignmentX(0.5f);
        info.pack();
        info.setResizable(false);
        SwingUtils.centerFrame(info);
        info.show();
        System.out.println(t1.getText() + " " + t2.getText());
        String uri = t1.getText();
        String prefix = t2.getText();
        this.qnames.setMapping(prefix, uri);
        this.updateNS();
    }

    public void removeNS() {
        int row = this.nsTable.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(null, "Please first select an entry, then click remove!", "Error", 0);
            return;
        }
        String prefix = (String)this.nsTable.getModel().getValueAt(row, 0);
        this.qnames.removePrefix(prefix);
        this.updateNS();
    }

    private JPanel createTableLayout(JComponent[] labels, JComponent[] textFields) {
        JPanel textControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        textControlsPane.setLayout(gridbag);
        c.anchor = 17;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            c.insets = new Insets(2, 2, 2, 2);
            gridbag.setConstraints(labels[i], c);
            textControlsPane.add(labels[i]);
            c.gridwidth = 0;
            if (i == numLabels - 1) {
                c.gridheight = 0;
            }
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 2, 2, 2);
            gridbag.setConstraints(textFields[i], c);
            textControlsPane.add(textFields[i]);
        }
        return textControlsPane;
    }

    void doLoad() {
        final String url = this.urls.getSelectedItem().toString().replaceAll(" ", "%20");
        try {
            WSDLService s = WSDLService.createService(url);
            List ops = s.getOperations();
            this.opList.setListData(ops.toArray());
        }
        catch (Exception e) {
            this.opList.setListData(new Vector());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, "Cannot load service description from file\n " + url + "\n" + e, "Error", 0);
                }
            });
        }
    }

    void doBrowse() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, file.getAbsolutePath() + "does not exist!", "Error", 0);
        } else {
            try {
                this.urls.setSelectedItem(file.toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                JOptionPane.showMessageDialog(null, "Not a valid file path " + file.getAbsolutePath() + "\n" + e, "Error", 0);
            }
        }
    }

    void doSelect() {
        WSDLOperation op = (WSDLOperation)this.opList.getSelectedValue();
        if (op == null) {
            this.nameSpaceField.setText("");
            this.serviceNameField.setText("");
            this.textDescription.setText("");
            this.addParams(new Vector(), this.inputTable);
            this.addParams(new Vector(), this.outputTable);
            this.generateButton.setEnabled(false);
        } else {
            this.nameSpaceField.setText("http://www.example.org/service.owl");
            this.serviceNameField.setText(op.getName());
            if (op.getDocumentation() == null) {
                this.textDescription.setText("Auto generated from " + op.getService().getFileURI());
            } else {
                this.textDescription.setText(op.getDocumentation());
            }
            this.textDescription.setCaretPosition(0);
            this.addParams(op.getInputs(), this.inputTable);
            this.addParams(op.getOutputs(), this.outputTable);
            this.generateButton.setEnabled(true);
        }
        this.updateNS();
    }

    void prepareAdvanced() {
        this.advanced = new JDialog((Frame)null, "Advanced Settings", true);
        JPanel localNamePanel = new JPanel();
        this.prefixButton = new JRadioButton("Use a prefix to genearate local names");
        this.prefixButton.setSelected(true);
        this.manualButton = new JRadioButton("Manually enter each local name");
        ButtonGroup group = new ButtonGroup();
        group.add(this.prefixButton);
        group.add(this.manualButton);
        localNamePanel.setBorder(BorderFactory.createTitledBorder("Local name settings for URI's"));
        localNamePanel.setLayout(new BoxLayout(localNamePanel, 1));
        localNamePanel.add(this.prefixButton);
        localNamePanel.add(this.prefixText);
        localNamePanel.add(this.createTableLayout(new JComponent[]{new JLabel("Prefix")}, new JComponent[]{this.prefixText}));
        localNamePanel.add(this.manualButton);
        localNamePanel.add(this.createTableLayout(new JComponent[]{new JLabel("Service"), new JLabel("Profile"), new JLabel("Process"), new JLabel("Grounding")}, new JComponent[]{this.serviceText, this.profileText, this.processText, this.groundingText}));
        JButton okButton = new JButton("Ok");
        JButton cancelButton = new JButton("Cancel");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.advanced.getContentPane().add((Component)localNamePanel, "Center");
        this.advanced.getContentPane().add((Component)buttonPanel, "South");
        this.advanced.pack();
        this.advanced.setResizable(false);
    }

    void showAdvanced() {
        SwingUtils.centerFrame(this.advanced);
        this.advanced.show();
    }

    private void addParams(Vector params, JTable table) {
        DefaultTableModel model = new DefaultTableModel(this.columnNames, 0);
        Iterator i = params.iterator();
        while (i.hasNext()) {
            Object[] row = new String[this.columnNames.length];
            WSDLParameter p = (WSDLParameter)i.next();
            QName paramType = p.getType() == null ? new QName("http://www.w3.org/2001/XMLSchema", "any") : p.getType();
            String wsdlType = paramType.getNamespaceURI() + "#" + paramType.getLocalPart();
            String type = OWL.Thing.toString();
            if (paramType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/") || paramType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !paramType.getLocalPart().equals("any")) {
                type = "http://www.w3.org/2001/XMLSchema#" + paramType.getLocalPart();
            }
            row[0] = URIUtils.getLocalName(p.getName());
            row[1] = this.qnames.shortForm(wsdlType);
            row[2] = row[0];
            row[3] = this.qnames.shortForm(type);
            model.addRow(row);
        }
        table.setModel(model);
    }

    void doGenerate() {
        int option;
        JFileChooser fileChooser = new JFileChooser();
        String serviceName = this.serviceNameField.getText().trim();
        String name = serviceName.replaceAll(" ", " _");
        String fileName = fileChooser.getCurrentDirectory().getAbsolutePath() + File.separator + name + ".owl";
        fileChooser.setSelectedFile(new File(fileName));
        int retVal = fileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file.exists() && (option = JOptionPane.showConfirmDialog(null, file.getAbsolutePath() + " already exists.\n" + "Do you want to replace it?", "Save File", 0, 3)) == 1) {
            return;
        }
        WSDLOperation op = (WSDLOperation)this.opList.getSelectedValue();
        WSDLTranslator t = new WSDLTranslator(op, this.nameSpaceField.getText(), name);
        t.setServiceName(this.serviceNameField.getText());
        t.setTextDescription(this.textDescription.getText());
        TableModel inputs = this.inputTable.getModel();
        for (int i = 0; i < inputs.getRowCount(); ++i) {
            URI paramTypeURI;
            WSDLParameter param = op.getInput(i);
            String paramName = (String)inputs.getValueAt(i, 2);
            String paramType = (String)inputs.getValueAt(i, 3);
            String xsltTransformation = (String)inputs.getValueAt(i, 4);
            try {
                paramType = this.qnames.longForm(paramType);
                paramTypeURI = new URI(paramType);
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                return;
            }
            catch (URISyntaxException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                return;
            }
            t.addInput(param, paramName, paramTypeURI, xsltTransformation);
        }
        TableModel outputs = this.outputTable.getModel();
        for (int i = 0; i < outputs.getRowCount(); ++i) {
            URI paramTypeURI;
            WSDLParameter param = op.getOutput(i);
            String paramName = (String)outputs.getValueAt(i, 2);
            String paramType = (String)outputs.getValueAt(i, 3);
            String xsltTransformation = (String)outputs.getValueAt(i, 4);
            try {
                paramType = this.qnames.longForm(paramType);
                paramTypeURI = new URI(paramType);
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                return;
            }
            catch (URISyntaxException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                return;
            }
            t.addOutput(param, paramName, paramTypeURI, xsltTransformation);
        }
        try {
            t.writeOWLS(new PrintWriter(System.out));
            t.writeOWLS(new FileWriter(fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Cannot create OWL-S file!", "Error", 0);
            return;
        }
        OWLSValidator validator = new OWLSValidator();
        boolean valid = false;
        try {
            valid = validator.validate(file.toURI().toString());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "Saved file " + file.getAbsolutePath() + " is not valid", "Error", 0);
        } else {
            JOptionPane.showMessageDialog(null, "Service " + file.getAbsolutePath() + " was saved succesfully", "Success", 1);
        }
    }

    void updateNS() {
        DefaultTableModel model = new DefaultTableModel(this.nsColumnNames, 0);
        Iterator i = this.qnames.getPrefixSet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = this.qnames.getURI(prefix);
            model.addRow(new String[]{prefix, uri});
        }
        this.nsTable.setModel(model);
        this.nsTable.getColumnModel().getColumn(0).setMaxWidth(75);
    }

    public static void main(String[] args) throws Exception {
        JFrame test = new JFrame("WSDL2OWL-S Converter");
        test.setDefaultCloseOperation(3);
        test.setSize(800, 600);
        SwingUtils.centerFrame(test);
        test.getContentPane().add(new WSDL2OWLS());
        test.show();
    }
}

