/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.DataSource1;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.query.core.QueryEngine;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.expr.E_Equal;
import com.hp.hpl.jena.query.expr.E_GreaterThan;
import com.hp.hpl.jena.query.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.query.expr.E_LessThan;
import com.hp.hpl.jena.query.expr.E_NotEqual;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.owl.OWLObjectImpl;
import impl.owl.XSDDataTypes;
import impl.owl.list.RDFListImpl;
import impl.owls.generic.expression.SWRLExpressionImpl;
import impl.owls.generic.list.OWLSObjListImpl;
import impl.owls.grounding.GroundingImpl;
import impl.owls.grounding.JavaAtomicGroundingImpl;
import impl.owls.grounding.UPnPAtomicGroundingImpl;
import impl.owls.grounding.UPnPMessageMapImpl;
import impl.owls.grounding.WSDLAtomicGroundingImpl;
import impl.owls.grounding.WSDLMessageMapImpl;
import impl.owls.grounding.WSDLOperationRefImpl;
import impl.owls.process.AnyOrderImpl;
import impl.owls.process.AtomicProcessImpl;
import impl.owls.process.ChoiceImpl;
import impl.owls.process.CompositeProcessImpl;
import impl.owls.process.ForEachImpl;
import impl.owls.process.IfThenElseImpl;
import impl.owls.process.InputBindingImpl;
import impl.owls.process.InputImpl;
import impl.owls.process.LocalImpl;
import impl.owls.process.OutputBindingImpl;
import impl.owls.process.OutputImpl;
import impl.owls.process.PerformImpl;
import impl.owls.process.ProduceImpl;
import impl.owls.process.RepeatUntilImpl;
import impl.owls.process.RepeatWhileImpl;
import impl.owls.process.ResultImpl;
import impl.owls.process.SequenceImpl;
import impl.owls.process.SplitImpl;
import impl.owls.process.SplitJoinImpl;
import impl.owls.process.ValueDataImpl;
import impl.owls.process.ValueOfImpl;
import impl.owls.profile.ProfileImpl;
import impl.owls.profile.ServiceParameterImpl;
import impl.owls.service.ServiceImpl;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.exceptions.LockNotSupportedException;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.exceptions.UnboundVariableException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLDataValueList;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.OWLWriter;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owl.list.RDFList;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.OWLSModel;
import org.mindswap.owls.generic.expression.Expression;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLOperationRef;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructBag;
import org.mindswap.owls.process.ControlConstructList;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputBinding;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBinding;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.ValueData;
import org.mindswap.owls.process.ValueOf;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.OWLS;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.owls.vocabulary.OWLetOnt;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SWRLObject;
import org.mindswap.swrl.SameIndividualAtom;
import org.mindswap.swrl.Variable;
import org.mindswap.utils.URIUtils;

public abstract class OWLModelImpl
implements OWLModel,
OWLSModel {
    protected OntModel ontModel;
    private OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
    protected Reasoner reasoner;
    protected OWLOntology baseOntology;
    protected OWLWriter writer;
    public static final List SKIP_PROPS = Arrays.asList(RDF.type, RDFS.subClassOf, ReasonerVocabulary.directSubClassOf, ReasonerVocabulary.directSubPropertyOf, ResourceFactory.createProperty((String)ReasonerRegistry.makeDirect((Node)RDF.type.getNode()).getURI()), OWL.hasValue, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL.maxCardinality, OWL.cardinality);
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public OWLModelImpl(Model model) {
        this.spec.getDocumentManager().setProcessImports(false);
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)this.spec, (Model)model);
    }

    public Object getImplementation() {
        return this.ontModel;
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    public void prepare() {
        this.ontModel.prepare();
    }

    public void classify() {
        if (this.reasoner instanceof PelletReasoner) {
            ((PelletInfGraph)this.ontModel.getGraph()).classify();
        }
    }

    public boolean isClassified() {
        if (this.reasoner instanceof PelletReasoner) {
            return ((PelletInfGraph)this.ontModel.getGraph()).isClassified();
        }
        return true;
    }

    public boolean isConsistent() {
        if (this.reasoner instanceof PelletReasoner) {
            return ((PelletInfGraph)this.ontModel.getGraph()).isConsistent();
        }
        return true;
    }

    public void setBaseOntology(OWLOntology ontology) {
        this.baseOntology = ontology;
    }

    public OWLOntology getBaseOntology() {
        return this.baseOntology;
    }

    public void setReasoner(Reasoner reasoner) {
        this.reasoner = reasoner;
        this.spec.setReasoner(reasoner);
        List subGraphs = this.ontModel.getSubGraphs();
        Model baseModel = this.ontModel.getBaseModel();
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)this.spec, (Model)baseModel);
        Iterator i = subGraphs.iterator();
        while (i.hasNext()) {
            Graph graph = (Graph)i.next();
            Model wrap = ModelFactory.createModelForGraph((Graph)graph);
            this.ontModel.addSubModel(wrap, false);
        }
        this.ontModel.rebind();
    }

    public void setReasoner(String reasonerName) {
        Reasoner reasoner = (Reasoner)OWLFactory.getReasoner(reasonerName);
        if (reasonerName != null && reasoner == null) {
            throw new IllegalArgumentException("Reasoner named " + reasonerName + " is not found!");
        }
        this.setReasoner(reasoner);
    }

    public void setReasoner(Object reasoner) {
        if (!(reasoner instanceof Reasoner) && reasoner != null) {
            throw new IllegalArgumentException("Jena implementation only supports reasoners that implements the " + Reasoner.class);
        }
        this.setReasoner((Reasoner)reasoner);
    }

    public Object getReasoner() {
        return this.reasoner;
    }

    public OWLSObjList createList() {
        ListVocabulary vocabulary = OWLS.ObjList;
        OWLIndividual nil = this.createIndividual(vocabulary.nil().getURI());
        OWLSObjListImpl list = new OWLSObjListImpl(nil);
        list.setVocabulary(vocabulary);
        return list;
    }

    public OWLSObjList createList(OWLIndividual item) {
        OWLSObjList list = this.createList();
        list = (OWLSObjList)list.insert(item);
        return list;
    }

    public OWLSObjList createList(OWLIndividualList items) {
        OWLSObjList list = this.createList();
        for (int i = items.size(); i >= 0; ++i) {
            list = (OWLSObjList)list.insert(items.individualAt(i));
        }
        return list;
    }

    public RDFList createList(ListVocabulary vocabulary) {
        OWLIndividual nil = this.createIndividual(vocabulary.nil().getURI());
        RDFListImpl list = new RDFListImpl(nil);
        list.setVocabulary(vocabulary);
        return list;
    }

    public RDFList createList(ListVocabulary vocabulary, OWLIndividual item) {
        RDFList list = this.createList(vocabulary);
        list = list.insert(item);
        return list;
    }

    public RDFList createList(ListVocabulary vocabulary, OWLIndividualList items) {
        RDFList list = this.createList(vocabulary);
        for (int i = items.size(); i >= 0; ++i) {
            list = list.insert(items.individualAt(i));
        }
        return list;
    }

    protected Resource asResource(URI uri) {
        return this.ontModel.getResource(uri.toString());
    }

    protected boolean containsResource(Resource r) {
        return this.ontModel.containsResource((RDFNode)r);
    }

    protected Property asProperty(URI uri) {
        return this.ontModel.getProperty(uri.toString());
    }

    public OWLType getType(URI uri) {
        OWLType type = this.getDataType(uri);
        if (type == null) {
            type = this.getClass(uri);
        }
        return type;
    }

    public OWLDataType getDataType(URI uri) {
        return XSDDataTypes.getDataType(uri);
    }

    public OWLObject getObject(URI uri) {
        OWLObject entity = null;
        if (entity == null) {
            entity = this.getClass(uri);
        }
        if (entity == null) {
            entity = this.getObjectProperty(uri);
        }
        if (entity == null) {
            entity = this.getDataProperty(uri);
        }
        if (entity == null) {
            entity = this.getDataType(uri);
        }
        if (entity == null) {
            entity = this.getIndividual(uri);
        }
        return entity;
    }

    public OWLEntity getEntity(URI uri) {
        OWLEntity entity = null;
        if (entity == null) {
            entity = this.getClass(uri);
        }
        if (entity == null) {
            entity = this.getObjectProperty(uri);
        }
        if (entity == null) {
            entity = this.getDataProperty(uri);
        }
        if (entity == null) {
            entity = this.getIndividual(uri);
        }
        return entity;
    }

    public OWLClass getClass(URI uri) {
        return this.getClass(this.asResource(uri));
    }

    public OWLClass getClass(Resource res) {
        OWLClass c = null;
        if (res.canAs(OntClass.class)) {
            c = this.wrapClass(res, null);
        }
        return c;
    }

    public OWLIndividual getIndividual(URI uri) {
        Individual res = this.ontModel.getIndividual(uri.toString());
        return res == null ? null : this.wrapIndividual((Resource)res, null);
    }

    public OWLIndividualList getIndividuals() {
        return this.getAllIndividuals((Iterator)this.ontModel.listSubjects(), null);
    }

    public OWLProperty getProperty(URI uri) {
        OWLProperty prop = this.getObjectProperty(uri);
        if (prop == null) {
            prop = this.getDataProperty(uri);
        }
        return prop;
    }

    public OWLObjectProperty getObjectProperty(URI uri) {
        OWLObjectProperty p = null;
        Property prop = this.asProperty(uri);
        if (this.ontModel.contains((Resource)prop, RDF.type, (RDFNode)OWL.ObjectProperty)) {
            p = this.wrapObjectProperty(prop, null);
        }
        return p;
    }

    public OWLDataProperty getDataProperty(URI uri) {
        OWLDataProperty p = null;
        Property prop = this.asProperty(uri);
        if (this.ontModel.contains((Resource)prop, RDF.type, (RDFNode)OWL.DatatypeProperty)) {
            p = this.wrapDataProperty(prop, null);
        }
        return p;
    }

    public boolean isSameAs(OWLIndividual ind1, OWLIndividual ind2) {
        return this.ontModel.contains((Resource)ind1.getImplementation(), OWL.sameAs, (RDFNode)((Resource)ind2.getImplementation()));
    }

    public OWLIndividualList getSameIndividuals(OWLIndividual ind) {
        return this.getAllIndividuals((Iterator)this.ontModel.listSubjectsWithProperty(OWL.sameAs, (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    public boolean isDifferentFrom(OWLIndividual ind1, OWLIndividual ind2) {
        return this.ontModel.contains((Resource)ind1.getImplementation(), OWL.differentFrom, (RDFNode)((Resource)ind2.getImplementation()));
    }

    public OWLIndividualList getDifferentIndividuals(OWLIndividual ind) {
        return this.getAllIndividuals((Iterator)this.ontModel.listSubjectsWithProperty(OWL.differentFrom, (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    public boolean isSubClassOf(OWLClass c1, OWLClass c2) {
        return this.ontModel.contains((Resource)c1.getImplementation(), RDFS.subClassOf, (RDFNode)((Resource)c2.getImplementation()));
    }

    public boolean isDisjoint(OWLClass c1, OWLClass c2) {
        return this.ontModel.contains((Resource)c1.getImplementation(), OWL.disjointWith, (RDFNode)((Resource)c2.getImplementation()));
    }

    public boolean isEquivalent(OWLType t1, OWLType t2) {
        if (t1.equals(t2)) {
            return true;
        }
        if (t1 instanceof OWLClass && t2 instanceof OWLClass) {
            return this.ontModel.contains((Resource)t1.getImplementation(), OWL.equivalentClass, (RDFNode)((Resource)t2.getImplementation()));
        }
        if (t1 instanceof OWLDataType && t2 instanceof OWLDataType) {
            return t1.equals(t2);
        }
        return false;
    }

    public boolean isDisjoint(OWLType t1, OWLType t2) {
        if (t1 instanceof OWLClass && t2 instanceof OWLClass) {
            return this.isDisjoint((OWLClass)t1, (OWLClass)t2);
        }
        if (t1 instanceof OWLDataType && t2 instanceof OWLDataType) {
            return !this.isEquivalent(t1, t2);
        }
        return true;
    }

    public Set getSubClasses(OWLClass c) {
        return this.getSubClasses(c, false);
    }

    public Set getSubClasses(OWLClass c, boolean direct) {
        Property subClassOf = direct ? ReasonerVocabulary.directSubClassOf : RDFS.subClassOf;
        return this.getAllClasses((Iterator)this.ontModel.listSubjectsWithProperty(subClassOf, (RDFNode)((Resource)c.getImplementation())), c.getOntology());
    }

    public Set getSubProperties(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getAllObjectProperties((Iterator)this.ontModel.listSubjectsWithProperty(RDFS.subPropertyOf, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
        }
        return this.getAllDataProperties((Iterator)this.ontModel.listSubjectsWithProperty(RDFS.subPropertyOf, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
    }

    public Set getEquivalentProperties(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getAllObjectProperties((Iterator)this.ontModel.listSubjectsWithProperty(OWL.equivalentClass, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
        }
        return this.getAllDataProperties((Iterator)this.ontModel.listSubjectsWithProperty(OWL.equivalentClass, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
    }

    public Set getSuperProperties(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getAllObjectProperties((Iterator)this.ontModel.listObjectsOfProperty((Resource)p.getImplementation(), RDFS.subPropertyOf), p.getOntology());
        }
        return this.getAllDataProperties((Iterator)this.ontModel.listObjectsOfProperty((Resource)p.getImplementation(), RDFS.subPropertyOf), p.getOntology());
    }

    public Set getSuperClasses(OWLClass c) {
        return this.getSuperClasses(c, false);
    }

    public Set getSuperClasses(OWLClass c, boolean direct) {
        Property subClassOf = direct ? ReasonerVocabulary.directSubClassOf : RDFS.subClassOf;
        return this.getAllClasses((Iterator)this.ontModel.listObjectsOfProperty((Resource)c.getImplementation(), subClassOf), c.getOntology());
    }

    public Set getEquivalentClasses(OWLClass c) {
        return this.getAllClasses((Iterator)this.ontModel.listSubjectsWithProperty(OWL.equivalentClass, (RDFNode)((Resource)c.getImplementation())), c.getOntology());
    }

    public OWLIndividualList getInstances(OWLClass c) {
        return this.getAllIndividuals((Iterator)this.ontModel.listSubjectsWithProperty(RDF.type, (RDFNode)((Resource)c.getImplementation())), c.getOntology());
    }

    public Set getTypes(OWLIndividual ind) {
        return this.getAllClasses((Iterator)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), RDF.type), ind.getOntology());
    }

    public OWLIndividual getProperty(OWLIndividual ind, OWLObjectProperty prop) {
        return this.getFirstIndividual((Iterator)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
    }

    public OWLIndividualList getProperties(OWLIndividual ind, OWLObjectProperty prop) {
        return this.getAllIndividuals((Iterator)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
    }

    public Map getProperties(OWLIndividual ind) {
        HashMap<OWLObjectProperty, OWLIndividualList> result = new HashMap<OWLObjectProperty, OWLIndividualList>();
        StmtIterator i = this.ontModel.listStatements((Resource)ind.getImplementation(), null, (RDFNode)null);
        while (i.hasNext()) {
            List list;
            OWLProperty prop;
            Statement stmt = (Statement)i.next();
            Property pred = stmt.getPredicate();
            if (SKIP_PROPS.contains(pred)) continue;
            RDFNode value = stmt.getObject();
            if (value instanceof Resource) {
                prop = this.baseOntology.createObjectProperty(URI.create(pred.getURI()));
                list = (OWLIndividualList)result.get(prop);
                if (list == null) {
                    list = OWLFactory.createIndividualList();
                    result.put((OWLObjectProperty)prop, (OWLIndividualList)list);
                }
                list.add(this.wrapIndividual(stmt.getResource(), ind.getOntology()));
                continue;
            }
            prop = this.baseOntology.createDataProperty(URI.create(pred.getURI()));
            list = (OWLDataValueList)result.get(prop);
            if (list == null) {
                list = OWLFactory.createDataValueList();
                result.put((OWLObjectProperty)prop, (OWLIndividualList)list);
            }
            list.add(this.wrapDataValue(stmt.getLiteral(), ind.getOntology()));
        }
        return result;
    }

    public OWLDataValue getProperty(OWLIndividual ind, OWLDataProperty prop) {
        OWLDataValue result = null;
        int maxPriority = -1;
        OWLDataValueList list = this.getAllDataValues((Iterator)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
        for (int i = 0; i < list.size(); ++i) {
            OWLDataValue value = list.valueAt(i);
            int priority = OWLConfig.DEFAULT_LANG_LIST.indexOf(value.getLanguage());
            if (priority == 0) {
                return value;
            }
            if (priority <= maxPriority) continue;
            result = value;
            maxPriority = priority;
        }
        return result;
    }

    public OWLDataValue getProperty(OWLIndividual ind, OWLDataProperty prop, String lang) {
        OWLDataValueList list = this.getAllDataValues((Iterator)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
        for (int i = 0; i < list.size(); ++i) {
            OWLDataValue value = list.valueAt(i);
            if (lang != null && !value.getLanguage().equals(lang)) continue;
            return value;
        }
        return null;
    }

    public OWLDataValueList getProperties(OWLIndividual ind, OWLDataProperty prop) {
        return this.getAllDataValues((Iterator)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
    }

    public OWLIndividual getIncomingProperty(OWLObjectProperty prop, OWLIndividual ind) {
        return this.getFirstIndividual((Iterator)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    public OWLIndividualList getIncomingProperties(OWLObjectProperty prop, OWLIndividual ind) {
        return this.getAllIndividuals((Iterator)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    public OWLIndividualList getIncomingProperties(OWLIndividual ind) {
        return this.getAllIndividuals((Iterator)this.ontModel.listStatements(null, null, (RDFNode)((Resource)ind.getImplementation())).mapWith(new Map1(){

            public Object map1(Object o) {
                return ((Statement)o).getSubject();
            }
        }), ind.getOntology());
    }

    public OWLIndividual getIncomingProperty(OWLDataProperty prop, OWLDataValue value) {
        return this.getFirstIndividual((Iterator)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation())), prop.getOntology());
    }

    public OWLIndividualList getIncomingProperties(OWLDataProperty prop, OWLDataValue value) {
        return this.getAllIndividuals((Iterator)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation())), prop.getOntology());
    }

    public boolean hasProperty(OWLIndividual ind, OWLProperty prop) {
        return this.ontModel.contains((Resource)ind.getImplementation(), (Property)prop.getImplementation(), (RDFNode)null);
    }

    public boolean hasProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        return this.ontModel.contains((Resource)ind.getImplementation(), (Property)prop.getImplementation(), (RDFNode)value.getImplementation());
    }

    public OWLClass getType(OWLIndividual ind) {
        Resource res = (Resource)ind.getImplementation();
        res = (Resource)res.inModel((Model)this.ontModel);
        OntResource ontR = (OntResource)res.as(OntResource.class);
        Resource type = ontR.getRDFType(true);
        return type == null ? null : this.wrapClass(type, ind.getOntology());
    }

    public boolean isType(OWLIndividual ind, OWLClass c) {
        return this.ontModel.contains((Resource)ind.getImplementation(), RDF.type, (RDFNode)((Resource)c.getImplementation()));
    }

    public boolean isEnumerated(OWLClass c) {
        return this.ontModel.contains((Resource)c.getImplementation(), OWL.oneOf, (RDFNode)((Resource)null));
    }

    public OWLIndividualList getEnumerations(OWLClass c) {
        Statement stmt = this.ontModel.getProperty((Resource)c.getImplementation(), OWL.oneOf);
        if (stmt == null) {
            return null;
        }
        com.hp.hpl.jena.rdf.model.RDFList oneOf = (com.hp.hpl.jena.rdf.model.RDFList)stmt.getResource().as(com.hp.hpl.jena.rdf.model.RDFList.class);
        return this.getAllIndividuals((Iterator)oneOf.iterator(), c.getOntology());
    }

    private Set getAllObjectProperties(Iterator i, OWLOntology ont) {
        HashSet<OWLObjectProperty> set = new HashSet<OWLObjectProperty>();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            set.add(this.wrapObjectProperty((Property)r.as(class$com$hp$hpl$jena$rdf$model$Property == null ? OWLModelImpl.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property), ont));
        }
        return set;
    }

    private Set getAllDataProperties(Iterator i, OWLOntology ont) {
        HashSet<OWLDataProperty> set = new HashSet<OWLDataProperty>();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            set.add(this.wrapDataProperty((Property)r.as(class$com$hp$hpl$jena$rdf$model$Property == null ? OWLModelImpl.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property), ont));
        }
        return set;
    }

    private Set getAllClasses(Iterator i, OWLOntology ont) {
        HashSet<OWLClass> set = new HashSet<OWLClass>();
        while (i.hasNext()) {
            set.add(this.wrapClass((Resource)i.next(), ont));
        }
        return set;
    }

    private OWLIndividualList getAllIndividuals(Iterator i, OWLOntology ont) {
        OWLIndividualList list = OWLFactory.createIndividualList();
        while (i.hasNext()) {
            RDFNode node = (RDFNode)i.next();
            if (!(node instanceof Resource)) continue;
            list.add(this.wrapIndividual((Resource)node, ont));
        }
        return list;
    }

    private OWLIndividual getFirstIndividual(Iterator i, OWLOntology ont) {
        while (i.hasNext()) {
            RDFNode node = (RDFNode)i.next();
            if (!(node instanceof Resource)) continue;
            return this.wrapIndividual((Resource)node, ont);
        }
        return null;
    }

    private OWLDataValueList getAllDataValues(Iterator i, OWLOntology ont) {
        OWLDataValueList list = OWLFactory.createDataValueList();
        while (i.hasNext()) {
            RDFNode node = (RDFNode)i.next();
            if (!(node instanceof Literal)) continue;
            list.add(this.wrapDataValue((Literal)node, ont));
        }
        return list;
    }

    protected abstract OWLDataValue wrapDataValue(Literal var1, OWLOntology var2);

    protected abstract OWLIndividual wrapIndividual(Resource var1, OWLOntology var2);

    protected abstract OWLClass wrapClass(Resource var1, OWLOntology var2);

    protected abstract OWLObjectProperty wrapObjectProperty(Property var1, OWLOntology var2);

    protected abstract OWLDataProperty wrapDataProperty(Property var1, OWLOntology var2);

    public void apply(AtomList atoms) throws UnboundVariableException {
        AtomList list = atoms;
        while (!list.isEmpty()) {
            OWLValue obj;
            SWRLIndividualObject subj;
            OWLProperty pred;
            Atom propAtom;
            Atom atom = (Atom)list.getFirst();
            for (int i = 0; i < atom.getArgumentCount(); ++i) {
                SWRLObject arg = atom.getArgument(i);
                if (!arg.isVariable()) continue;
                throw new UnboundVariableException((Variable)((Object)arg));
            }
            if (atom instanceof ClassAtom) {
                ClassAtom classAtom = (ClassAtom)atom;
                OWLClass c = classAtom.getClassPredicate();
                SWRLIndividualObject ind = classAtom.getArgument1();
                this.addType(ind, c);
            } else if (atom instanceof IndividualPropertyAtom) {
                propAtom = (IndividualPropertyAtom)atom;
                pred = propAtom.getPropertyPredicate();
                subj = propAtom.getArgument1();
                obj = propAtom.getArgument2();
                this.addProperty((OWLIndividual)subj, (OWLObjectProperty)pred, (OWLIndividual)obj);
            } else if (atom instanceof DataPropertyAtom) {
                propAtom = (DataPropertyAtom)atom;
                pred = propAtom.getPropertyPredicate();
                subj = propAtom.getArgument1();
                obj = (OWLDataValue)((Object)propAtom.getArgument2());
                this.addProperty((OWLIndividual)subj, (OWLDataProperty)pred, (OWLDataValue)obj);
            } else {
                if (atom instanceof SameIndividualAtom) {
                    throw new NotImplementedException();
                }
                if (atom instanceof DifferentIndividualsAtom) {
                    throw new NotImplementedException();
                }
                throw new RuntimeException("Unknown atom type: " + atom);
            }
            list = (AtomList)list.getRest();
        }
    }

    public boolean isTrue(ABoxQuery query) {
        return !this.query(query).isEmpty();
    }

    public boolean isTrue(Condition condition) {
        return this.isTrue(condition.getBody().toQuery());
    }

    public boolean isTrue(Condition condition, ValueMap values) {
        AtomList atoms = condition.getBody();
        if (atoms == null) {
            return true;
        }
        ABoxQuery query = (atoms = atoms.apply(values)).toQuery();
        return !this.query(query).isEmpty();
    }

    private Node makeNode(OWLObject term) {
        if (term instanceof Variable) {
            String varName = ((Variable)term).getLocalName();
            if (varName == null || varName.equals("")) {
                throw new IllegalArgumentException("There is no local name for the variable URI " + ((Variable)term).getURI());
            }
            return Node.createVariable((String)varName);
        }
        return ((RDFNode)term.getImplementation()).asNode();
    }

    public Query makeJenaQuery(AtomList body) {
        ElementGroup group = new ElementGroup();
        ElementConstraints constraints = new ElementConstraints();
        AtomList list = body;
        while (!list.isEmpty()) {
            Atom atom = (Atom)list.getFirst();
            Node s = null;
            Node p = null;
            Node o = null;
            s = this.makeNode(atom.getArgument(0));
            if (atom.getArgumentCount() > 1) {
                o = this.makeNode(atom.getArgument(1));
            }
            if (atom instanceof BuiltinAtom) {
                OWLIndividual builtin = ((BuiltinAtom)atom).getBuiltin();
                NodeVar left = s.isVariable() ? new NodeVar(s.getName()) : NodeValue.makeNode((Node)s);
                NodeVar right = o.isVariable() ? new NodeVar(o.getName()) : NodeValue.makeNode((Node)o);
                E_Equal c = null;
                if (builtin.equals(SWRLB.equal)) {
                    c = new E_Equal((Expr)left, (Expr)right);
                } else if (builtin.equals(SWRLB.notEqual)) {
                    c = new E_NotEqual((Expr)left, (Expr)right);
                } else if (builtin.equals(SWRLB.greaterThan)) {
                    c = new E_GreaterThan((Expr)left, (Expr)right);
                } else if (builtin.equals(SWRLB.greaterThanOrEqual)) {
                    c = new E_GreaterThanOrEqual((Expr)left, (Expr)right);
                } else if (builtin.equals(SWRLB.lessThan)) {
                    c = new E_LessThan((Expr)left, (Expr)right);
                } else if (builtin.equals(SWRLB.lessThanOrEqual)) {
                    c = new E_GreaterThanOrEqual((Expr)left, (Expr)right);
                } else {
                    throw new NotImplementedException();
                }
                constraints.addConstraint((Constraint)c);
            } else {
                if (atom instanceof ClassAtom) {
                    p = RDF.type.asNode();
                    o = this.makeNode(((ClassAtom)atom).getClassPredicate());
                } else if (atom instanceof IndividualPropertyAtom) {
                    p = this.makeNode(((IndividualPropertyAtom)atom).getPropertyPredicate());
                } else if (atom instanceof DataPropertyAtom) {
                    p = this.makeNode(((DataPropertyAtom)atom).getPropertyPredicate());
                } else if (atom instanceof SameIndividualAtom) {
                    p = OWL.sameAs.asNode();
                } else if (atom instanceof DifferentIndividualsAtom) {
                    p = OWL.differentFrom.asNode();
                } else {
                    throw new RuntimeException("Unknown atom type " + atom);
                }
                group.addTriple(Triple.create((Node)s, (Node)p, (Node)o));
            }
            list = (AtomList)list.getRest();
        }
        if (constraints.constraints().hasNext()) {
            group.addElement((QueryElement)constraints);
        }
        Query sparql = new Query();
        sparql.setType(111);
        sparql.setQueryElement((QueryElement)group);
        sparql.setQueryResultStar(true);
        return sparql;
    }

    public List query(String rdql) {
        ABoxQuery query = OWLFactory.createRDQLParser(this).parse(rdql);
        return this.query(query);
    }

    public List query(ABoxQuery query, ValueMap values) {
        ABoxQuery q = query.apply(values);
        return this.query(q);
    }

    public List query(ABoxQuery query) {
        ArrayList<ValueMap> result = new ArrayList<ValueMap>();
        List resultVars = query.getResultVars();
        AtomList atoms = query.getBody();
        Query sparql = this.makeJenaQuery(atoms);
        QueryEngine qe = new QueryEngine(sparql);
        qe.setDataSet((DataSet)new DataSource1((Model)this.ontModel));
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            ResultBinding binding = (ResultBinding)results.next();
            ValueMap map = new ValueMap();
            for (int i = 0; i < resultVars.size(); ++i) {
                Variable var = (Variable)resultVars.get(i);
                String rdqlVar = var.getLocalName();
                RDFNode value = binding.get(rdqlVar);
                if (value == null) continue;
                OWLObjectImpl owlValue = null;
                if (value instanceof Literal) {
                    owlValue = new OWLDataValueImpl((Literal)value);
                } else {
                    Resource resource = (Resource)value;
                    owlValue = new OWLIndividualImpl(this.baseOntology, resource);
                }
                map.setValue(var, (OWLValue)((Object)owlValue));
            }
            result.add(map);
        }
        return result;
    }

    public boolean isSubTypeOf(OWLDataType t1, OWLDataType t2) {
        return t1.equals(t2);
    }

    public boolean isSubTypeOf(OWLType t1, OWLType t2) {
        if (t1 instanceof OWLClass && t2 instanceof OWLClass) {
            return this.isSubClassOf((OWLClass)t1, (OWLClass)t2);
        }
        if (t1 instanceof OWLDataType && t2 instanceof OWLDataType) {
            return this.isSubTypeOf((OWLDataType)t1, (OWLDataType)t2);
        }
        return false;
    }

    public AnyOrder createAnyOrder() {
        return this.createAnyOrder(this.createInstance(OWLS_1_1.Process.AnyOrder));
    }

    public AnyOrder createAnyOrder(URI uri) {
        return this.createAnyOrder(this.createInstance(OWLS_1_1.Process.AnyOrder, uri));
    }

    public AnyOrder createAnyOrder(OWLIndividual ind) {
        return new AnyOrderImpl(ind);
    }

    public AtomicProcess createAtomicProcess() {
        return new AtomicProcessImpl(this.createInstance(OWLS_1_1.Process.AtomicProcess));
    }

    public AtomicProcess createAtomicProcess(URI uri) {
        return new AtomicProcessImpl(this.createInstance(OWLS_1_1.Process.AtomicProcess, uri));
    }

    public AtomicProcess createAtomicProcess(OWLIndividual ind) {
        return new AtomicProcessImpl(ind);
    }

    public Choice createChoice() {
        return this.createChoice(this.createInstance(OWLS_1_1.Process.Choice));
    }

    public Choice createChoice(URI uri) {
        return this.createChoice(this.createInstance(OWLS_1_1.Process.Choice, uri));
    }

    public Choice createChoice(OWLIndividual ind) {
        return new ChoiceImpl(ind);
    }

    public CompositeProcess createCompositeProcess() {
        return this.createCompositeProcess(this.createInstance(OWLS_1_1.Process.CompositeProcess));
    }

    public CompositeProcess createCompositeProcess(URI uri) {
        return this.createCompositeProcess(this.createInstance(OWLS_1_1.Process.CompositeProcess, uri));
    }

    public CompositeProcess createCompositeProcess(OWLIndividual ind) {
        return new CompositeProcessImpl(ind);
    }

    public Condition createSWRLCondition() {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Condition));
    }

    public Condition createSWRLCondition(URI uri) {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Condition, uri));
    }

    public Condition createSWRLCondition(OWLIndividual ind) {
        return new SWRLExpressionImpl(ind);
    }

    public Expression createSWRLExpression() {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Expression));
    }

    public Expression createSWRLExpression(URI uri) {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Expression, uri));
    }

    public Expression createSWRLExpression(OWLIndividual ind) {
        return new SWRLExpressionImpl(ind);
    }

    public ForEach createForEach() {
        return this.createForEach(this.createInstance(OWLS_1_1.Process.ForEach));
    }

    public ForEach createForEach(URI uri) {
        return this.createForEach(this.createInstance(OWLS_1_1.Process.ForEach, uri));
    }

    public ForEach createForEach(OWLIndividual ind) {
        return new ForEachImpl(ind);
    }

    public Grounding createGrounding() {
        return this.createGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlGrounding));
    }

    public Grounding createGrounding(URI uri) {
        return this.createGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlGrounding, uri));
    }

    public Grounding createGrounding(OWLIndividual ind) {
        return new GroundingImpl(ind);
    }

    public IfThenElse createIfThenElse() {
        return new IfThenElseImpl(this.createInstance(OWLS_1_1.Process.IfThenElse));
    }

    public IfThenElse createIfThenElse(URI uri) {
        return new IfThenElseImpl(this.createInstance(OWLS_1_1.Process.IfThenElse, uri));
    }

    public IfThenElse createIfThenElse(OWLIndividual ind) {
        return new IfThenElseImpl(ind);
    }

    public Input createInput() {
        return new InputImpl(this.createInstance(OWLS_1_1.Process.Input));
    }

    public Input createInput(URI uri) {
        return new InputImpl(this.createInstance(OWLS_1_1.Process.Input, uri));
    }

    public Input createInput(OWLIndividual ind) {
        return new InputImpl(ind);
    }

    public InputBinding createInputBinding() {
        return new InputBindingImpl(this.createInstance(OWLS_1_1.Process.InputBinding));
    }

    public InputBinding createInputBinding(URI uri) {
        return new InputBindingImpl(this.createInstance(OWLS_1_1.Process.InputBinding, uri));
    }

    public InputBinding createInputBinding(OWLIndividual ind) {
        return new InputBindingImpl(ind);
    }

    public Local createLocal() {
        return this.createLocal(this.createInstance(OWLS_1_1.Process.Local));
    }

    public Local createLocal(URI uri) {
        return this.createLocal(this.createInstance(OWLS_1_1.Process.Local, uri));
    }

    public Local createLocal(OWLIndividual ind) {
        return new LocalImpl(ind);
    }

    public MessageMap createWSDLMessageMap(OWLIndividual ind) {
        return new WSDLMessageMapImpl(ind);
    }

    public MessageMap createWSDLInputMessageMap() {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlInputMessageMap));
    }

    public MessageMap createWSDLInputMessageMap(URI uri) {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlInputMessageMap, uri));
    }

    public MessageMap createWSDLOutputMessageMap() {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlOutputMessageMap));
    }

    public MessageMap createWSDLOutputMessageMap(URI uri) {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlOutputMessageMap, uri));
    }

    public MessageMap createUPnPMessageMap() {
        return this.createUPnPMessageMap(this.createInstance(FLAServiceOnt.UPnPMap));
    }

    public MessageMap createUPnPMessageMap(URI uri) {
        return this.createUPnPMessageMap(this.createInstance(FLAServiceOnt.UPnPMap, uri));
    }

    public MessageMap createUPnPMessageMap(OWLIndividual ind) {
        return new UPnPMessageMapImpl(ind);
    }

    public Output createOutput() {
        return new OutputImpl(this.createInstance(OWLS_1_1.Process.Output));
    }

    public Output createOutput(URI uri) {
        return new OutputImpl(this.createInstance(OWLS_1_1.Process.Output, uri));
    }

    public Output createOutput(OWLIndividual ind) {
        return new OutputImpl(ind);
    }

    public OutputBinding createOutputBinding() {
        return new OutputBindingImpl(this.createInstance(OWLS_1_1.Process.OutputBinding));
    }

    public OutputBinding createOutputBinding(URI uri) {
        return new OutputBindingImpl(this.createInstance(OWLS_1_1.Process.OutputBinding, uri));
    }

    public OutputBinding createOutputBinding(OWLIndividual ind) {
        return new OutputBindingImpl(ind);
    }

    public Perform createPerform() {
        return new PerformImpl(this.createInstance(OWLS_1_1.Process.Perform));
    }

    public Perform createPerform(URI uri) {
        return new PerformImpl(this.createInstance(OWLS_1_1.Process.Perform, uri));
    }

    public Perform createPerform(OWLIndividual ind) {
        return new PerformImpl(ind);
    }

    public Produce createProduce() {
        return this.createProduce(this.createInstance(OWLS_1_1.Process.Produce));
    }

    public Produce createProduce(URI uri) {
        return this.createProduce(this.createInstance(OWLS_1_1.Process.Produce, uri));
    }

    public Produce createProduce(OWLIndividual ind) {
        return new ProduceImpl(ind);
    }

    public Profile createProfile() {
        return this.createProfile(this.createInstance(OWLS_1_1.Profile.Profile));
    }

    public Profile createProfile(URI uri) {
        return this.createProfile(this.createInstance(OWLS_1_1.Profile.Profile, uri));
    }

    public Profile createProfile(OWLIndividual ind) {
        return new ProfileImpl(ind);
    }

    public RepeatUntil createRepeatUntil() {
        return new RepeatUntilImpl(this.createInstance(OWLS_1_1.Process.RepeatUntil));
    }

    public RepeatUntil createRepeatUntil(URI uri) {
        return new RepeatUntilImpl(this.createInstance(OWLS_1_1.Process.RepeatUntil, uri));
    }

    public RepeatUntil createRepeatUntil(OWLIndividual ind) {
        return new RepeatUntilImpl(ind);
    }

    public RepeatWhile createRepeatWhile() {
        return new RepeatWhileImpl(this.createInstance(OWLS_1_1.Process.RepeatWhile));
    }

    public RepeatWhile createRepeatWhile(URI uri) {
        return new RepeatWhileImpl(this.createInstance(OWLS_1_1.Process.RepeatWhile, uri));
    }

    public RepeatWhile createRepeatWhile(OWLIndividual ind) {
        return new RepeatWhileImpl(ind);
    }

    public Result createResult() {
        return new ResultImpl(this.createInstance(OWLS_1_1.Process.Result));
    }

    public Result createResult(URI uri) {
        return new ResultImpl(this.createInstance(OWLS_1_1.Process.Result, uri));
    }

    public Result createResult(OWLIndividual ind) {
        return new ResultImpl(ind);
    }

    public Sequence createSequence() {
        return this.createSequence(this.createInstance(OWLS_1_1.Process.Sequence));
    }

    public Sequence createSequence(URI uri) {
        return this.createSequence(this.createInstance(OWLS_1_1.Process.Sequence, uri));
    }

    public Sequence createSequence(OWLIndividual ind) {
        return new SequenceImpl(ind);
    }

    public Service createService() {
        return this.createService(this.createInstance(OWLS_1_1.Service.Service));
    }

    public Service createService(URI uri) {
        return this.createService(this.createInstance(OWLS_1_1.Service.Service, uri));
    }

    public Service createService(OWLIndividual ind) {
        return new ServiceImpl(ind);
    }

    public ServiceParameter createServiceParameter() {
        return this.createServiceParameter(this.createInstance(OWLS_1_1.Profile.ServiceParameter));
    }

    public ServiceParameter createServiceParameter(URI uri) {
        return this.createServiceParameter(this.createInstance(OWLS_1_1.Profile.ServiceParameter, uri));
    }

    public ServiceParameter createServiceParameter(OWLIndividual ind) {
        return new ServiceParameterImpl(ind);
    }

    public Split createSplit() {
        return this.createSplit(this.createInstance(OWLS_1_1.Process.Split));
    }

    public Split createSplit(URI uri) {
        return this.createSplit(this.createInstance(OWLS_1_1.Process.Split, uri));
    }

    public Split createSplit(OWLIndividual ind) {
        return new SplitImpl(ind);
    }

    public SplitJoin createSplitJoin() {
        return this.createSplitJoin(this.createInstance(OWLS_1_1.Process.SplitJoin));
    }

    public SplitJoin createSplitJoin(URI uri) {
        return this.createSplitJoin(this.createInstance(OWLS_1_1.Process.SplitJoin, uri));
    }

    public SplitJoin createSplitJoin(OWLIndividual ind) {
        return new SplitJoinImpl(ind);
    }

    public UPnPAtomicGrounding createUPnPAtomicGrounding() {
        return this.createUPnPAtomicGrounding(this.createInstance(FLAServiceOnt.UPnPAtomicProcessGrounding));
    }

    public UPnPAtomicGrounding createUPnPAtomicGrounding(URI uri) {
        return this.createUPnPAtomicGrounding(this.createInstance(FLAServiceOnt.UPnPAtomicProcessGrounding, uri));
    }

    public UPnPAtomicGrounding createUPnPAtomicGrounding(OWLIndividual ind) {
        return new UPnPAtomicGroundingImpl(ind);
    }

    public JavaAtomicGrounding createJavaAtomicGrounding() {
        return this.createJavaAtomicGrounding(this.createInstance(OWLetOnt.JavaAtomicProcessGrounding));
    }

    public JavaAtomicGrounding createJavaAtomicGrounding(URI uri) {
        return this.createJavaAtomicGrounding(this.createInstance(OWLetOnt.JavaAtomicProcessGrounding, uri));
    }

    public JavaAtomicGrounding createJavaAtomicGrounding(OWLIndividual ind) {
        return new JavaAtomicGroundingImpl(ind);
    }

    public Grounding createJavaGrounding() {
        return this.createJavaGrounding(this.createInstance(OWLetOnt.JavaGrounding));
    }

    public Grounding createJavaGrounding(URI uri) {
        return this.createJavaGrounding(this.createInstance(OWLetOnt.JavaGrounding, uri));
    }

    public Grounding createJavaGrounding(OWLIndividual ind) {
        return new GroundingImpl(ind);
    }

    public ValueOf createValueOf() {
        return new ValueOfImpl(this.createInstance(OWLS_1_1.Process.ValueOf));
    }

    public ValueOf createValueOf(URI uri) {
        return new ValueOfImpl(this.createInstance(OWLS_1_1.Process.ValueOf, uri));
    }

    public ValueOf createValueOf(OWLIndividual ind) {
        return new ValueOfImpl(ind);
    }

    public ValueData createValueData(OWLValue dataValue) {
        return new ValueDataImpl(dataValue);
    }

    public WSDLAtomicGrounding createWSDLAtomicGrounding() {
        return this.createWSDLAtomicGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlAtomicProcessGrounding));
    }

    public WSDLAtomicGrounding createWSDLAtomicGrounding(URI uri) {
        return this.createWSDLAtomicGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlAtomicProcessGrounding, uri));
    }

    public WSDLAtomicGrounding createWSDLAtomicGrounding(OWLIndividual ind) {
        return new WSDLAtomicGroundingImpl(ind);
    }

    public WSDLOperationRef createWSDLOperationRef() {
        return new WSDLOperationRefImpl(this.createInstance(OWLS_1_1.Grounding.WsdlOperationRef));
    }

    public WSDLOperationRef createWSDLOperationRef(URI uri) {
        return new WSDLOperationRefImpl(this.createInstance(OWLS_1_1.Grounding.WsdlOperationRef, uri));
    }

    public List getServices() {
        return OWLSFactory.wrapList(this.getInstances(OWLS_1_1.Service.Service), Service.class);
    }

    public Service getService(URI serviceURI) {
        OWLIndividual ind = this.getIndividual(serviceURI);
        return ind == null ? null : (Service)ind.castTo(Service.class);
    }

    public List getProfiles() {
        return OWLSFactory.wrapList(this.getInstances(OWLS_1_1.Profile.Profile), Service.class);
    }

    public Profile getProfile(URI profileURI) {
        OWLIndividual ind = this.getIndividual(profileURI);
        return ind == null ? null : (Profile)ind.castTo(Profile.class);
    }

    public List getProcesses() {
        return OWLSFactory.wrapList(this.getInstances(OWLS_1_1.Process.Process), Process.class);
    }

    public List getProcesses(int type) {
        switch (type) {
            case 7: {
                return OWLSFactory.wrapList(this.getInstances(OWLS_1_1.Process.Process), Process.class);
            }
            case 1: {
                return OWLSFactory.wrapList(this.getInstances(OWLS_1_1.Process.AtomicProcess), AtomicProcess.class);
            }
            case 2: {
                return OWLSFactory.wrapList(this.getInstances(OWLS_1_1.Process.CompositeProcess), CompositeProcess.class);
            }
            case 4: {
                return OWLSFactory.wrapList(this.getInstances(OWLS_1_1.Process.SimpleProcess), SimpleProcess.class);
            }
        }
        return null;
    }

    public Process getProcess(URI processURI) {
        OWLIndividual ind = this.getIndividual(processURI);
        return ind == null ? null : (Process)ind.castTo(Process.class);
    }

    public ControlConstructList createControlConstructList(ControlConstruct cc) {
        RDFList list = this.createList(OWLS.CCList, cc);
        return (ControlConstructList)list.castTo(ControlConstructList.class);
    }

    public ControlConstructBag createControlConstructBag(ControlConstruct cc) {
        RDFList list = this.createList(OWLS.CCBag, cc);
        return (ControlConstructBag)list.castTo(ControlConstructBag.class);
    }

    public boolean isLockSupported() {
        return true;
    }

    public void lockForRead() throws LockNotSupportedException {
        this.ontModel.enterCriticalSection(true);
    }

    public void lockForWrite() throws LockNotSupportedException {
        this.ontModel.enterCriticalSection(false);
    }

    public void releaseLock() throws LockNotSupportedException {
        this.ontModel.leaveCriticalSection();
    }

    public OWLWriter getWriter() {
        if (this.writer == null) {
            this.writer = OWLFactory.createWriter();
            this.writer.setNsPrefix("service", OWLS_1_1.Service.URI);
            this.writer.setNsPrefix("profile", OWLS_1_1.Profile.URI);
            this.writer.setNsPrefix("process", OWLS_1_1.Process.URI);
            this.writer.setNsPrefix("grounding", OWLS_1_1.Grounding.URI);
            this.writer.setNsPrefix("expression", OWLS_1_1.Expression.URI);
            this.writer.setNsPrefix("swrl", "http://www.w3.org/2003/11/swrl#");
            this.writer.setNsPrefix("list", URIUtils.getNameSpace(OWLS.ObjList.List().getURI().toString()));
            this.writer.addPrettyType(OWLS_1_1.Service.Service);
            this.writer.addPrettyType(OWLS_1_1.Service.ServiceGrounding);
            this.writer.addPrettyType(OWLS_1_1.Profile.Profile);
            this.writer.addPrettyType(OWLS_1_1.Process.Process);
            this.writer.addPrettyType(OWLS_1_1.Process.AtomicProcess);
            this.writer.addPrettyType(OWLS_1_1.Process.CompositeProcess);
            this.writer.addPrettyType(OWLS_1_1.Process.SimpleProcess);
            this.writer.addPrettyType(OWLS_1_1.Process.Perform);
            this.writer.addPrettyType(OWLS_1_1.Grounding.WsdlGrounding);
            this.writer.addPrettyType(OWLS_1_1.Grounding.WsdlAtomicProcessGrounding);
        }
        return this.writer;
    }

    public void write(Writer out) {
        this.getWriter().write((OWLModel)this, out);
    }

    public void write(Writer out, URI baseURI) {
        this.getWriter().write((OWLModel)this, out, baseURI);
    }

    public void write(OutputStream out) {
        this.getWriter().write((OWLModel)this, out);
    }

    public void write(OutputStream out, URI baseURI) {
        this.getWriter().write((OWLModel)this, out, baseURI);
    }
}

