/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.owl.OWLCacheImpl;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLCache;
import org.mindswap.owl.OWLErrorHandler;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLReader;
import org.mindswap.utils.URIUtils;
import org.xml.sax.InputSource;

public class OWLReaderImpl
implements OWLReader {
    public static boolean DEBUG = false;
    private static Map modelCache = new HashMap();
    private static Set ignores = new HashSet();
    private OWLCache cache;
    private OWLErrorHandler errHandler;
    private RDFReader reader;
    private boolean ignoreFailedImport = false;
    private RDFErrorHandler jenaErrHandler = new RDFErrorHandler(){

        public void warning(Exception e) {
            OWLReaderImpl.this.errHandler.warning(ParseException.formatMessage((Exception)e));
        }

        public void error(Exception e) {
            OWLReaderImpl.this.errHandler.error(ParseException.formatMessage((Exception)e));
        }

        public void fatalError(Exception e) {
            OWLReaderImpl.this.errHandler.error(ParseException.formatMessage((Exception)e));
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    };

    public OWLReaderImpl() {
        this.cache = new OWLCacheImpl();
        this.addIgnoredOntology(URI.create(OWL.getURI()));
        this.addIgnoredOntology(URI.create(RDF.getURI()));
        this.addIgnoredOntology(URI.create(RDFS.getURI()));
        Model m = ModelFactory.createDefaultModel();
        this.reader = m.getReader();
        m = null;
    }

    public OWLCache getCache() {
        return this.cache;
    }

    public void clear() {
        modelCache.clear();
    }

    private InputSource createInputSource(URI uri) throws FileNotFoundException {
        return this.createInputSource(uri, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputSource createInputSource(URI uri, boolean addToCache) throws FileNotFoundException {
        InputSource in = null;
        if (this.cache.isForced()) {
            in = this.cache.getCachedFile(uri.toString());
            if (in == null) {
                try {
                    in = new InputSource(uri.toURL().openConnection().getInputStream());
                    if (!addToCache) return in;
                    this.cache.updateCachedFile(uri);
                    return in;
                }
                catch (Exception e) {
                    System.err.println("WARNING: Cannot read file " + uri);
                    throw new FileNotFoundException("The file " + uri + " cannot be parsed");
                }
            } else {
                this.cache.updateCachedFile(uri);
            }
            return in;
        } else {
            try {
                return new InputSource(uri.toURL().openConnection().getInputStream());
            }
            catch (Exception e) {
                System.err.println("WARNING: Cannot read file " + uri);
                in = this.cache.getCachedFile(uri.toString());
                if (in != null) return in;
                throw new FileNotFoundException("The file " + uri + " cannot be parsed");
            }
        }
    }

    public void setErrorHandler(OWLErrorHandler errHandler) {
        this.errHandler = errHandler;
        if (errHandler == null) {
            this.reader.setErrorHandler(null);
        } else {
            this.reader.setErrorHandler(this.jenaErrHandler);
        }
    }

    public OWLOntology read(URI uri) throws FileNotFoundException {
        return this.read(OWLFactory.createKB(), uri);
    }

    public OWLOntology read(Reader in, URI baseURI) {
        return this.readInternal(OWLFactory.createKB(), new InputSource(in), null, baseURI);
    }

    public OWLOntology read(InputStream in, URI baseURI) {
        return this.readInternal(OWLFactory.createKB(), new InputSource(in), null, baseURI);
    }

    public OWLOntology read(OWLKnowledgeBase kb, URI uri) throws FileNotFoundException {
        InputSource in = this.createInputSource(uri);
        return this.readInternal(kb, in, uri, uri);
    }

    public OWLOntology read(OWLKnowledgeBase kb, Reader in, URI baseURI) {
        return this.readInternal(kb, new InputSource(in), null, baseURI);
    }

    public OWLOntology read(OWLKnowledgeBase kb, InputStream in, URI baseURI) {
        return this.readInternal(kb, new InputSource(in), null, baseURI);
    }

    private OWLOntology readInternal(OWLKnowledgeBase kb, InputSource in, URI physicalURI, URI baseURI) {
        OWLOntology ont = this.readFile((OWLKnowledgeBaseImpl)kb, in, physicalURI, baseURI);
        return kb.load(ont);
    }

    private OWLOntology readImport(OWLKnowledgeBaseImpl kb, URI importURI) throws FileNotFoundException {
        URI fileURI = importURI == null ? null : URIUtils.standardURI(importURI);
        OWLOntology ont = kb.getOntology(fileURI);
        if (ont != null) {
            if (DEBUG) {
                System.out.println("DEBUG: Use already loaded ontology for the URI " + fileURI);
            }
            return ont;
        }
        return this.readFile(kb, this.createInputSource(importURI, true), importURI, importURI);
    }

    private OWLOntology readFile(OWLKnowledgeBaseImpl kb, InputSource in, URI physicalURI, URI baseURI) {
        URI fileURI = physicalURI == null ? null : URIUtils.standardURI(physicalURI);
        OWLOntology ont = kb.getOntology(fileURI);
        if (ont != null) {
            if (DEBUG) {
                System.out.println("DEBUG: Use already loaded ontology for the URI " + fileURI);
            }
            return ont;
        }
        String base = baseURI == null ? null : baseURI.toString();
        ont = (OWLOntology)modelCache.get(fileURI);
        if (ont != null) {
            if (DEBUG) {
                System.out.println("DEBUG: Use already parsed ontology for the URI " + fileURI);
            }
        } else {
            if (DEBUG) {
                System.out.println("DEBUG: Reading " + fileURI);
            }
            Model jenaModel = ModelFactory.createDefaultModel();
            if (in.getByteStream() != null) {
                this.reader.read(jenaModel, in.getByteStream(), base);
            } else {
                this.reader.read(jenaModel, in.getCharacterStream(), base);
            }
            ont = kb.createOntologyWithoutLoading(fileURI, fileURI, jenaModel);
            if (physicalURI != null) {
                modelCache.put(physicalURI, ont);
            }
            StmtIterator i = jenaModel.listStatements(null, OWL.imports, (RDFNode)((Resource)null));
            while (i.hasNext()) {
                Statement stmt = i.nextStatement();
                String importFile = stmt.getResource().toString();
                try {
                    URI importURI = new URI(importFile);
                    OWLOntology importOnt = this.readImport(kb, importURI);
                    ont.addImport(importOnt);
                }
                catch (URISyntaxException e) {
                    System.err.println("WARNING: The import file is not a valid URI: " + importFile);
                }
                catch (FileNotFoundException e) {
                    if (this.errHandler != null) {
                        this.errHandler.warning(e.toString());
                    }
                    System.err.println("WARNING: The import file " + importFile + " cannot be parsed");
                }
            }
        }
        return ont;
    }

    public Set getIgnoredOntologies() {
        return ignores;
    }

    public void addIgnoredOntology(URI uri) {
        ignores.add(URIUtils.standardURI(uri));
    }

    public void setCache(OWLCache cache) {
        this.cache = cache;
    }

    public void setIgnoreFailedImport(boolean ignore) {
        this.ignoreFailedImport = ignore;
    }

    public boolean getIgnoreFailedImport() {
        return this.ignoreFailedImport;
    }
}

