/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import impl.jena.OWLDataTypeImpl;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.vocabulary.XSD;

public class XSDDataTypes {
    private static Impl instance = new Impl();

    public static Set getDataTypes() {
        return instance.getDataTypes();
    }

    public static Map getDataTypeMap() {
        return instance.getDataTypeMap();
    }

    public static OWLDataType getDataType(URI uri) {
        return instance.getDataType(uri);
    }

    private static class Impl
    implements Interface {
        private Map datatypes = new HashMap();

        private Impl() {
            this.datatypes.put(XSD.decimal, new OWLDataTypeImpl(XSD.decimal));
            this.datatypes.put(XSD.xsdString, new OWLDataTypeImpl(XSD.xsdString));
            this.datatypes.put(XSD.xsdBoolean, new OWLDataTypeImpl(XSD.xsdBoolean));
            this.datatypes.put(XSD.xsdFloat, new OWLDataTypeImpl(XSD.xsdFloat));
            this.datatypes.put(XSD.xsdDouble, new OWLDataTypeImpl(XSD.xsdDouble));
            this.datatypes.put(XSD.dateTime, new OWLDataTypeImpl(XSD.dateTime));
            this.datatypes.put(XSD.date, new OWLDataTypeImpl(XSD.date));
            this.datatypes.put(XSD.time, new OWLDataTypeImpl(XSD.time));
            this.datatypes.put(XSD.gYear, new OWLDataTypeImpl(XSD.gYear));
            this.datatypes.put(XSD.gMonth, new OWLDataTypeImpl(XSD.gMonth));
            this.datatypes.put(XSD.gDay, new OWLDataTypeImpl(XSD.gDay));
            this.datatypes.put(XSD.gYearMonth, new OWLDataTypeImpl(XSD.gYearMonth));
            this.datatypes.put(XSD.gMonthDay, new OWLDataTypeImpl(XSD.gMonthDay));
            this.datatypes.put(XSD.duration, new OWLDataTypeImpl(XSD.duration));
            this.datatypes.put(XSD.anyURI, new OWLDataTypeImpl(XSD.anyURI));
            this.datatypes.put(XSD.integer, new OWLDataTypeImpl(XSD.integer));
            this.datatypes.put(XSD.nonPositiveInteger, new OWLDataTypeImpl(XSD.nonPositiveInteger));
            this.datatypes.put(XSD.negativeInteger, new OWLDataTypeImpl(XSD.negativeInteger));
            this.datatypes.put(XSD.nonNegativeInteger, new OWLDataTypeImpl(XSD.nonNegativeInteger));
            this.datatypes.put(XSD.positiveInteger, new OWLDataTypeImpl(XSD.positiveInteger));
            this.datatypes.put(XSD.xsdLong, new OWLDataTypeImpl(XSD.xsdLong));
            this.datatypes.put(XSD.xsdInt, new OWLDataTypeImpl(XSD.xsdInt));
            this.datatypes.put(XSD.xsdShort, new OWLDataTypeImpl(XSD.xsdShort));
            this.datatypes.put(XSD.xsdByte, new OWLDataTypeImpl(XSD.xsdByte));
            this.datatypes.put(XSD.unsignedByte, new OWLDataTypeImpl(XSD.unsignedByte));
            this.datatypes.put(XSD.unsignedShort, new OWLDataTypeImpl(XSD.unsignedShort));
            this.datatypes.put(XSD.unsignedInt, new OWLDataTypeImpl(XSD.unsignedInt));
            this.datatypes.put(XSD.unsignedLong, new OWLDataTypeImpl(XSD.unsignedLong));
            this.datatypes.put(XSD.normalizedString, new OWLDataTypeImpl(XSD.normalizedString));
            this.datatypes.put(XSD.token, new OWLDataTypeImpl(XSD.token));
            this.datatypes.put(XSD.language, new OWLDataTypeImpl(XSD.language));
            this.datatypes.put(XSD.NMTOKEN, new OWLDataTypeImpl(XSD.NMTOKEN));
            this.datatypes.put(XSD.Name, new OWLDataTypeImpl(XSD.Name));
            this.datatypes.put(XSD.NCName, new OWLDataTypeImpl(XSD.NCName));
        }

        public Set getDataTypes() {
            return new HashSet(this.datatypes.values());
        }

        public Map getDataTypeMap() {
            return Collections.unmodifiableMap(this.datatypes);
        }

        public OWLDataType getDataType(URI uri) {
            return (OWLDataType)this.datatypes.get(uri);
        }
    }

    private static interface Interface {
        public Set getDataTypes();

        public Map getDataTypeMap();

        public OWLDataType getDataType(URI var1);
    }
}

